/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.extend;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.controls.DlgControl;
import fr.gouv.finances.cp.xemelios.controls.MainControl;
import fr.gouv.finances.cp.xemelios.controls.models.DocumentControlModel;
import fr.gouv.finances.cp.xemelios.importers.EtatImporteur;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainControlWrapper
implements Runnable {
    private DlgControl dlgControl = null;
    private MainControl mc = null;
    private DocumentModel dmRapport = null;

    public MainControlWrapper(DocumentModel dm, DocumentsModel docsMod) {
        this.mc = new MainControl(dm, docsMod);
        this.dmRapport = docsMod.getDocumentById("DocumentRapport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importer(DocumentModel dm, Pair coll, Pair budg, File f, boolean isRapport, MainControl.Triplet triplet) {
        block6: {
            try {
                Class<?> clazz = Class.forName(dm.getImportClass());
                Object obj = clazz.newInstance();
                if (!(obj instanceof EtatImporteur)) {
                    JOptionPane.showMessageDialog(MainWindow.instance, "Cette classe n'est pas un importeur.\nLe fichier de configuration qui vous a \u00e9t\u00e9 livr\u00e9 est certainement invalide.\nVeuillez contacter votre fournisseur.\n", "Erreur", 0);
                    return;
                }
                EtatImporteur ei = (EtatImporteur)((Object)obj);
                ei.setDocument(dm, coll, budg);
                ArrayList<File> array = new ArrayList<File>();
                array.add(f);
                MainWindow.ImportContent fToImport = new MainWindow.ImportContent();
                fToImport.setFilesToImport(array);
                if (isRapport) {
                    MainWindow.instance.doImport(ei, fToImport, dm, this.dlgControl, triplet, true);
                    break block6;
                }
                MainWindow.instance.doImport(ei, fToImport, dm, true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setDlgControl(DlgControl dlgControl) {
        this.dlgControl = dlgControl;
        this.mc.setControlProgressListener(dlgControl);
    }

    public void writeControlConfigFile() throws IOException {
        this.mc.writeControlConfigFile();
    }

    public DocumentControlModel getDocumentControl() {
        return this.mc.getDocumentControl();
    }

    public void setFileToControl(File fToCtrl) {
        this.mc.setFileToControl(fToCtrl);
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.mc.setParameters(params);
    }

    @Override
    public void run() {
        this.mc.run();
        switch (this.mc.getControlStatus()) {
            case 5: {
                int reponse = JOptionPane.showConfirmDialog(MainWindow.instance, "Le fichier " + this.mc.getFileToControl().getName() + " ne comporte pas d'anomalies.\nSouhaitez-vous quand m\u00eame l'importer?", "Question", 0);
                if (0 == reponse) {
                    this.importer(this.mc.getDocumentModel(), this.mc.getCollectivite(), this.mc.getBudget(), this.mc.getFichierEnrichi(), false, null);
                    this.importer(this.dmRapport, this.mc.getCollectivite(), this.mc.getBudget(), this.mc.getRapport(), true, new MainControl.Triplet(this.mc.getIdRapport(), this.mc.getCollectivite().key, this.mc.getBudget().key));
                    break;
                }
                this.dlgControl.notifyImportFinished(null);
                break;
            }
            case 4: {
                this.importer(this.mc.getDocumentModel(), this.mc.getCollectivite(), this.mc.getBudget(), this.mc.getFichierEnrichi(), false, null);
                this.importer(this.dmRapport, this.mc.getCollectivite(), this.mc.getBudget(), this.mc.getRapport(), true, new MainControl.Triplet(this.mc.getIdRapport(), this.mc.getCollectivite().key, this.mc.getBudget().key));
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.importer(this.dmRapport, new Pair("00000000000000", "Collectivite de Contr\u00f4le"), new Pair("00", "Budget de Contr\u00f4le"), this.mc.getRapport(), true, new MainControl.Triplet(this.mc.getIdRapport(), "00000000000000", "00"));
            }
        }
    }
}

