/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.InvalidPathExpressionException;
import fr.gouv.finances.cp.utils.xml.dompath.DomPath;
import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XPathModel
implements NoeudModifiable {
    private static Logger logger = Logger.getLogger(XPathModel.class);
    private NoeudModifiable _NMParent = null;
    private String tag;
    private StringBuffer path;
    private DomPath domPath = null;
    private NoeudModifiable parent = null;
    private QName qn;
    private String configXPath = null;

    public void setParent(NoeudModifiable parent) {
        this.parent = parent;
    }

    public XPathModel(QName tagName) {
        this.qn = tagName;
        this.tag = this.qn.getLocalPart();
        this.path = new StringBuffer();
    }

    public void addCharacterData(String cData) throws SAXException {
        this.path.append(cData);
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(this.tag);
        output.addCharacterData(this.path.toString());
        output.endTag(this.tag);
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.getPath() == null || this.getPath().length() == 0) {
            throw new InvalidXmlDefinition("//" + this.getTag() + "/text() can not be empty");
        }
    }

    public String getPath() {
        return this.path.toString();
    }

    public String getTag() {
        return this.tag;
    }

    public String getFormattedPath() {
        if (this.path == null) {
            return null;
        }
        return this.path.toString().replace('{', '[').replace('}', ']');
    }

    public DomPath getDomPath(NamespaceContext ns) throws InvalidPathExpressionException {
        if (this.domPath == null) {
            this.domPath = new DomPath(this.path.toString(), ns);
        }
        return this.domPath;
    }

    public XPathModel clone() {
        XPathModel xp = new XPathModel(this.qn);
        xp.path = this.path;
        xp.domPath = this.domPath;
        return xp;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        return null;
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00e0 jour des attributs : " + e));
        }
    }

    public String[] getChildIdAttrName(String childTagName) {
        return null;
    }

    public void resetCharData() {
        this.path.setLength(0);
    }

    public String getIdValue() {
        return null;
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/" + this.tag;
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return null;
    }

    public QName getQName() {
        return this.qn;
    }
}

