/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsMapping;
import fr.gouv.finances.cp.xemelios.common.config.ReferenceModel;
import fr.gouv.finances.cp.xemelios.common.config.TextModel;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VariableModel
implements NoeudModifiable {
    private NoeudModifiable _NMParent = null;
    private static final Logger logger = Logger.getLogger(VariableModel.class);
    public static final String TAG = "variable";
    public static final transient QName QN = new QName("variable");
    private String name;
    private String type;
    private TextModel libelle;
    private ReferenceModel reference;
    private int domain;
    private String configXPath = null;

    public VariableModel(QName tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (DocumentsMapping.LIBELLE.equals(tagName)) {
            this.libelle = (TextModel)child;
            this.libelle.setParentAsNoeudModifiable(this);
        } else if (ReferenceModel.QN.equals(tagName)) {
            this.reference = (ReferenceModel)child;
            this.reference.setParentAsNoeudModifiable(this);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.name = attributes.getValue("name") != null ? attributes.getValue("name") : this.name;
        this.type = attributes.getValue("type") != null ? attributes.getValue("type") : this.type;
        String sTmp = attributes.getValue("domain");
        if ("documents".equals(sTmp)) {
            this.domain = 1;
        } else if ("element".equals(sTmp)) {
            this.domain = 2;
        } else {
            throw new SAXException(sTmp + " is not a valid value for attribute variable/@domain" + "name = " + this.name + " type=" + this.type);
        }
        return this;
    }

    public void marshall(XmlOutputter output) {
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.libelle == null) {
            throw new InvalidXmlDefinition("//variable/libelle is required");
        }
        if (this.libelle.getData() == null || this.libelle.getData().length() == 0) {
            throw new InvalidXmlDefinition("//variable/libelle/text() can not be empty");
        }
        if (this.reference == null) {
            throw new InvalidXmlDefinition("//variable/reference is required");
        }
        this.reference.validate();
        if (this.name == null || this.name.length() == 0) {
            throw new InvalidXmlDefinition("//variable/name can not be null or empty");
        }
        if (this.type == null || this.type.length() == 0) {
            throw new InvalidXmlDefinition("//variable/@type can not be null or empty");
        }
    }

    public VariableModel clone() {
        VariableModel other = new VariableModel(QN);
        try {
            other.addChild((XmlMarshallable)this.libelle.clone(), DocumentsMapping.LIBELLE);
        }
        catch (Throwable t) {
            // empty catch block
        }
        other.type = this.type;
        other.name = this.name;
        other.domain = this.domain;
        try {
            other.addChild((XmlMarshallable)this.reference.clone(), ReferenceModel.QN);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return other;
    }

    public String getName() {
        return this.name;
    }

    public TextModel getLibelle() {
        return this.libelle;
    }

    public ReferenceModel getReference() {
        return this.reference;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return this.getLibelle().getData();
    }

    public int getDomain() {
        return this.domain;
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        if ("libelle".equals(tagName)) {
            return this.libelle;
        }
        if ("reference".equals(tagName)) {
            return this.reference;
        }
        return null;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00e0 jour des attributs : " + e));
        }
    }

    public String[] getChildIdAttrName(String childTagName) {
        return null;
    }

    public String getIdValue() {
        return null;
    }

    public void resetCharData() {
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/variable[@name='" + this.getName() + "']";
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        QName name = new QName(uri, localName);
        if (DocumentsMapping.LIBELLE.equals(name)) {
            return this.libelle;
        }
        if (ReferenceModel.QN.equals(name)) {
            return this.reference;
        }
        return null;
    }

    public QName getQName() {
        return QN;
    }
}

