/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsMapping;
import fr.gouv.finances.cp.xemelios.common.config.XPathModel;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecherchePaireModel
implements NoeudModifiable {
    private static Logger logger = Logger.getLogger(RecherchePaireModel.class);
    public static final int SORT_NO = 0;
    public static final int SORT_KEY = 1;
    public static final int SORT_LIB = 2;
    private NoeudModifiable _NMParent = null;
    private XPathModel path;
    private XPathModel codePath;
    private XPathModel libellePath;
    private String tag;
    private String id;
    private String sort = "no";
    private QName qn;
    private String configXPath = null;

    public RecherchePaireModel(QName tagName) {
        this.qn = tagName;
        this.tag = this.qn.getLocalPart();
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (DocumentsMapping.PATH.equals(tagName)) {
            this.path = (XPathModel)child;
            this.path.setParentAsNoeudModifiable(this);
        } else if (DocumentsMapping.CODE_PATH.equals(tagName)) {
            this.codePath = (XPathModel)child;
            this.codePath.setParentAsNoeudModifiable(this);
        } else if (DocumentsMapping.LIBELLE_PATH.equals(tagName)) {
            this.libellePath = (XPathModel)child;
            this.libellePath.setParentAsNoeudModifiable(this);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.sort = attributes.getValue("sort") != null ? attributes.getValue("sort") : this.sort;
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(this.tag);
        output.addAttribute("sort", this.sort);
        this.path.marshall(output);
        this.codePath.marshall(output);
        this.libellePath.marshall(output);
        output.endTag(this.tag);
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.id == null || this.id.length() == 0) {
            throw new InvalidXmlDefinition("//" + this.tag + "/@id is required (" + this.getParentAsNoeudModifiable().getConfigXPath() + ")/" + this.tag);
        }
        this.path.validate();
        this.codePath.validate();
        this.libellePath.validate();
    }

    public XPathModel getCodePath() {
        return this.codePath;
    }

    public XPathModel getLibellePath() {
        return this.libellePath;
    }

    public XPathModel getPath() {
        return this.path;
    }

    public int getSortBy() {
        if ("no".equals(this.sort)) {
            return 0;
        }
        if ("key".equals(this.sort)) {
            return 1;
        }
        return 2;
    }

    public RecherchePaireModel clone() {
        RecherchePaireModel rpm = new RecherchePaireModel(this.getQName());
        rpm.id = this.id;
        rpm.sort = this.sort;
        try {
            rpm.addChild((XmlMarshallable)this.path.clone(), DocumentsMapping.PATH);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            rpm.addChild((XmlMarshallable)this.codePath.clone(), DocumentsMapping.CODE_PATH);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            rpm.addChild((XmlMarshallable)this.libellePath.clone(), DocumentsMapping.LIBELLE_PATH);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rpm;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00e0 jour des attributs : " + e));
        }
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        if ("path".equals(tagName)) {
            return this.path;
        }
        if ("code-path".equals(tagName)) {
            return this.codePath;
        }
        if ("libelle-path".equals(tagName)) {
            return this.libellePath;
        }
        return null;
    }

    public String[] getChildIdAttrName(String childTagName) {
        return null;
    }

    public String getIdValue() {
        return null;
    }

    public void resetCharData() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/" + this.tag + "[@id='" + this.getId() + "']";
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return null;
    }

    public QName getQName() {
        return this.qn;
    }

    public Collection<Pair> getNewRecipient() {
        int sortBy = this.getSortBy();
        if (sortBy == 0) {
            return new Vector<Pair>();
        }
        Comparator cp = sortBy == 1 ? new Comparator(){

            public int compare(Object o1, Object o2) {
                Pair p1 = (Pair)o1;
                Pair p2 = (Pair)o2;
                return p1.key.compareTo(p2.key);
            }
        } : new Comparator(){

            public int compare(Object o1, Object o2) {
                Pair p1 = (Pair)o1;
                Pair p2 = (Pair)o2;
                return p1.libelle.compareTo(p2.libelle);
            }
        };
        return new TreeSet<Pair>(cp);
    }
}

