/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ParameterModel
implements NoeudModifiable {
    Logger logger = Logger.getLogger(ParameterModel.class);
    private NoeudModifiable _NMParent = null;
    public static final transient String TAG = "parameter";
    public static final transient QName QN = new QName("parameter");
    private String name;
    private String value;
    private String configXPath = null;

    public ParameterModel(QName tagName) {
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void addCharacterData(String cData) throws SAXException {
        this.value = this.value == null ? cData : this.value + cData;
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.name = attributes.getValue("name") != null ? attributes.getValue("name") : this.name;
        this.value = attributes.getValue("value") != null ? attributes.getValue("value") : this.value;
        return null;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("name", StringEscapeUtils.escapeXml(this.name));
        if (this.value.length() < 10) {
            output.addAttribute("value", StringEscapeUtils.escapeXml(this.value));
        } else {
            output.addCharacterData("<![CDATA[" + this.value + "]]>");
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.name == null || this.name.length() == 0) {
            throw new InvalidXmlDefinition("//parameter/@name can not be null or empty (" + this.getParentAsNoeudModifiable().getConfigXPath() + ").");
        }
        if (this.value == null || this.value.length() == 0) {
            throw new InvalidXmlDefinition("//parameter/@value can not be null or empty (" + this.getConfigXPath() + ").");
        }
    }

    public ParameterModel clone() {
        ParameterModel pm = new ParameterModel(QN);
        pm.name = this.name;
        pm.value = this.value;
        return pm;
    }

    public boolean equals(Object other) {
        if (other instanceof ParameterModel) {
            return ((ParameterModel)other).name.equals(this.name);
        }
        return this.equals(other);
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            this.logger.error((Object)("Erreur lors de la mise \u00e0 jour des attributs : " + e));
        }
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        return null;
    }

    public String[] getChildIdAttrName(String childTagName) {
        return null;
    }

    public void resetCharData() {
    }

    public String getIdValue() {
        return this.getName();
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/parameter[@name='" + this.getName() + "']";
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return null;
    }

    public QName getQName() {
        return QN;
    }
}

