/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.CritereModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.EtatModel;
import fr.gouv.finances.cp.xemelios.common.config.PluginModel;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InputModel
implements NoeudModifiable {
    private static Logger logger = Logger.getLogger(InputModel.class);
    private NoeudModifiable _NMParent = null;
    public static final transient String TAG = "input";
    public static final transient QName QN = new QName("input");
    private String id;
    private String libelle;
    private String datatype;
    private String helpPath;
    private String value;
    private String xmlFormat;
    private boolean uppercase = false;
    private CritereModel parent = null;
    private String keyName = null;
    private QName qn;
    private String configXPath = null;

    public void setParent(CritereModel parent) {
        this.parent = parent;
    }

    public boolean isUppercase() {
        return this.uppercase;
    }

    public InputModel(QName tagName) {
        this.qn = tagName;
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id") != null ? attributes.getValue("id") : this.id;
        this.libelle = attributes.getValue("libelle") != null ? attributes.getValue("libelle") : this.libelle;
        String string = this.datatype = attributes.getValue("datatype") != null ? attributes.getValue("datatype") : this.datatype;
        if (attributes.getValue("uppercase") != null) {
            this.uppercase = attributes.getBooleanValue("uppercase");
        }
        this.helpPath = attributes.getValue("help") != null ? attributes.getValue("help") : this.helpPath;
        this.value = attributes.getValue("value") != null ? attributes.getValue("value") : this.value;
        this.xmlFormat = attributes.getValue("xml-format") != null ? attributes.getValue("xml-format") : this.xmlFormat;
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        if (this.libelle != null) {
            output.addAttribute("libelle", StringEscapeUtils.escapeXml(this.libelle));
        }
        output.addAttribute("datatype", this.datatype);
        output.addAttribute("uppercase", this.uppercase);
        if ("date".equals(this.datatype)) {
            output.addAttribute("xml-format", this.xmlFormat);
        }
        if (this.helpPath != null) {
            output.addAttribute("help", this.helpPath);
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.id == null || this.id.length() == 0) {
            throw new InvalidXmlDefinition("//input/@id is required (" + this.getParentAsNoeudModifiable().getConfigXPath() + ")");
        }
    }

    public String getDatatype() {
        return this.datatype;
    }

    public String getId() {
        return this.id;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public String getHelpPath() {
        return this.helpPath;
    }

    public String getXmlDateFormat() {
        if (this.getDatatype().equals("date")) {
            return "yyyy-MM-dd";
        }
        if (this.getDatatype().equals("time")) {
            return "yyyy-MM-dd'T'hh:mm:ss";
        }
        return "";
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public InputModel clone() {
        InputModel im = new InputModel(QN);
        im.id = this.id;
        im.libelle = this.libelle;
        im.datatype = this.datatype;
        im.helpPath = this.helpPath;
        im.uppercase = this.uppercase;
        im.xmlFormat = this.xmlFormat;
        im.value = this.value;
        im._NMParent = this._NMParent;
        return im;
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        return null;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00e0 jour des attributs : " + e));
        }
    }

    public String[] getChildIdAttrName(String childTagName) {
        return null;
    }

    public void resetCharData() {
    }

    public String getIdValue() {
        return this.getId();
    }

    public String getKeyName() {
        if (this.keyName == null) {
            CritereModel cm = (CritereModel)this._NMParent;
            if (cm == null) {
                return null;
            }
            NoeudModifiable o = cm.getParentAsNoeudModifiable();
            ElementModel el = null;
            PluginModel pm = null;
            if (o instanceof ElementModel) {
                el = (ElementModel)o;
            } else if (o instanceof PluginModel) {
                pm = (PluginModel)o;
                el = (ElementModel)pm.getParentAsNoeudModifiable();
            }
            if (el == null) {
                return null;
            }
            EtatModel em = el.getParent();
            if (em == null) {
                return null;
            }
            DocumentModel dm = em.getParent();
            if (dm == null) {
                return null;
            }
            StringBuffer b = new StringBuffer();
            b.append(dm.getId()).append("-").append(em.getId()).append("-");
            if (pm != null) {
                b.append(pm.getId()).append("-");
            }
            b.append(this.getId());
            this.keyName = b.toString();
        }
        return this.keyName;
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/input[@id='" + this.getId() + "']";
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return null;
    }

    public QName getQName() {
        return this.qn;
    }
}

