/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.EnteteModel;
import fr.gouv.finances.cp.xemelios.common.config.EnvironmentDomain;
import fr.gouv.finances.cp.xemelios.common.config.VariableModel;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EtatModel
implements NoeudModifiable,
EnvironmentDomain {
    public static final transient String TAG = "etat";
    public static final transient QName QN = new QName("etat");
    private static Logger logger = Logger.getLogger(EtatModel.class);
    private NoeudModifiable _NMParent = null;
    private Vector<ElementModel> orderedElements;
    private TreeMap<String, ElementModel> elements;
    private Vector<String> entetes = new Vector();
    private HashMap<String, EnteteModel> hEntetes = new HashMap();
    private DocumentModel parent;
    private String id;
    private String titre;
    private String balise;
    private String xslt;
    private String searchableElement;
    private String browsableElement;
    private String importableElement;
    private String displayInMenuIf;
    private boolean useExternalBrowser = true;
    private boolean browsable = false;
    private boolean searchable = true;
    private boolean multiPage = false;
    private Vector<EnvironmentDomain> vElements;
    private boolean exportable = false;
    private String transformClass;
    private String configXPath = null;

    public boolean isExportable() {
        return this.exportable;
    }

    public void setExportable(boolean exportable) {
        this.exportable = exportable;
    }

    public EtatModel(QName tagName) {
        this.elements = new TreeMap();
        this.orderedElements = new Vector();
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (ElementModel.QN.equals(tagName)) {
            ElementModel element = (ElementModel)child;
            if (this.elements.containsKey(element.getId())) {
                ElementModel old = this.elements.get(element.getId());
                this.elements.remove(old.getId());
                this.orderedElements.remove(old);
            }
            element.setParent(this);
            element.setParentAsNoeudModifiable(this);
            this.elements.put(element.getId(), element);
            this.orderedElements.add(element);
        } else if (EnteteModel.QN.equals(tagName)) {
            EnteteModel em = (EnteteModel)child;
            if (this.hEntetes.containsKey(em.getId())) {
                EnteteModel old = this.hEntetes.get(em.getId());
                this.entetes.remove(old.getBalise());
                this.hEntetes.remove(old.getId());
            }
            em.setParentAsNoeudModifiable(this);
            this.entetes.add(em.getBalise());
            this.hEntetes.put(em.getId(), em);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id") != null ? attributes.getValue("id") : this.id;
        this.titre = attributes.getValue("titre") != null ? attributes.getValue("titre") : this.titre;
        this.balise = attributes.getValue("balise") != null ? attributes.getValue("balise") : this.balise;
        String string = this.xslt = attributes.getValue("xslt-file") != null ? attributes.getValue("xslt-file") : this.xslt;
        if (attributes.getValue("use-external-browser") != null) {
            this.useExternalBrowser = attributes.getBooleanValue("use-external-browser");
        }
        if (attributes.getValue("browsable") != null) {
            this.browsable = attributes.getBooleanValue("browsable");
        }
        if (attributes.getValue("searchable") != null) {
            this.searchable = attributes.getBooleanValue("searchable");
        }
        if (attributes.getValue("multi-page") != null) {
            this.multiPage = attributes.getBooleanValue("multi-page");
        }
        this.searchableElement = attributes.getValue("searchable-element") != null ? attributes.getValue("searchable-element") : this.searchableElement;
        this.browsableElement = attributes.getValue("browsable-element") != null ? attributes.getValue("browsable-element") : this.browsableElement;
        this.importableElement = attributes.getValue("importable-element") != null ? attributes.getValue("importable-element") : this.importableElement;
        this.displayInMenuIf = attributes.getValue("displayInMenuIf");
        if (attributes.getValue("exportable") != null) {
            this.exportable = attributes.getBooleanValue("exportable");
        }
        this.transformClass = attributes.getValue("transform-class") != null ? attributes.getValue("transform-class") : this.transformClass;
        return this;
    }

    public void marshall(XmlOutputter output) {
        throw new Error("Not yet implemented");
    }

    public void validate() throws InvalidXmlDefinition {
        File f;
        if (this.id == null) {
            throw new InvalidXmlDefinition("//etat/@id is required (" + this.getParentAsNoeudModifiable().getConfigXPath() + ")");
        }
        if (this.balise == null || this.balise.length() == 0) {
            throw new InvalidXmlDefinition("//etat/@balise is reguired (" + this.getConfigXPath() + ")");
        }
        if (this.titre == null || this.titre.length() == 0) {
            throw new InvalidXmlDefinition("//etat/@titre is reguired (" + this.getConfigXPath() + ")");
        }
        if (this.xslt != null && !(f = new File(new File(this.getParent().getBaseDirectory()), this.xslt)).exists()) {
            throw new InvalidXmlDefinition(f.getAbsolutePath() + " can not be found");
        }
        for (ElementModel element : this.elements.values()) {
            element.validate();
        }
    }

    public String getBalise() {
        return this.balise;
    }

    public String getId() {
        return this.id;
    }

    public String getIdValue() {
        return this.getId();
    }

    public String getTitre() {
        return this.titre;
    }

    public String getXslt() {
        return this.xslt;
    }

    public Vector<String> getEntetes() {
        return this.entetes;
    }

    public DocumentModel getParent() {
        return this.parent;
    }

    protected void setParent(DocumentModel parent) {
        this.parent = parent;
    }

    public EtatModel clone(DocumentModel otherParent) {
        EtatModel em = new EtatModel(QN);
        for (ElementModel element : this.elements.values()) {
            try {
                em.addChild((XmlMarshallable)element.clone(), ElementModel.QN);
            }
            catch (Throwable t) {}
        }
        for (String s : this.hEntetes.keySet()) {
            try {
                em.addChild((XmlMarshallable)this.hEntetes.get(s).clone(), EnteteModel.QN);
            }
            catch (Throwable t) {}
        }
        em.parent = otherParent;
        em.id = this.id;
        em.titre = this.titre;
        em.balise = this.balise;
        em.xslt = this.xslt;
        em.browsable = this.browsable;
        em.searchable = this.searchable;
        em.browsableElement = this.browsableElement;
        em.importableElement = this.importableElement;
        em.multiPage = this.multiPage;
        em.searchableElement = this.searchableElement;
        em.useExternalBrowser = this.useExternalBrowser;
        em._NMParent = this._NMParent;
        em.exportable = this.exportable;
        em.transformClass = this.transformClass;
        return em;
    }

    public EtatModel clone() {
        return this.clone(this.parent);
    }

    public boolean useExternalBrowser() {
        return this.useExternalBrowser;
    }

    public boolean isBrowsable() {
        return this.browsable;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public ElementModel getElementById(String elementId) {
        return this.elements.get(elementId);
    }

    public ElementModel getDefaultElement() {
        return this.elements.values().iterator().next();
    }

    public Collection<ElementModel> getSearchableElements() {
        ArrayList<ElementModel> ret = new ArrayList<ElementModel>();
        for (ElementModel em : this.orderedElements) {
            if (!em.isSearchable()) continue;
            ret.add(em);
        }
        return ret;
    }

    public ElementModel getBrowsableElement() {
        if (this.browsableElement != null) {
            return this.getElementById(this.browsableElement);
        }
        return this.getDefaultElement();
    }

    public ElementModel getImportableElement() {
        if (this.importableElement != null) {
            return this.getElementById(this.importableElement);
        }
        return this.getDefaultElement();
    }

    public boolean isMultiPage() {
        return this.multiPage;
    }

    @Override
    public EnvironmentDomain getChildAt(int domain, int pos) {
        if (this.vElements == null) {
            this.vElements = new Vector();
            this.vElements.addAll(this.orderedElements);
        }
        return this.vElements.elementAt(pos);
    }

    @Override
    public boolean hasEnvironment(int domain) {
        return false;
    }

    @Override
    public Enumeration<VariableModel> getVariables(int domain) {
        return null;
    }

    @Override
    public int getChildCount(int domain) {
        return this.elements.size();
    }

    @Override
    public Enumeration<EnvironmentDomain> children(int domain) {
        if (this.vElements == null) {
            this.vElements = new Vector();
            this.vElements.addAll(this.elements.values());
        }
        return this.vElements.elements();
    }

    public String toString() {
        return this.titre;
    }

    @Override
    public Object getValue(String path) throws DataConfigurationException {
        String sTmp = path.startsWith("/") ? path.substring(1) : path;
        if (sTmp.startsWith("element")) {
            int pos = sTmp.indexOf(47);
            String next = sTmp.substring(pos);
            String condition = sTmp.substring("element".length(), pos);
            if (condition.startsWith("[") && condition.endsWith("]")) {
                condition = condition.substring(1, condition.length() - 1);
            }
            if (condition.startsWith("@id=")) {
                String elementId = condition.substring(5, condition.length() - 1);
                ElementModel em = this.getElementById(elementId);
                return em.getValue(next);
            }
            throw new DataConfigurationException("can only access to element by id");
        }
        throw new DataConfigurationException("from etat, you can only access to element(s)");
    }

    @Override
    public void setValue(String path, Object value) throws DataConfigurationException {
        String condition;
        String next;
        String sTmp = path.startsWith("/") ? path.substring(1) : path;
        if (sTmp.startsWith("element")) {
            int pos = sTmp.indexOf(47);
            next = sTmp.substring(pos);
            condition = sTmp.substring("element".length(), pos);
            if (condition.startsWith("[") && condition.endsWith("]")) {
                condition = condition.substring(1, condition.length() - 1);
            }
            if (!condition.startsWith("@id=")) {
                throw new DataConfigurationException("can only access to element by id");
            }
        } else {
            throw new DataConfigurationException("from etat, you can only access to element(s)");
        }
        String elementId = condition.substring(5, condition.length() - 1);
        ElementModel em = this.getElementById(elementId);
        em.setValue(next, value);
    }

    public String getDisplayInMenuIf() {
        return this.displayInMenuIf;
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        if ("element".equals(tagName)) {
            return this.elements.get(id);
        }
        if ("entete".equals(tagName)) {
            return this.hEntetes.get(id);
        }
        return null;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00e0 jour des attributs : " + e));
        }
    }

    public String[] getChildIdAttrName(String childTagName) {
        if ("element".equals(childTagName)) {
            return new String[]{"id"};
        }
        if ("entete".equals(childTagName)) {
            return new String[]{"id"};
        }
        return null;
    }

    public void resetCharData() {
    }

    public TreeMap<String, ElementModel> getElements() {
        return this.elements;
    }

    public String getTransformClass() {
        return this.transformClass;
    }

    public void setTransformClass(String transformClass) {
        this.transformClass = transformClass;
    }

    public Element createSmallDOM(Document doc) {
        Element ret = doc.createElementNS("http://projets.admisource.gouv.fr/xemelios/namespaces#config", "conf:etat");
        ret.setAttribute("id", this.getId());
        ret.setAttribute("libelle", this.getTitre());
        for (ElementModel em : this.orderedElements) {
            Element el = em.createSmallDOM(doc);
            ret.appendChild(el);
        }
        return ret;
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/etat[@id='" + this.getId() + "']";
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        QName name = new QName(uri, localName);
        if (ElementModel.QN.equals(name)) {
            return (XmlMarshallable)this.elements.get(atts.getValue("id"));
        }
        if (EnteteModel.QN.equals(name)) {
            return (XmlMarshallable)this.hEntetes.get(atts.getValue("id"));
        }
        return null;
    }

    public QName getQName() {
        return QN;
    }
}

