/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.EnvironmentDomain;
import fr.gouv.finances.cp.xemelios.common.config.VariableModel;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentsModel
implements XmlMarshallable,
EnvironmentDomain {
    public static final transient String TAG = "documents";
    public static final transient QName QN = new QName("documents");
    TreeSet<DocumentModel> documents;
    Hashtable<String, DocumentModel> docsById;
    Vector<EnvironmentDomain> vDocuments;
    private Document smallDOM;
    private QName qn;

    public DocumentsModel(QName tag) {
        this.qn = tag;
        this.documents = new TreeSet();
        this.vDocuments = new Vector();
        this.docsById = new Hashtable();
    }

    public void addCharacterData(String cData) throws SAXException {
        throw new SAXException("pas de CDATA attendu");
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        DocumentModel dm;
        if (DocumentModel.QN.equals(tagName)) {
            dm = (DocumentModel)child;
            if (this.docsById.containsKey(dm.getId())) {
                DocumentModel old = this.docsById.get(dm.getId());
                this.documents.remove(old);
                this.vDocuments.remove(old);
                this.docsById.remove(old.getId());
            }
        } else {
            throw new SAXException(tagName + ": tag non attendu");
        }
        this.documents.add(dm);
        this.vDocuments.add(dm);
        this.docsById.put(dm.getId(), dm);
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        return this;
    }

    public void marshall(XmlOutputter output) {
        throw new Error("Not yet implemented");
    }

    public void validate() throws InvalidXmlDefinition {
        for (DocumentModel dm : this.documents) {
            dm.validate();
        }
    }

    public TreeSet<DocumentModel> getDocuments() {
        return this.documents;
    }

    public DocumentModel getDocumentById(String docId) {
        return this.docsById.get(docId);
    }

    public DocumentsModel clone() {
        DocumentsModel dom = new DocumentsModel(QN);
        for (DocumentModel dm : this.documents) {
            try {
                dom.addChild((XmlMarshallable)dm.clone(), DocumentModel.QN);
            }
            catch (Throwable t) {}
        }
        return dom;
    }

    @Override
    public EnvironmentDomain getChildAt(int domain, int pos) {
        Iterator<DocumentModel> it = this.documents.iterator();
        for (int i = 0; i < pos; ++i) {
            it.next();
        }
        return it.next();
    }

    @Override
    public boolean hasEnvironment(int domain) {
        return false;
    }

    @Override
    public Enumeration<VariableModel> getVariables(int domain) {
        return null;
    }

    @Override
    public int getChildCount(int domain) {
        return this.documents.size();
    }

    @Override
    public Enumeration<EnvironmentDomain> children(int domain) {
        return this.vDocuments.elements();
    }

    public String toString() {
        return TAG;
    }

    @Override
    public Object getValue(String path) throws DataConfigurationException {
        String sTmp = path.startsWith(TAG) ? path.substring(TAG.length()) : path;
        if (sTmp.startsWith("/")) {
            sTmp = sTmp.substring(1);
        }
        if (sTmp.startsWith("@")) {
            throw new DataConfigurationException(path + " is not significant on " + DocumentsModel.class.getName());
        }
        if (sTmp.startsWith("document")) {
            int pos = sTmp.indexOf("/");
            String next = sTmp.substring(pos);
            String condition = sTmp.substring("document".length(), pos);
            if (condition.startsWith("[") && condition.endsWith("]")) {
                condition = condition.substring(1, condition.length() - 1).trim();
            }
            if (condition.startsWith("@id=")) {
                String documentId = condition.substring(5, condition.length() - 1);
                DocumentModel dm = this.getDocumentById(documentId);
                return dm.getValue(next);
            }
            throw new DataConfigurationException(condition + " is not valid to access to " + "document");
        }
        throw new DataConfigurationException(sTmp + " : invalid path on " + DocumentsModel.class.getName());
    }

    @Override
    public void setValue(String path, Object value) throws DataConfigurationException {
        String condition;
        String next;
        String sTmp = path.startsWith(TAG) ? path.substring(TAG.length()) : path;
        if (sTmp.startsWith("/")) {
            sTmp = sTmp.substring(1);
        }
        if (sTmp.startsWith("@")) {
            throw new DataConfigurationException(path + " is not significant on " + DocumentsModel.class.getName());
        }
        if (sTmp.startsWith("document")) {
            int pos = sTmp.indexOf("/");
            next = sTmp.substring(pos);
            condition = sTmp.substring("document".length(), pos);
            if (condition.startsWith("[") && condition.endsWith("]")) {
                condition = condition.substring(1, condition.length() - 1).trim();
            }
            if (!condition.startsWith("@id=")) {
                throw new DataConfigurationException(condition + " is not valid to access to " + "document");
            }
        } else {
            throw new DataConfigurationException(sTmp + " : invalid path on " + DocumentsModel.class.getName());
        }
        String documentId = condition.substring(5, condition.length() - 1);
        DocumentModel dm = this.getDocumentById(documentId);
        dm.setValue(next, value);
    }

    public Vector<ElementModel> getElementsById(String elementId) {
        Vector<ElementModel> ret = new Vector<ElementModel>();
        for (DocumentModel dm : this.documents) {
            ret.addAll(dm.getElementsById(elementId));
        }
        return ret;
    }

    private void createSmallDOM() {
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            Document doc = domBuilder.newDocument();
            Element documents = doc.createElementNS("http://projets.admisource.gouv.fr/xemelios/namespaces#config", "conf:documents");
            doc.appendChild(documents);
            for (DocumentModel dm : this.getDocuments()) {
                Element document = dm.createSmallDOM(doc);
                documents.appendChild(document);
            }
            this.smallDOM = doc;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public Document getSmallDOM() {
        if (this.smallDOM == null) {
            this.createSmallDOM();
        }
        return this.smallDOM;
    }

    public Vector<DocumentModel> getVisibleDocs() {
        Vector<DocumentModel> vRet = new Vector<DocumentModel>();
        for (DocumentModel dm : this.documents) {
            if (dm.getDisplayInMenuIf() != null && !"true".equals(System.getProperty(dm.getDisplayInMenuIf()))) continue;
            vRet.add(dm);
        }
        return vRet;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        if (atts.getValue("extends") != null) {
            return this.docsById.get(atts.getValue("extends")).clone();
        }
        return (XmlMarshallable)this.docsById.get(atts.getValue("id"));
    }

    public QName getQName() {
        return this.qn;
    }
}

