/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsMapping;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentsDeriveParser
extends DefaultHandler {
    private static Logger logger = Logger.getLogger(DocumentsDeriveParser.class);
    NoeudModifiable current;
    NoeudModifiable oldCurrent = null;
    boolean inConstruction = false;
    String closeConstructionOn = null;
    String baseDirectory;
    private HashMap<QName, Class> mapping;
    private DocumentsModel dmsReference = null;
    private DocumentModel dmEnrichi = null;

    public DocumentModel getDmEnrichi() {
        return this.dmEnrichi;
    }

    public DocumentsDeriveParser(DocumentsModel dm, String baseDir) {
        this.dmsReference = dm;
        this.baseDirectory = baseDir;
        this.mapping = new DocumentsMapping();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("documents-derives".equals(localName)) {
            return;
        }
        if ("document".equals(localName)) {
            if (this.dmsReference == null || this.dmsReference.getDocuments().size() == 0) {
                throw new SAXException("Aucun document n'est disponible pour h\u00e9ritage.");
            }
            String extendsId = attributes.getValue("extends");
            DocumentModel dmEtendu = this.dmsReference.getDocumentById(extendsId);
            if (dmEtendu == null) {
                throw new SAXException("Configuration de " + extendsId + " introuvable");
            }
            this.dmEnrichi = dmEtendu.clone();
            this.current = this.dmEnrichi;
            this.current.modifyAttrs(attributes);
            this.dmEnrichi.setBaseDirectory(this.baseDirectory);
            this.dmEnrichi.setExtendedDocId(extendsId);
        } else {
            NoeudModifiable child = null;
            String clef = "";
            String[] ob = this.current.getChildIdAttrName(localName);
            if (ob != null) {
                String[] clefs;
                for (String c : clefs = ob) {
                    clef = clef + attributes.getValue(c) + "|";
                }
                if (clef.endsWith("|")) {
                    clef = clef.substring(0, clef.length() - 1);
                }
            }
            if ((child = this.current.getChildAsNoeudModifiable(localName, clef)) == null || this.inConstruction) {
                try {
                    Class[] paramTypes = new Class[]{String.class};
                    Class clazz = this.mapping.get(localName);
                    Constructor ctr = clazz.getConstructor(paramTypes);
                    Object[] params = new Object[]{localName};
                    NoeudModifiable nouveau = (NoeudModifiable)ctr.newInstance(params);
                    nouveau.getAttributes(new XmlAttributes(attributes));
                    this.current = nouveau;
                    this.closeConstructionOn = localName;
                    this.inConstruction = true;
                }
                catch (Exception e) {
                    logger.error((Object)("Erreur lors de la cr\u00e9ation du noeud (" + localName + ") : "), (Throwable)e);
                    throw new SAXException(e);
                }
            } else {
                this.current = child;
                this.current.modifyAttrs(attributes);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("documents-derives".equals(localName)) {
            return;
        }
        if ("document".equals(localName)) {
            this.dmsReference.addChild((XmlMarshallable)this.dmEnrichi, DocumentModel.QN);
        } else {
            this.current = this.current.getParentAsNoeudModifiable();
            if (this.inConstruction && localName.equals(this.closeConstructionOn)) {
                this.inConstruction = false;
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.current != null) {
            if (!this.current.equals(this.oldCurrent)) {
                this.current.resetCharData();
                this.oldCurrent = this.current;
            }
            this.current.addCharacterData(new String(ch, start, length));
        } else {
            super.characters(ch, start, length);
        }
    }
}

