/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsMapping;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.EnteteModel;
import fr.gouv.finances.cp.xemelios.common.config.EnvironmentDomain;
import fr.gouv.finances.cp.xemelios.common.config.EtatModel;
import fr.gouv.finances.cp.xemelios.common.config.NamespaceModel;
import fr.gouv.finances.cp.xemelios.common.config.OptionModel;
import fr.gouv.finances.cp.xemelios.common.config.ParametersModel;
import fr.gouv.finances.cp.xemelios.common.config.RecherchePaireModel;
import fr.gouv.finances.cp.xemelios.common.config.SpecialKeyModel;
import fr.gouv.finances.cp.xemelios.common.config.TraitementExterneModel;
import fr.gouv.finances.cp.xemelios.common.config.VariableModel;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentModel
implements NoeudModifiable,
EnvironmentDomain,
Comparable {
    public static final transient String TAG = "document";
    public static final transient QName QN = new QName("document");
    public static final transient String DEFAULT_LIBELLE_COLLECTIVITE = "Collectivit\u00e9";
    private static Logger logger = Logger.getLogger(DocumentModel.class);
    private NoeudModifiable _NMParent = null;
    private String configXPath = null;
    private Vector<EtatModel> etats;
    private HashMap<String, EtatModel> hEtats;
    private Vector<EnvironmentDomain> vEtats;
    private Vector<String> entetes;
    private Vector<Pair> defaultBudgets;
    private HashMap<String, OptionModel> hDefaultBudgets;
    private Vector<SpecialKeyModel> specialKeys;
    private HashMap<String, SpecialKeyModel> hSpecialKeys;
    private HashMap<String, EnteteModel> hEnteteModels;
    private String id;
    private String extension;
    private String schema;
    private String titre;
    private String balise;
    private String referentiel;
    private String importClass;
    private String indexCreation;
    private String libelleExtension;
    private String referentielXsltFile;
    private String defaultBrowsableEtat;
    private String referentielImportTransfo;
    private String persistenceConfigFile;
    private String globalImportXsltFile;
    private String globalUriTransformer;
    private RecherchePaireModel collectivitePath;
    private RecherchePaireModel budgetPath;
    private RecherchePaireModel referenceNomenclaturePath;
    private NamespaceModel namespaces = null;
    private boolean browsable = false;
    private boolean isControlable = false;
    private boolean groupMenuItems = true;
    private String controlConfigFile;
    private ParametersModel parameters;
    private String extendsDocId;
    private String pjNamespaceUri;
    private String displayInMenuIf;
    private String defaultEtatGlobal;
    private String libelleCollectivite = "Collectivit\u00e9";
    private int ordrePresentation = 1000;
    private Vector<TraitementExterneModel> traitementExternes;
    private HashMap<String, TraitementExterneModel> hTraitementExternes;
    private String baseDirectory = null;
    private QName qn;

    public DocumentModel(QName tagName) {
        this.qn = tagName;
        this.etats = new Vector();
        this.hEtats = new HashMap();
        this.vEtats = new Vector();
        this.entetes = new Vector();
        this.hEnteteModels = new HashMap();
        this.defaultBudgets = new Vector();
        this.hDefaultBudgets = new HashMap();
        this.specialKeys = new Vector();
        this.hSpecialKeys = new HashMap();
        this.traitementExternes = new Vector();
        this.hTraitementExternes = new HashMap();
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (EnteteModel.QN.equals(tagName)) {
            EnteteModel em = (EnteteModel)child;
            if (this.hEnteteModels.containsKey(em.getId())) {
                EnteteModel old = this.hEnteteModels.get(em.getId());
                this.entetes.remove(old.getBalise());
                this.hEnteteModels.remove(old.getId());
            }
            em.setParentAsNoeudModifiable(this);
            String key = ((EnteteModel)child).getBalise();
            this.entetes.add(key);
            this.hEnteteModels.put(em.getId(), em);
        } else if (EtatModel.QN.equals(tagName)) {
            EtatModel etat = (EtatModel)child;
            if (this.hEtats.containsKey(etat.getId())) {
                EtatModel old = this.hEtats.get(etat.getId());
                this.etats.remove(old);
                this.vEtats.remove(old);
                this.hEtats.remove(old.getId());
            }
            etat.setParent(this);
            etat.setParentAsNoeudModifiable(this);
            this.etats.add(etat);
            this.vEtats.add(etat);
            this.hEtats.put(etat.getId(), etat);
        } else if (DocumentsMapping.BUDGET_PATH.equals(tagName)) {
            this.budgetPath = (RecherchePaireModel)child;
            this.budgetPath.setParentAsNoeudModifiable(this);
        } else if (DocumentsMapping.REFERENCE_NOMENCLATURE_PATH.equals(tagName)) {
            this.referenceNomenclaturePath = (RecherchePaireModel)child;
            this.referenceNomenclaturePath.setParentAsNoeudModifiable(this);
        } else if (DocumentsMapping.COLLECTIVITE_PATH.equals(tagName)) {
            this.collectivitePath = (RecherchePaireModel)child;
            this.collectivitePath.setParentAsNoeudModifiable(this);
        } else if (DocumentsMapping.DEFAULT_BUDGET.equals(tagName)) {
            OptionModel om = (OptionModel)child;
            if (this.hDefaultBudgets.containsKey(om.getValue())) {
                OptionModel old = this.hDefaultBudgets.get(om.getValue());
                this.defaultBudgets.remove(new Pair(old.getValue(), old.getLibelle()));
                this.hDefaultBudgets.remove(old.getValue());
            }
            om.setParentAsNoeudModifiable(this);
            Pair p = new Pair(om.getValue(), om.getLibelle());
            this.defaultBudgets.add(p);
            this.hDefaultBudgets.put(om.getValue(), om);
        } else if (SpecialKeyModel.QN.equals(tagName)) {
            SpecialKeyModel skm = (SpecialKeyModel)child;
            if (this.hSpecialKeys.containsKey(skm.getId())) {
                SpecialKeyModel old = this.hSpecialKeys.get(skm.getId());
                this.specialKeys.remove(old);
                this.hSpecialKeys.remove(old.getId());
            }
            skm.setParentAsNoeudModifiable(this);
            this.specialKeys.add(skm);
            this.hSpecialKeys.put(skm.getId(), skm);
        } else if (NamespaceModel.QN.equals(tagName)) {
            this.namespaces = (NamespaceModel)child;
            this.namespaces.setParentAsNoeudModifiable(this);
        } else if (ParametersModel.QN.equals(tagName)) {
            this.parameters = (ParametersModel)child;
            this.parameters.setParentAsNoeudModifiable(this);
        } else if (TraitementExterneModel.QN.equals(tagName)) {
            TraitementExterneModel traitementExterne = (TraitementExterneModel)child;
            if (this.hTraitementExternes.containsKey(traitementExterne.getId())) {
                TraitementExterneModel old = this.hTraitementExternes.get(traitementExterne.getId());
                this.traitementExternes.remove(old);
                this.hTraitementExternes.remove(old.getId());
            }
            traitementExterne.setParentAsNoeudModifiable(this);
            this.traitementExternes.add(traitementExterne);
            this.hTraitementExternes.put(traitementExterne.getId(), traitementExterne);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        String newId = attributes.getValue("id");
        if (!(newId == null || this.id != null && this.id.equals(newId))) {
            this.id = attributes.getValue("id");
            this.baseDirectory = null;
        }
        this.extension = attributes.getValue("extension") != null ? attributes.getValue("extension") : this.extension;
        this.schema = attributes.getValue("schema") != null ? attributes.getValue("schema") : this.schema;
        this.titre = attributes.getValue("titre") != null ? attributes.getValue("titre") : this.titre;
        this.balise = attributes.getValue("balise") != null ? attributes.getValue("balise") : this.balise;
        this.referentiel = attributes.getValue("referentiel") != null ? attributes.getValue("referentiel") : this.referentiel;
        this.importClass = attributes.getValue("import-class") != null ? attributes.getValue("import-class") : this.importClass;
        this.indexCreation = attributes.getValue("index-creation") != null ? attributes.getValue("index-creation") : this.indexCreation;
        this.libelleExtension = attributes.getValue("libelle-extension") != null ? attributes.getValue("libelle-extension") : this.libelleExtension;
        String string = this.referentielXsltFile = attributes.getValue("referentiel-xslt-file") != null ? attributes.getValue("referentiel-xslt-file") : this.referentielXsltFile;
        if (attributes.getValue("browsable") != null) {
            this.browsable = attributes.getBooleanValue("browsable");
        }
        if (attributes.getValue("isControlable") != null) {
            this.isControlable = attributes.getBooleanValue("isControlable");
        }
        this.defaultBrowsableEtat = attributes.getValue("default-browsable-etat") != null ? attributes.getValue("default-browsable-etat") : this.defaultBrowsableEtat;
        this.referentielImportTransfo = attributes.getValue("referentiel-import-xslt") != null ? attributes.getValue("referentiel-import-xslt") : this.referentielImportTransfo;
        String string2 = this.persistenceConfigFile = attributes.getValue("persistence-config") != null ? attributes.getValue("persistence-config") : this.persistenceConfigFile;
        if (attributes.getValue("menu-grouping") != null) {
            this.groupMenuItems = "group".equals(attributes.getValue("menu-grouping"));
        }
        this.controlConfigFile = attributes.getValue("control-config-file") != null ? attributes.getValue("control-config-file") : this.controlConfigFile;
        this.pjNamespaceUri = attributes.getValue("pj-namespace-uri") != null ? attributes.getValue("pj-namespace-uri") : this.pjNamespaceUri;
        this.setDisplayInMenuIf(attributes.getValue("displayInMenuIf"));
        if (attributes.getValue("ordre-presentation") != null) {
            this.ordrePresentation = attributes.getIntValue("ordre-presentation");
        }
        this.globalImportXsltFile = attributes.getValue("global-import-xslt-file") != null ? attributes.getValue("global-import-xslt-file") : this.globalImportXsltFile;
        this.globalUriTransformer = attributes.getValue("global-uri-transformer") != null ? attributes.getValue("global-uri-transformer") : this.globalUriTransformer;
        this.extendsDocId = attributes.getValue("extends") != null ? attributes.getValue("extends") : this.extendsDocId;
        this.defaultEtatGlobal = attributes.getValue("default-etat-global") != null ? attributes.getValue("default-etat-global") : this.defaultEtatGlobal;
        this.libelleCollectivite = attributes.getValue("libelle-collectivite") != null ? attributes.getValue("libelle-collectivite") : this.libelleCollectivite;
        return this;
    }

    public void marshall(XmlOutputter output) {
        throw new Error("Not yet implemented");
    }

    public void validate() throws InvalidXmlDefinition {
        File f;
        if (this.namespaces == null) {
            throw new InvalidXmlDefinition("namespaces is required.");
        }
        this.namespaces.validate();
        if (this.specialKeys.size() >= 3) {
            throw new InvalidXmlDefinition("<document> must not have more than 3 <special-key/>.");
        }
        TreeSet<Integer> spIndices = new TreeSet<Integer>();
        for (SpecialKeyModel skm : this.specialKeys) {
            spIndices.add(new Integer(skm.getPos()));
            skm.validate();
        }
        if (spIndices.size() != this.specialKeys.size()) {
            throw new InvalidXmlDefinition("//special-key/@pos must be uniques in a <document> element.");
        }
        int i = 1;
        for (Integer count : spIndices) {
            if (count != i) {
                throw new InvalidXmlDefinition("//special-key/@pos attributes must start at 1 and be consecutives");
            }
            ++i;
        }
        for (OptionModel om : this.hDefaultBudgets.values()) {
            om.validate();
        }
        if (this.collectivitePath != null) {
            this.collectivitePath.validate();
        }
        if (this.budgetPath != null) {
            this.budgetPath.validate();
        }
        if (this.referenceNomenclaturePath != null) {
            this.referenceNomenclaturePath.validate();
        }
        if (this.parameters != null) {
            this.parameters.validate();
        }
        for (EtatModel em : this.etats) {
            em.validate();
        }
        if (this.persistenceConfigFile != null && !(f = new File(new File(this.getBaseDirectory()), this.persistenceConfigFile)).exists()) {
            throw new InvalidXmlDefinition("file " + f.getAbsolutePath() + " can not be found");
        }
        if (this.referentielXsltFile != null && !(f = new File(new File(this.getBaseDirectory()), this.referentielXsltFile)).exists()) {
            throw new InvalidXmlDefinition("file " + f.getAbsolutePath() + " can not be found");
        }
        if (this.controlConfigFile != null && !(f = new File(new File(this.getBaseDirectory()), this.controlConfigFile)).exists()) {
            throw new InvalidXmlDefinition("file " + f.getAbsolutePath() + " can not be found");
        }
        if (this.defaultEtatGlobal != null && this.getEtatById(this.defaultEtatGlobal) == null) {
            throw new InvalidXmlDefinition("L'\u00e9tat " + this.defaultEtatGlobal + " n'est pas d\u00e9fini dans " + this.getId());
        }
    }

    public String getBalise() {
        return this.balise;
    }

    public Vector<EtatModel> getEtats() {
        return this.etats;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getId() {
        return this.id;
    }

    public String getIdValue() {
        return this.getId();
    }

    public String getReferentiel() {
        return this.referentiel;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTitre() {
        return this.titre;
    }

    public String getImportClass() {
        return this.importClass;
    }

    public boolean isControlable() {
        return this.isControlable;
    }

    public EtatModel getEtatById(String etatId) {
        Enumeration<EtatModel> enumer = this.etats.elements();
        while (enumer.hasMoreElements()) {
            EtatModel etat = enumer.nextElement();
            if (!etat.getId().equals(etatId)) continue;
            return etat;
        }
        return null;
    }

    public EtatModel getEtatByTagName(String tagName) {
        Enumeration<EtatModel> enumer = this.etats.elements();
        while (enumer.hasMoreElements()) {
            EtatModel etat = enumer.nextElement();
            if (!etat.getBalise().equals(tagName)) continue;
            return etat;
        }
        return null;
    }

    public TraitementExterneModel getTraitementExterneById(String traitementExterneId) {
        Enumeration<TraitementExterneModel> enumer = this.traitementExternes.elements();
        while (enumer.hasMoreElements()) {
            TraitementExterneModel traitementExterne = enumer.nextElement();
            if (!traitementExterne.getId().equals(traitementExterneId)) continue;
            return traitementExterne;
        }
        return null;
    }

    public Vector<String> getEntetes() {
        return this.entetes;
    }

    public RecherchePaireModel getBudgetPath() {
        return this.budgetPath;
    }

    public RecherchePaireModel getReferenceNomenclaturePath() {
        return this.referenceNomenclaturePath;
    }

    public RecherchePaireModel getCollectivitePath() {
        return this.collectivitePath;
    }

    public String getLibelleExtension() {
        return this.libelleExtension == null ? this.getTitre() : this.libelleExtension;
    }

    public Hashtable<String, EnteteModel> getMap() {
        Hashtable<String, EnteteModel> tmp = new Hashtable<String, EnteteModel>();
        for (String s : this.hEnteteModels.keySet()) {
            tmp.put(s, this.hEnteteModels.get(s));
        }
        return tmp;
    }

    public String getIndexCreation() {
        return this.indexCreation;
    }

    public String toString() {
        return this.titre;
    }

    public Vector<Pair> getDefaultBudgets() {
        return this.defaultBudgets;
    }

    public String getReferentielXsltFile() {
        return this.referentielXsltFile;
    }

    public DocumentModel clone() {
        DocumentModel dm = new DocumentModel(QN);
        for (EtatModel etatModel : this.etats) {
            try {
                dm.addChild((XmlMarshallable)etatModel.clone(dm), EtatModel.QN);
            }
            catch (Throwable t) {}
        }
        for (TraitementExterneModel traitementExterneModel : this.traitementExternes) {
            try {
                dm.addChild((XmlMarshallable)traitementExterneModel.clone(), TraitementExterneModel.QN);
            }
            catch (Throwable t) {}
        }
        for (String string : this.hEnteteModels.keySet()) {
            try {
                dm.addChild((XmlMarshallable)this.hEnteteModels.get(string).clone(), EnteteModel.QN);
            }
            catch (Throwable t) {}
        }
        dm.id = this.id;
        dm.extension = this.extension;
        dm.schema = this.schema;
        dm.titre = this.titre;
        dm.balise = this.balise;
        dm.referentiel = this.referentiel;
        dm.importClass = this.importClass;
        dm.indexCreation = this.indexCreation;
        dm.libelleExtension = this.libelleExtension;
        dm.referentielXsltFile = this.referentielXsltFile;
        dm.browsable = this.browsable;
        dm.isControlable = this.isControlable;
        dm.defaultBrowsableEtat = this.defaultBrowsableEtat;
        dm.extendsDocId = this.extendsDocId;
        dm.setDisplayInMenuIf(this.getDisplayInMenuIf());
        try {
            dm.addChild((XmlMarshallable)this.collectivitePath.clone(), DocumentsMapping.COLLECTIVITE_PATH);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            dm.addChild((XmlMarshallable)this.budgetPath.clone(), DocumentsMapping.BUDGET_PATH);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            dm.addChild((XmlMarshallable)this.referenceNomenclaturePath.clone(), DocumentsMapping.REFERENCE_NOMENCLATURE_PATH);
        }
        catch (Throwable t) {
            // empty catch block
        }
        dm.persistenceConfigFile = this.persistenceConfigFile;
        for (String string : this.hDefaultBudgets.keySet()) {
            try {
                dm.addChild((XmlMarshallable)this.hDefaultBudgets.get(string).clone(), DocumentsMapping.DEFAULT_BUDGET);
            }
            catch (Throwable t) {}
        }
        dm.groupMenuItems = this.groupMenuItems;
        try {
            dm.addChild((XmlMarshallable)this.namespaces.clone(), NamespaceModel.QN);
        }
        catch (Throwable t) {
            // empty catch block
        }
        for (SpecialKeyModel specialKeyModel : this.specialKeys) {
            try {
                dm.addChild((XmlMarshallable)specialKeyModel.clone(), SpecialKeyModel.QN);
            }
            catch (Throwable t) {}
        }
        dm.controlConfigFile = this.controlConfigFile;
        try {
            dm.addChild((XmlMarshallable)this.parameters.clone(), ParametersModel.QN);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dm.baseDirectory = this.baseDirectory;
        dm.pjNamespaceUri = this.pjNamespaceUri;
        dm.globalImportXsltFile = this.globalImportXsltFile;
        dm.globalUriTransformer = this.globalUriTransformer;
        dm.defaultEtatGlobal = this.defaultEtatGlobal;
        dm.libelleCollectivite = this.libelleCollectivite;
        return dm;
    }

    public Vector<SpecialKeyModel> getSpecialKeys() {
        return this.specialKeys;
    }

    public boolean isBrowsable() {
        return this.browsable;
    }

    public EtatModel getDefaultBrowsableEtat() {
        if (this.defaultBrowsableEtat != null) {
            return this.getEtatById(this.defaultBrowsableEtat);
        }
        return this.etats.elementAt(0);
    }

    @Deprecated
    public String getReferentielImportTransfo() {
        return this.referentielImportTransfo;
    }

    public String getPersistenceConfigFile() {
        return this.persistenceConfigFile;
    }

    public void setPersistenceConfigFile(String persistenceConfigFile) {
        this.persistenceConfigFile = persistenceConfigFile;
    }

    public NamespaceModel getNamespaces() {
        return this.namespaces;
    }

    public boolean isGroupMenuItem() {
        return this.groupMenuItems;
    }

    @Override
    public EnvironmentDomain getChildAt(int domain, int pos) {
        return this.etats.elementAt(pos);
    }

    @Override
    public boolean hasEnvironment(int domain) {
        return false;
    }

    @Override
    public Enumeration<VariableModel> getVariables(int domain) {
        return null;
    }

    @Override
    public int getChildCount(int domain) {
        int count = 0;
        for (EtatModel em : this.etats) {
            if (em.getDisplayInMenuIf() != null) {
                if (!"true".equals(System.getProperty(em.getDisplayInMenuIf()))) continue;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    @Override
    public Enumeration<EnvironmentDomain> children(int domain) {
        Vector<EtatModel> childs = new Vector<EtatModel>();
        for (EtatModel em : this.etats) {
            if (em.getDisplayInMenuIf() != null) {
                if (!"true".equals(System.getProperty(em.getDisplayInMenuIf()))) continue;
                childs.add(em);
                continue;
            }
            childs.add(em);
        }
        return childs.elements();
    }

    @Override
    public Object getValue(String path) throws DataConfigurationException {
        String sTmp = path.startsWith("/") ? path.substring(1) : path;
        if (sTmp.startsWith("etat")) {
            int pos = sTmp.indexOf(47);
            String next = sTmp.substring(pos);
            String condition = sTmp.substring("etat".length(), pos);
            if (condition.startsWith("[") && condition.endsWith("]")) {
                condition = condition.substring(1, condition.length() - 1).trim();
            }
            if (condition.startsWith("@id=")) {
                String etatId = condition.substring(5, condition.length() - 1);
                EtatModel em = this.getEtatById(etatId);
                return em.getValue(next);
            }
            throw new DataConfigurationException("can only get etat by id");
        }
        throw new DataConfigurationException("from document, you can only access to etat(s)");
    }

    @Override
    public void setValue(String path, Object value) throws DataConfigurationException {
        String condition;
        String next;
        String sTmp = path.startsWith("/") ? path.substring(1) : path;
        if (sTmp.startsWith("etat")) {
            int pos = sTmp.indexOf(47);
            next = sTmp.substring(pos);
            condition = sTmp.substring("etat".length(), pos);
            if (condition.startsWith("[") && condition.endsWith("]")) {
                condition = condition.substring(1, condition.length() - 1).trim();
            }
            if (!condition.startsWith("@id=")) {
                throw new DataConfigurationException("can only get etat by id");
            }
        } else {
            throw new DataConfigurationException("from document, you can only access to etat(s)");
        }
        String etatId = condition.substring(5, condition.length() - 1);
        EtatModel em = this.getEtatById(etatId);
        em.setValue(next, value);
    }

    public Vector<ElementModel> getElementsById(String elementId) {
        Vector<ElementModel> ret = new Vector<ElementModel>();
        for (EtatModel em : this.etats) {
            ElementModel el = em.getElementById(elementId);
            if (el == null) continue;
            ret.add(el);
        }
        return ret;
    }

    public String getControlConfigFile() {
        return this.controlConfigFile;
    }

    public void setBudgetPath(RecherchePaireModel budgetPath) {
        this.budgetPath = budgetPath;
    }

    public void setReferenceNomenclaturePath(RecherchePaireModel referenceNomenclaturePath) {
        this.referenceNomenclaturePath = referenceNomenclaturePath;
    }

    public void setCollectivitePath(RecherchePaireModel collectivitePath) {
        this.collectivitePath = collectivitePath;
    }

    public ParametersModel getParameters() {
        return this.parameters;
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        if ("entete".equals(tagName)) {
            return this.hEnteteModels.get(id);
        }
        if ("etat".equals(tagName)) {
            return this.hEtats.get(id);
        }
        if ("budget-path".equals(tagName)) {
            return this.budgetPath;
        }
        if ("reference-nomenclature-path".equals(tagName)) {
            return this.referenceNomenclaturePath;
        }
        if ("collectivite-path".equals(tagName)) {
            return this.collectivitePath;
        }
        if ("default-budget".equals(tagName)) {
            return this.hDefaultBudgets.get(id);
        }
        if ("special-key".equals(tagName)) {
            return this.hSpecialKeys.get(id);
        }
        if ("namespaces".equals(tagName)) {
            return this.namespaces;
        }
        if ("parameters".equals(tagName)) {
            return this.parameters;
        }
        if ("traitementexterne".equals(tagName)) {
            return this.hTraitementExternes.get(id);
        }
        return null;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00e0 jour des attributs : " + e));
        }
    }

    public String[] getChildIdAttrName(String childTagName) {
        if ("entete".equals(childTagName)) {
            return new String[]{"id"};
        }
        if ("etat".equals(childTagName)) {
            return new String[]{"id"};
        }
        if ("default-budget".equals(childTagName)) {
            return new String[]{"value"};
        }
        if ("special-key".equals(childTagName)) {
            return new String[]{"id"};
        }
        return null;
    }

    public void resetCharData() {
    }

    public void setVEtats(Vector<EtatModel> v) {
        this.etats = v;
    }

    public void setHEtats(HashMap<String, EtatModel> h) {
        this.hEtats = h;
    }

    public HashMap<String, EtatModel> getHEtats() {
        return this.hEtats;
    }

    public void setBaseDirectory(String baseDir) {
        this.baseDirectory = baseDir;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setExtendedDocId(String docId) {
        this.extendsDocId = docId;
    }

    public String getExtendedDocId() {
        return this.extendsDocId;
    }

    public Element createSmallDOM(Document doc) {
        Element ret = doc.createElementNS("http://projets.admisource.gouv.fr/xemelios/namespaces#config", "conf:document");
        ret.setAttribute("id", this.getId());
        ret.setAttribute("libelle", this.getTitre());
        for (EtatModel em : this.getEtats()) {
            Element etat = em.createSmallDOM(doc);
            ret.appendChild(etat);
        }
        return ret;
    }

    public DocumentsModel getParent() {
        return (DocumentsModel)this._NMParent;
    }

    public String getPjNamespaceUri() {
        return this.pjNamespaceUri;
    }

    public String getDisplayInMenuIf() {
        return this.displayInMenuIf;
    }

    public void setDisplayInMenuIf(String displayInMenuIf) {
        this.displayInMenuIf = displayInMenuIf;
    }

    public int compareTo(Object o) {
        int ret = -1000;
        if (o instanceof DocumentModel) {
            DocumentModel dm = (DocumentModel)o;
            ret = this.ordrePresentation - dm.ordrePresentation;
            if (ret == 0) {
                ret = this.getTitre().compareTo(dm.getTitre());
            }
        }
        return ret;
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/document[@id='" + this.getId() + "']";
        }
        return this.configXPath;
    }

    public String getGlobalImportXsltFile() {
        return this.globalImportXsltFile;
    }

    public String getGlobalUriTransformer() {
        return this.globalUriTransformer;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        QName name = new QName(uri, localName);
        if (EnteteModel.QN.equals(name)) {
            return (XmlMarshallable)this.hEnteteModels.get(atts.getValue("id"));
        }
        if (EtatModel.QN.equals(name)) {
            return (XmlMarshallable)this.hEtats.get(atts.getValue("id"));
        }
        if (DocumentsMapping.BUDGET_PATH.equals(name)) {
            return this.budgetPath;
        }
        if (DocumentsMapping.REFERENCE_NOMENCLATURE_PATH.equals(name)) {
            return this.referenceNomenclaturePath;
        }
        if (DocumentsMapping.COLLECTIVITE_PATH.equals(name)) {
            return this.collectivitePath;
        }
        if (DocumentsMapping.DEFAULT_BUDGET.equals(name)) {
            return (XmlMarshallable)this.hDefaultBudgets.get(atts.getValue("value"));
        }
        if (SpecialKeyModel.QN.equals(name)) {
            return (XmlMarshallable)this.hSpecialKeys.get(atts.getValue("id"));
        }
        if (NamespaceModel.QN.equals(name)) {
            return this.namespaces;
        }
        if (ParametersModel.QN.equals(name)) {
            return this.parameters;
        }
        return null;
    }

    public QName getQName() {
        return this.qn;
    }

    public String getDefaultEtatGlobal() {
        return this.defaultEtatGlobal;
    }

    public String getLibelleCollectivite() {
        return this.libelleCollectivite;
    }
}

