/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.components;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ComponentModel
implements XmlMarshallable {
    public static final transient String TAG = "component";
    public static final transient QName QN = new QName("component");
    private String tagName;
    private QName qn;
    private String id;
    private String description;
    private String version;

    public ComponentModel(QName tagName) {
        this.qn = tagName;
        this.tagName = this.qn.getLocalPart();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.description = attributes.getValue("description");
        this.version = attributes.getValue("version");
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(this.tagName);
        output.addAttribute("id", this.id);
        output.addAttribute("description", this.description);
        output.addAttribute("version", this.version);
        output.endTag(this.tagName);
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public ComponentModel clone() {
        return this;
    }

    public boolean isNewerThan(ComponentModel other) {
        if (!this.getId().equals(other)) {
            throw new IllegalArgumentException(other.getId() + " is different than " + this.getId());
        }
        return ComponentModel.compareReleases(this.getVersion(), other.getVersion()) > 0;
    }

    public boolean isNewerOrEqualThan(ComponentModel other) {
        if (!this.getId().equals(other)) {
            throw new IllegalArgumentException(other.getId() + " is different than " + this.getId());
        }
        return ComponentModel.compareReleases(this.getVersion(), other.getVersion()) >= 0;
    }

    public boolean isNewerOrEqualThan(String otherVersion) {
        return ComponentModel.compareReleases(this.getVersion(), otherVersion) >= 0;
    }

    private static int compareReleases(String r1, String r2) {
        String[] s1 = ComponentModel.splitRelease(r1);
        String[] s2 = ComponentModel.splitRelease(r2);
        int ret = 0;
        for (int i = 0; i < Math.min(s1.length, s2.length); ++i) {
            int a = -1;
            int b = -1;
            try {
                a = Integer.parseInt(s1[i]);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                b = Integer.parseInt(s2[i]);
            }
            catch (Throwable t) {
                // empty catch block
            }
            ret = a != -1 && b != -1 ? (a < b ? -1 : (a == b ? 0 : 1)) : s1[i].compareTo(s2[i]);
            if (ret == 0) continue;
            return ret;
        }
        if (s1.length > s2.length) {
            ret = 1;
        } else if (s1.length < s2.length) {
            ret = -1;
        }
        return ret;
    }

    private static String[] splitRelease(String r) {
        return r.split("\\.");
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return null;
    }

    public QName getQName() {
        return this.qn;
    }
}

