/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DematTransform {
    private static Logger logger = Logger.getLogger(DematTransform.class);

    public static InputStream transform(InputStream xmlStream, InputStream xslStream, String encoding, Map<String, Object> parameters) throws IOException {
        Transformer transformer;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            transformer = tFactory.newTransformer(new StreamSource(xslStream));
            for (String key : parameters.keySet()) {
                transformer.setParameter(key, parameters.get(key));
            }
        }
        catch (TransformerConfigurationException e) {
            logger.error((Object)e);
            return null;
        }
        ByteArrayOutputStream outArray = new ByteArrayOutputStream();
        try {
            transformer.transform(new StreamSource(xmlStream), new StreamResult(outArray));
        }
        catch (TransformerException e) {
            logger.error((Object)e);
            return null;
        }
        return new ByteArrayInputStream(outArray.toString(encoding).getBytes());
    }

    public static InputStream transform(InputStream xmlStream, InputStream xslStream, String encoding) throws IOException {
        return DematTransform.transform(xmlStream, xslStream, encoding, new Hashtable<String, Object>());
    }

    public static InputStream transform(Node xmlNode, InputStream xslStream) throws IOException {
        return DematTransform.transform(xmlNode, xslStream, new Hashtable<String, Object>());
    }

    public static InputStream transform(Node xmlNode, InputStream xslStream, Map<String, Object> parameters) throws IOException {
        Transformer transformer;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        try {
            transformer = tFactory.newTransformer(new StreamSource(xslStream));
            for (String key : parameters.keySet()) {
                transformer.setParameter(key, parameters.get(key));
            }
        }
        catch (TransformerConfigurationException e) {
            logger.error((Object)e);
            e.printStackTrace();
            return null;
        }
        ByteArrayOutputStream outArray = new ByteArrayOutputStream();
        try {
            transformer.transform(new DOMSource(xmlNode), new StreamResult(outArray));
        }
        catch (TransformerException e) {
            logger.error((Object)e);
            e.printStackTrace();
            return null;
        }
        return new ByteArrayInputStream(outArray.toByteArray());
    }
}

