/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.auth;

import fr.gouv.finances.cp.utils.PropertiesExpansion;
import fr.gouv.finances.cp.xemelios.auth.AuthenticationCancelationException;
import fr.gouv.finances.cp.xemelios.auth.AuthenticationConfigurationException;
import fr.gouv.finances.cp.xemelios.auth.AuthenticationManager;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;

public class AuthenticationFactory {
    public static final transient String PROP_CONFIG_FILE_NAME = "xemelios.authentication.config.filename";
    public static final transient String PROP_MANAGER_CLASS_NAME = "authentication.manager";
    private static AuthenticationManager manager = null;

    public static AuthenticationManager getManager(MainWindow mw) throws AuthenticationConfigurationException, AuthenticationCancelationException {
        if (manager == null) {
            String authConfigFileName = System.getProperty(PROP_CONFIG_FILE_NAME);
            if (authConfigFileName == null || authConfigFileName.length() == 0) {
                throw new AuthenticationConfigurationException("property xemelios.authentication.config.filename is not defined");
            }
            PropertiesExpansion pe = new PropertiesExpansion();
            pe.putAll((Map)System.getProperties());
            try {
                Object[] parameters;
                Class[] parametersTypes;
                pe.load((InputStream)new FileInputStream(authConfigFileName));
                String managerClassName = pe.getProperty(PROP_MANAGER_CLASS_NAME);
                if (managerClassName == null || managerClassName.length() == 0) {
                    throw new AuthenticationConfigurationException("property authentication.manager is not defined in " + authConfigFileName);
                }
                Class<?> clazz = Class.forName(managerClassName);
                Constructor<?> constructor = clazz.getConstructor(parametersTypes = new Class[]{MainWindow.class});
                Object o = constructor.newInstance(parameters = new Object[]{mw});
                if (!(o instanceof AuthenticationManager)) {
                    throw new AuthenticationConfigurationException(managerClassName + " does not implements " + AuthenticationManager.class.getName());
                }
                manager = (AuthenticationManager)o;
                manager.setProperties((Properties)pe);
            }
            catch (FileNotFoundException fnfEx) {
                throw new AuthenticationConfigurationException(authConfigFileName + " not found", fnfEx);
            }
            catch (IOException ioEx) {
                throw new AuthenticationConfigurationException(ioEx);
            }
            catch (ClassNotFoundException cnfEx) {
                throw new AuthenticationConfigurationException("class not found", cnfEx);
            }
            catch (InstantiationException iEx) {
                throw new AuthenticationConfigurationException(iEx);
            }
            catch (IllegalAccessException iaEx) {
                throw new AuthenticationConfigurationException(iaEx);
            }
            catch (NoSuchMethodException nsmEx) {
                throw new AuthenticationConfigurationException(pe.getProperty(PROP_MANAGER_CLASS_NAME) + " does not provide the required constructor.", nsmEx);
            }
            catch (InvocationTargetException itEx) {
                if (itEx.getCause() != null && itEx.getCause() instanceof AuthenticationCancelationException) {
                    throw (AuthenticationCancelationException)itEx.getCause();
                }
                throw new AuthenticationConfigurationException(pe.getProperty(PROP_MANAGER_CLASS_NAME) + ".<init>(MainWindow)", itEx);
            }
        }
        return manager;
    }
}

