/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.xml.dompath;

import fr.gouv.finances.cp.utils.xml.InvalidPathExpressionException;
import fr.gouv.finances.cp.utils.xml.PathNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomPath {
    private static final Logger logger = Logger.getLogger(DomPath.class);
    private Stepper[] path = null;
    private static XPathFactory xpf = XPathFactory.newInstance();

    public DomPath(String pathExpression, NamespaceContext ns) throws InvalidPathExpressionException {
        String[] tokens = DomPath.splitXPathExpr(pathExpression);
        int length = tokens.length;
        if (length == 0) {
            throw new InvalidPathExpressionException("empty");
        }
        this.path = new Stepper[length];
        int i = 0;
        --length;
        for (String token : tokens) {
            this.path[i] = new Stepper(token, ns);
            if (i < length) {
                if (this.path[i].getType() == 2) {
                    throw new InvalidPathExpressionException("only the last element can be an attribute: " + pathExpression);
                }
            } else if (this.path[i].getType() == 1 && !this.path[i].elementName.equals("text()") && !this.path[i].elementName.equals("name()")) {
                throw new InvalidPathExpressionException("the last element must be an attribute or a text(): " + pathExpression);
            }
            ++i;
        }
    }

    public Object getValue(Node node, boolean catchException) throws PathNotFoundException {
        try {
            Object o = node;
            for (Stepper stepper : this.path) {
                if (o == null || !(o instanceof Node)) continue;
                o = stepper.step((Node)o);
            }
            return o == null ? null : o.toString();
        }
        catch (PathNotFoundException pnfEx) {
            if (!catchException) {
                throw pnfEx;
            }
            return null;
        }
    }

    protected static String[] splitXPathExpr(String xpath) {
        ArrayList<String> ret = new ArrayList<String>();
        int bracketCount = 0;
        StringBuffer buff = new StringBuffer();
        for (char c : xpath.toCharArray()) {
            if (c == '[') {
                ++bracketCount;
            }
            if (c == ']') {
                --bracketCount;
            }
            if (c == '/') {
                if (bracketCount == 0) {
                    ret.add(buff.toString());
                    buff = new StringBuffer();
                    continue;
                }
                buff.append(c);
                continue;
            }
            buff.append(c);
        }
        ret.add(buff.toString());
        String[] ar = new String[ret.size()];
        for (int i = 0; i < ar.length; ++i) {
            ar[i] = (String)ret.get(i);
        }
        return ar;
    }

    static /* synthetic */ XPathFactory access$100() {
        return xpf;
    }

    static /* synthetic */ Logger access$200() {
        return logger;
    }

    private class Stepper {
        public static final int TYPE_ELEMENT = 1;
        public static final int TYPE_ATTRIBUTE = 2;
        private String elementName = null;
        private int elementRank = 0;
        private String condition = null;
        private int type = 0;
        private NamespaceContext ns;

        public Stepper(String pathElement, NamespaceContext ns) throws InvalidPathExpressionException {
            this.ns = ns;
            if (pathElement.startsWith("@")) {
                this.type = 2;
                this.elementName = pathElement.substring(1);
                if (this.elementName == null || this.elementName.length() == 0) {
                    throw new InvalidPathExpressionException("attribute name can not be empty");
                }
                if (this.elementName.indexOf(42) >= 0) {
                    throw new InvalidPathExpressionException("attribute name can not contain *");
                }
            } else {
                this.type = 1;
                String s = pathElement;
                if (s.indexOf(91) >= 0) {
                    String inner = s.substring(s.indexOf(91) + 1, s.indexOf(93));
                    System.out.println(inner);
                    int rank = 1;
                    if (inner.length() > 0) {
                        try {
                            rank = Integer.parseInt(inner);
                        }
                        catch (NumberFormatException nfEx) {
                            this.condition = inner;
                        }
                    }
                    if (rank == 0) {
                        throw new InvalidPathExpressionException("rank can not be lower than 1");
                    }
                    this.elementRank = rank - 1;
                    s = s.substring(0, s.indexOf(91));
                }
                this.elementName = s;
                if (this.elementName == null || this.elementName.length() == 0) {
                    throw new InvalidPathExpressionException("element name can not be empty");
                }
                if (this.elementName.indexOf(42) >= 0) {
                    throw new InvalidPathExpressionException("element name can not contain *");
                }
            }
        }

        public int getType() {
            return this.type;
        }

        /*
         * Unable to fully structure code
         */
        public Object step(Node node) throws PathNotFoundException {
            block16: {
                block15: {
                    block18: {
                        block17: {
                            qn = this.getQName(this.elementName, this.ns);
                            if (this.type != 1) break block16;
                            el = (Element)node;
                            if ("text()".equals(this.elementName)) {
                                return el.getTextContent();
                            }
                            if ("name()".equals(this.elementName)) {
                                return el.getNodeName();
                            }
                            ret = null;
                            if (!"..".equals(qn.getLocalPart())) break block17;
                            ret = node.getParentNode();
                            break block15;
                        }
                        if (this.condition != null) break block18;
                        lst = el.getChildNodes();
                        parsingRank = 0;
                        for (i = 0; i < lst.getLength(); ++i) {
                            n = lst.item(i);
                            if (n.getNodeType() != 1) continue;
                            if (!n.getLocalName().equals(qn.getLocalPart()) || !n.getNamespaceURI().equals(qn.getNamespaceURI())) ** GOTO lbl24
                            if (parsingRank == this.elementRank) {
                                ret = n;
                            } else {
                                ++parsingRank;
lbl24:
                                // 2 sources

                                if (ret == null) {
                                    continue;
                                }
                            }
                            break block15;
                        }
                        break block15;
                    }
                    prefix = null;
                    it = this.ns.getPrefixes(qn.getNamespaceURI());
                    while (it.hasNext()) {
                        s = it.next();
                        if (prefix == null) {
                            prefix = s;
                            continue;
                        }
                        if (prefix.length() >= s.length()) continue;
                        prefix = s;
                    }
                    xpathExpr = (prefix != null && prefix.length() > 0 ? prefix + ":" : "") + this.elementName + "[" + this.condition + "]";
                    try {
                        xp = DomPath.access$100().newXPath();
                        xp.setNamespaceContext(this.ns);
                        o = xp.evaluate(xpathExpr, el, XPathConstants.NODESET);
                        if (o instanceof NodeList) {
                            nl = (NodeList)o;
                            if (nl.getLength() <= 0) ** GOTO lbl54
                            ret = nl.item(0);
                        }
                        if (!(o instanceof List) || (l = (List)o).isEmpty()) ** GOTO lbl54
                        ret = (Node)l.get(0);
                    }
                    catch (XPathExpressionException xpEx) {
                        DomPath.access$200().error((Object)("while evaluating " + xpathExpr), (Throwable)xpEx);
                    }
                }
                if (ret == null) {
                    throw new PathNotFoundException(this.elementName + "{" + this.elementRank + "} not found under" + node.getNodeName() + ".");
                }
                return ret;
            }
            map = node.getAttributes();
            if (map == null || map.getLength() == 0) {
                throw new PathNotFoundException("no " + this.elementName + " attribute in " + node.getNodeName());
            }
            attr = map.getNamedItemNS(qn.getNamespaceURI(), qn.getLocalPart());
            if (attr == null) {
                attr = map.getNamedItem(qn.getLocalPart());
            }
            if (attr != null) {
                return attr.getNodeValue();
            }
            return null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.type == 1 ? "ELEMENT " : "ATTRIBUTE ").append(this.elementName).append(" rank=").append(this.elementRank);
            return sb.toString();
        }

        private QName getQName(String spec, NamespaceContext ns) {
            QName ret = null;
            int pos = spec.indexOf(58);
            if (pos >= 0) {
                String prefix = spec.substring(0, pos);
                String localName = spec.substring(pos + 1);
                String uri = ns.getNamespaceURI(prefix);
                ret = new QName(uri, localName, prefix);
            } else if (this.getType() == 1) {
                String uri = ns.getNamespaceURI("");
                ret = new QName(uri, spec);
            } else {
                ret = new QName(spec);
            }
            return ret;
        }
    }
}

