/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.xml;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

public class XmlAttributesImpl
implements Attributes {
    private static final Logger logger = Logger.getLogger(XmlAttributesImpl.class);
    private ArrayList<Attribute> attrs = new ArrayList();
    private Hashtable<String, String> prefixToUri = new Hashtable();
    private Hashtable<String, TreeSet<String>> uriToPrefixes = new Hashtable();
    private Hashtable<String, Integer> qNamePosition = new Hashtable();

    public void addAttribute(String URI2, String localName, String qName, String type, String value) {
        Attribute attr = new Attribute(URI2, localName, qName, type, value);
        if (URI2 != null && qName.indexOf(58) >= 0) {
            String prefix = qName.substring(0, qName.indexOf(58));
            this.prefixToUri.put(prefix, URI2);
            TreeSet<String> prefixes = this.uriToPrefixes.get(URI2);
            if (prefixes == null) {
                prefixes = new TreeSet();
                this.uriToPrefixes.put(URI2, prefixes);
            }
            prefixes.add(prefix);
        }
        String myQName = "{" + (URI2 == null ? "" : URI2) + "}" + localName;
        this.qNamePosition.put(myQName, new Integer(this.attrs.size()));
        this.attrs.add(attr);
    }

    public int getLength() {
        return this.attrs.size();
    }

    public String getValue(String qName) {
        int pos = qName.indexOf(58);
        String myQName = null;
        if (pos >= 0) {
            String prefix = qName.substring(0, pos);
            String localName = qName.substring(pos + 1);
            String URI2 = this.prefixToUri.get(prefix);
            myQName = "{" + (URI2 == null ? "" : URI2) + "}" + localName;
        } else {
            myQName = "{}" + qName;
        }
        Integer position = this.qNamePosition.get(myQName);
        if (position == null) {
            return null;
        }
        Attribute attr = this.attrs.get(position);
        return attr.value;
    }

    public String getType(String qName) {
        int pos = qName.indexOf(58);
        String myQName = null;
        if (pos >= 0) {
            String prefix = qName.substring(0, pos);
            String localName = qName.substring(pos + 1);
            String URI2 = this.prefixToUri.get(prefix);
            myQName = "{" + (URI2 == null ? "" : URI2) + "}" + localName;
        } else {
            myQName = "{}" + qName;
        }
        Integer position = this.qNamePosition.get(myQName);
        if (position == null) {
            return null;
        }
        Attribute attr = this.attrs.get(position);
        return attr.type;
    }

    public int getIndex(String qName) {
        int pos = qName.indexOf(58);
        String myQName = null;
        if (pos >= 0) {
            String prefix = qName.substring(0, pos);
            String localName = qName.substring(pos + 1);
            String URI2 = this.prefixToUri.get(prefix);
            myQName = "{" + (URI2 == null ? "" : URI2) + "}" + localName;
        } else {
            myQName = "{}" + qName;
        }
        Integer position = this.qNamePosition.get(myQName);
        if (position == null) {
            return -1;
        }
        return position;
    }

    public String getValue(int index) {
        Attribute attr = this.attrs.get(index);
        return attr.value;
    }

    public String getURI(int index) {
        Attribute attr = this.attrs.get(index);
        if (attr == null) {
            return null;
        }
        return attr.URI;
    }

    public String getType(int index) {
        Attribute attr = this.attrs.get(index);
        if (attr == null) {
            return null;
        }
        return attr.type;
    }

    public String getQName(int index) {
        Attribute attr = this.attrs.get(index);
        if (attr == null) {
            return null;
        }
        return attr.qName;
    }

    public String getLocalName(int index) {
        Attribute attr = this.attrs.get(index);
        if (attr == null) {
            return null;
        }
        return attr.localName;
    }

    public String getValue(String uri, String localName) {
        String myQName = "{" + uri + "}" + localName;
        Integer position = this.qNamePosition.get(myQName);
        if (position == null) {
            return null;
        }
        Attribute attr = this.attrs.get(position);
        if (attr == null) {
            return null;
        }
        return attr.value;
    }

    public String getType(String uri, String localName) {
        String myQName = "{" + uri + "}" + localName;
        Integer position = this.qNamePosition.get(myQName);
        if (position == null) {
            return null;
        }
        Attribute attr = this.attrs.get(position);
        if (attr == null) {
            return null;
        }
        return attr.type;
    }

    public int getIndex(String uri, String localName) {
        String myQName = "{" + uri + "}" + localName;
        Integer position = this.qNamePosition.get(myQName);
        if (position == null) {
            return -1;
        }
        return position;
    }

    private class Attribute {
        private String URI;
        private String localName;
        private String qName;
        private String type;
        private String value;

        public Attribute(String URI2, String localName, String qName, String type, String value) {
            this.URI = URI2;
            this.localName = localName;
            this.qName = qName;
            this.type = type;
            this.value = value;
        }
    }
}

