/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class JWaiter
extends JComponent {
    private static final long serialVersionUID = 3256444694262394930L;
    public static final Color EXT_COLOR = Color.WHITE;
    public static final Color IN_COLOR = new Color(163, 184, 204);
    public static final int PAINT_MODE_NORMAL = 1;
    public static final int PAINT_MODE_PROGRESS = 2;
    public static final int LEFT_TO_RIGHT = 1;
    public static final int RIGHT_TO_LEFT = 2;
    private int inPosition = 0;
    private int inDirection = 1;
    private int paintMode = 1;
    private Waiter waiter = null;

    public JWaiter() {
        this.setPreferredSize(new Dimension(75, 16));
        this.setOpaque(true);
    }

    public void startProgress() {
        this.inPosition = 0;
        this.inDirection = 1;
        this.paintMode = 2;
        this.waiter = new Waiter();
        this.waiter.start();
    }

    private void pushProgress() {
        if (this.inDirection == 1) {
            ++this.inPosition;
            if (this.inPosition == 10) {
                this.inDirection = 2;
            }
        } else {
            --this.inPosition;
            if (this.inPosition == 0) {
                this.inDirection = 1;
            }
        }
        Graphics g = this.getGraphics();
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        this.paintComponent(g);
    }

    public void stopProgress() {
        if (this.waiter != null) {
            this.waiter.stop = true;
        }
        this.paintMode = 1;
        Graphics g = this.getGraphics();
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        this.paintComponent(g);
        this.waiter = null;
    }

    protected void paintComponent(Graphics g) {
        Rectangle rect = this.getBounds();
        if (this.paintMode == 1) {
            g.setColor(this.getBackground());
            g.fillRect(1, 1, rect.width - 2, rect.height - 2);
        } else {
            int w = rect.width;
            int left = this.inPosition * w / 30;
            int right = left + w / 3;
            g.setColor(EXT_COLOR);
            g.fillRect(0, 0, left, rect.height - 1);
            g.fillRect(right, 0, w - 1, rect.height - 1);
            g.setColor(IN_COLOR);
            g.fillRect(left + 1, 0, right - 1, rect.height - 1);
        }
        g.setColor(Color.DARK_GRAY);
        g.drawRect(0, 0, rect.width - 1, rect.height - 1);
    }

    private class Waiter
    extends Thread {
        public boolean stop;

        public Waiter() {
            super("Waiter");
            this.stop = false;
        }

        public void run() {
            this.setPriority(10);
            while (!this.stop) {
                JWaiter.this.pushProgress();
                try {
                    Waiter.sleep(100L);
                }
                catch (InterruptedException iEx) {
                    JWaiter.this.stopProgress();
                }
            }
        }
    }
}

