/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class JRotatePanel
extends JComponent {
    private static final long serialVersionUID = -8892664236789395368L;
    private boolean stop;
    MouseListener ml = new MouseAdapter(){};
    MouseMotionListener mml = new MouseMotionAdapter(){};
    KeyListener kl = new KeyAdapter(){};

    public void start() {
        this.setVisible(true);
    }

    protected void paintComponent(Graphics g) {
        int xRadius;
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Image drkImg = this.createImage(false);
        Image clrImg = this.createImage(true);
        int midX = this.getWidth() / 2;
        int midY = this.getHeight() / 2;
        int imgWidth = drkImg.getWidth(this) / 2;
        int imgHeight = drkImg.getHeight(this) / 2;
        int width = clrImg.getWidth(this);
        int yRadius = xRadius = Math.min(midX, midY) - width;
        int sec = (int)(System.currentTimeMillis() / 500L % 12L) + 1;
        for (int i = 1; i <= 12; ++i) {
            double angle = 1.5707963267948966 + Math.PI * 2 * (double)i / 12.0;
            int xPos = (int)((double)midX + Math.cos(angle) * (double)xRadius);
            int yPos = (int)((double)midY + Math.sin(angle) * (double)yRadius);
            AffineTransform at = AffineTransform.getTranslateInstance(xPos, yPos);
            at.rotate(angle);
            at.translate(-imgWidth, -imgHeight);
            g2d.drawImage(i == sec ? clrImg : drkImg, at, this);
        }
    }

    public void paintBackground(Graphics g) {
        if (g != null) {
            g.setColor(new Color(255, 255, 255, 167));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.stop = false;
            RePainter rp = new RePainter();
            this.setFocusTraversalKeysEnabled(false);
            this.addMouseListener(this.ml);
            this.addMouseMotionListener(this.mml);
            this.addKeyListener(this.kl);
            this.requestFocusInWindow();
            this.paintBackground(this.getGraphics());
            rp.start();
        } else {
            this.stop = true;
            this.setFocusTraversalKeysEnabled(true);
            this.removeMouseListener(this.ml);
            this.removeMouseMotionListener(this.mml);
            this.removeKeyListener(this.kl);
        }
    }

    private Image createImage(boolean light) {
        Image img = this.createImage(25, 10);
        if (img != null) {
            Graphics g = img.getGraphics();
            g.setColor(light ? Color.GRAY : Color.LIGHT_GRAY);
            g.fill3DRect(0, 0, 25, 10, true);
        }
        return img;
    }

    private class RePainter
    extends Thread {
        private RePainter() {
        }

        public void run() {
            this.setPriority(1);
            while (!JRotatePanel.this.stop) {
                try {
                    SwingUtilities.invokeAndWait(new Thread(){

                        public void run() {
                            JRotatePanel.this.paint(JRotatePanel.this.getGraphics());
                        }
                    });
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

