/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;

public class XSLImportSchema
extends StyleElement {
    public void prepareAttributes() throws XPathException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string2 = this.getNamePool().getClarkName(n);
            if (string2 == "schema-location") continue;
            if (string2 == "namespace") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if ("".equals(string)) {
            this.compileError("The zero-length string is not a valid namespace URI. For a schema with no namespace, omit the namespace attribute");
        }
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
    }

    public void readSchema() throws SchemaException, XPathException {
        try {
            Object object;
            String string;
            String string2 = this.getAttributeValue("schema-location");
            if (string2 != null) {
                string2 = string2.trim();
            }
            string = (string = this.getAttributeValue("namespace")) == null ? "" : string.trim();
            Configuration configuration = this.getPreparedStylesheet().getConfiguration();
            if (!configuration.isSchemaAware(50)) {
                this.compileError("To use xsl:import-schema, you need the schema-aware version of Saxon from http://www.saxonica.com/");
                return;
            }
            AxisIterator axisIterator = this.iterateAxis((byte)3);
            NodeInfo nodeInfo = null;
            while ((object = axisIterator.next()) != null) {
                if (nodeInfo != null) {
                    this.compileError(this.getDisplayName() + " must not have more than one child element");
                }
                if ((nodeInfo = (NodeInfo)object).getFingerprint() != 620) {
                    this.compileError("The only child element permitted for " + this.getDisplayName() + " is xs:schema");
                }
                if (string2 != null) {
                    this.compileError("The schema-location attribute must be absent if an inline schema is present");
                }
                string = configuration.readInlineSchema(nodeInfo, string, null);
                this.getPrincipalStylesheet().addImportedSchema(string);
            }
            if (nodeInfo != null) {
                return;
            }
            if (configuration.getSchema(string) == null) {
                if (string2 == null) {
                    this.compileWarning("No schema for this namespace is known, and no schema-location was supplied, so no schema has been imported", null);
                    return;
                }
                object = configuration.makePipelineConfiguration();
                string = configuration.readSchema((PipelineConfiguration)object, this.getBaseURI(), string2, string);
            }
            this.getPrincipalStylesheet().addImportedSchema(string);
        }
        catch (SchemaException schemaException) {
            this.compileError(schemaException.getMessage(), "XTSE0220");
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.compileError(transformerConfigurationException.getMessage(), "XTSE0220");
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        executable.setReasonUnableToCompile("Cannot compile a stylesheet that imports a schema");
        return null;
    }
}

