/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashMap;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.codenorm.Normalizer;
import net.sf.saxon.event.HTMLTagHashSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;

public class HTMLURIEscaper
extends ProxyReceiver {
    private static HTMLTagHashSet urlAttributes = new HTMLTagHashSet(47);
    private static HTMLTagHashSet urlCombinations = new HTMLTagHashSet(101);
    private HashMap urlAttributeCache = new HashMap(30);
    protected int currentElement;
    protected boolean escapeURIAttributes = true;
    protected NamePool pool;

    private static void setUrlAttribute(String string, String string2) {
        urlAttributes.add(string2);
        urlCombinations.add(string + '+' + string2);
    }

    public boolean isUrlAttribute(int n, int n2) {
        String string;
        Long l = new Long((long)n << 32 | (long)n2);
        Boolean bl = (Boolean)this.urlAttributeCache.get(l);
        if (bl != null) {
            return bl;
        }
        if (this.pool == null) {
            this.pool = this.getNamePool();
        }
        if (!urlAttributes.contains(string = this.pool.getDisplayName(n2))) {
            this.urlAttributeCache.put(l, Boolean.FALSE);
            return false;
        }
        String string2 = this.pool.getDisplayName(n);
        boolean bl2 = urlCombinations.contains(string2 + '+' + string);
        this.urlAttributeCache.put(l, bl2);
        return bl2;
    }

    public void open() throws XPathException {
        super.open();
    }

    public void startDocument(int n) throws XPathException {
        super.startDocument(n);
        this.pool = this.getPipelineConfiguration().getConfiguration().getNamePool();
    }

    public void startElement(int n, int n2, int n3, int n4) throws XPathException {
        this.currentElement = n;
        this.getUnderlyingReceiver().startElement(n, n2, n3, n4);
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3, int n4) throws XPathException {
        if (this.escapeURIAttributes && this.isUrlAttribute(this.currentElement, n) && (n4 & 1) == 0) {
            this.getUnderlyingReceiver().attribute(n, n2, HTMLURIEscaper.escapeURL(charSequence, true), n3, n4 | 2);
        } else {
            this.getUnderlyingReceiver().attribute(n, n2, charSequence, n3, n4);
        }
    }

    public static CharSequence escapeURL(CharSequence charSequence, boolean bl) {
        for (int i = charSequence.length() - 1; i >= 0; --i) {
            char c = charSequence.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            if (bl) {
                CharSequence charSequence2 = new Normalizer(2).normalize(charSequence);
                return HTMLURIEscaper.reallyEscapeURL(charSequence2);
            }
            return HTMLURIEscaper.reallyEscapeURL(charSequence);
        }
        return charSequence;
    }

    private static CharSequence reallyEscapeURL(CharSequence charSequence) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() + 20);
        byte[] byArray = new byte[4];
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c < ' ' || c > '~') {
                int n = UnicodeCharacterSet.getUTF8Encoding(c, i + 1 < charSequence.length() ? charSequence.charAt(i + 1) : (char)' ', byArray);
                for (int j = 0; j < n; ++j) {
                    int n2 = byArray[j] & 0xFF;
                    fastStringBuffer.append('%');
                    fastStringBuffer.append("0123456789ABCDEF".charAt(n2 / 16));
                    fastStringBuffer.append("0123456789ABCDEF".charAt(n2 % 16));
                }
                continue;
            }
            fastStringBuffer.append(c);
        }
        return fastStringBuffer;
    }

    static {
        HTMLURIEscaper.setUrlAttribute("form", "action");
        HTMLURIEscaper.setUrlAttribute("object", "archive");
        HTMLURIEscaper.setUrlAttribute("body", "background");
        HTMLURIEscaper.setUrlAttribute("q", "cite");
        HTMLURIEscaper.setUrlAttribute("blockquote", "cite");
        HTMLURIEscaper.setUrlAttribute("del", "cite");
        HTMLURIEscaper.setUrlAttribute("ins", "cite");
        HTMLURIEscaper.setUrlAttribute("object", "classid");
        HTMLURIEscaper.setUrlAttribute("object", "codebase");
        HTMLURIEscaper.setUrlAttribute("applet", "codebase");
        HTMLURIEscaper.setUrlAttribute("object", "data");
        HTMLURIEscaper.setUrlAttribute("button", "datasrc");
        HTMLURIEscaper.setUrlAttribute("div", "datasrc");
        HTMLURIEscaper.setUrlAttribute("input", "datasrc");
        HTMLURIEscaper.setUrlAttribute("object", "datasrc");
        HTMLURIEscaper.setUrlAttribute("select", "datasrc");
        HTMLURIEscaper.setUrlAttribute("span", "datasrc");
        HTMLURIEscaper.setUrlAttribute("table", "datasrc");
        HTMLURIEscaper.setUrlAttribute("textarea", "datasrc");
        HTMLURIEscaper.setUrlAttribute("script", "for");
        HTMLURIEscaper.setUrlAttribute("a", "href");
        HTMLURIEscaper.setUrlAttribute("a", "name");
        HTMLURIEscaper.setUrlAttribute("area", "href");
        HTMLURIEscaper.setUrlAttribute("link", "href");
        HTMLURIEscaper.setUrlAttribute("base", "href");
        HTMLURIEscaper.setUrlAttribute("img", "longdesc");
        HTMLURIEscaper.setUrlAttribute("frame", "longdesc");
        HTMLURIEscaper.setUrlAttribute("iframe", "longdesc");
        HTMLURIEscaper.setUrlAttribute("head", "profile");
        HTMLURIEscaper.setUrlAttribute("script", "src");
        HTMLURIEscaper.setUrlAttribute("input", "src");
        HTMLURIEscaper.setUrlAttribute("frame", "src");
        HTMLURIEscaper.setUrlAttribute("iframe", "src");
        HTMLURIEscaper.setUrlAttribute("img", "src");
        HTMLURIEscaper.setUrlAttribute("img", "usemap");
        HTMLURIEscaper.setUrlAttribute("input", "usemap");
        HTMLURIEscaper.setUrlAttribute("object", "usemap");
    }
}

