/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.jdom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.jdom.DocumentWrapper;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SiblingCountingNode;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class NodeWrapper
implements NodeInfo,
VirtualNode,
SiblingCountingNode {
    protected Object node;
    protected short nodeKind;
    private NodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;

    protected NodeWrapper(Object object, NodeWrapper nodeWrapper, int n) {
        this.node = object;
        this.parent = nodeWrapper;
        this.index = n;
    }

    protected NodeWrapper makeWrapper(Object object, DocumentWrapper documentWrapper) {
        return this.makeWrapper(object, documentWrapper, null, -1);
    }

    protected NodeWrapper makeWrapper(Object object, DocumentWrapper documentWrapper, NodeWrapper nodeWrapper, int n) {
        NodeWrapper nodeWrapper2;
        if (object instanceof Document) {
            return documentWrapper;
        }
        if (object instanceof Element) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeKind = 1;
        } else if (object instanceof Attribute) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeKind = (short)2;
        } else if (object instanceof String || object instanceof Text) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeKind = (short)3;
        } else if (object instanceof Comment) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeKind = (short)8;
        } else if (object instanceof ProcessingInstruction) {
            nodeWrapper2 = new NodeWrapper(object, nodeWrapper, n);
            nodeWrapper2.nodeKind = (short)7;
        } else {
            if (object instanceof Namespace) {
                throw new IllegalArgumentException("Cannot wrap JDOM namespace objects");
            }
            throw new IllegalArgumentException("Bad node type in JDOM! " + object.getClass() + " instance " + object.toString());
        }
        nodeWrapper2.docWrapper = documentWrapper;
        return nodeWrapper2;
    }

    public Object getUnderlyingNode() {
        if (this.node instanceof List) {
            return ((List)this.node).get(0);
        }
        return this.node;
    }

    public Configuration getConfiguration() {
        return this.docWrapper.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.docWrapper.getNamePool();
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator((Item)((AtomicValue)this.atomize()));
    }

    public Value atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    public int getTypeAnnotation() {
        if (this.getNodeKind() == 2) {
            return 642;
        }
        return 641;
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof NodeWrapper)) {
            return false;
        }
        NodeWrapper nodeWrapper = (NodeWrapper)nodeInfo;
        return this.node.equals(nodeWrapper.node);
    }

    public boolean equals(Object object) {
        if (object instanceof NodeInfo) {
            return this.isSameNodeInfo((NodeInfo)object);
        }
        return false;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    public void setSystemId(String string) {
        this.docWrapper.baseURI = string;
    }

    public String getBaseURI() {
        if (this.getNodeKind() == 13) {
            return null;
        }
        NodeWrapper nodeWrapper = this;
        if (this.getNodeKind() != 1) {
            nodeWrapper = this.getParent();
        }
        while (nodeWrapper != null) {
            String string = nodeWrapper.getAttributeValue(385);
            if (string != null) {
                return string;
            }
            nodeWrapper = nodeWrapper.getParent();
        }
        return this.docWrapper.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof SiblingCountingNode) {
            return Navigator.compareOrder((SiblingCountingNode)this, (SiblingCountingNode)((SiblingCountingNode)nodeInfo));
        }
        return -nodeInfo.compareOrder((NodeInfo)this);
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        if (this.node instanceof List) {
            List list = (List)this.node;
            FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
            for (int i = 0; i < list.size(); ++i) {
                Text text = (Text)list.get(i);
                fastStringBuffer.append(NodeWrapper.getStringValue(text));
            }
            return fastStringBuffer;
        }
        return NodeWrapper.getStringValue(this.node);
    }

    private static String getStringValue(Object object) {
        if (object instanceof Document) {
            List list = ((Document)object).getContent();
            FastStringBuffer fastStringBuffer = new FastStringBuffer(2048);
            NodeWrapper.expandStringValue(list, fastStringBuffer);
            return fastStringBuffer.toString();
        }
        if (object instanceof Element) {
            return ((Element)object).getValue();
        }
        if (object instanceof Attribute) {
            return ((Attribute)object).getValue();
        }
        if (object instanceof Text) {
            return ((Text)object).getText();
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Comment) {
            return ((Comment)object).getText();
        }
        if (object instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)object).getData();
        }
        if (object instanceof Namespace) {
            return ((Namespace)object).getURI();
        }
        return "";
    }

    private static void expandStringValue(List list, FastStringBuffer fastStringBuffer) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Element) {
                fastStringBuffer.append(((Element)e).getValue());
                continue;
            }
            if (e instanceof Text) {
                fastStringBuffer.append(((Text)e).getText());
                continue;
            }
            if (e instanceof EntityRef) {
                throw new IllegalStateException("Unexpanded entity in JDOM tree");
            }
            if (!(e instanceof DocType)) {
                throw new AssertionError((Object)"Unknown JDOM node type");
            }
        }
    }

    public int getNameCode() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: 
            case 13: {
                return this.docWrapper.getNamePool().allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
            }
        }
        return -1;
    }

    public int getFingerprint() {
        int n = this.getNameCode();
        if (n == -1) {
            return -1;
        }
        return n & 0xFFFFF;
    }

    public String getLocalPart() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getName();
            }
            case 2: {
                return ((Attribute)this.node).getName();
            }
            case 3: 
            case 8: 
            case 9: {
                return "";
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
            case 13: {
                return ((Namespace)this.node).getPrefix();
            }
        }
        return null;
    }

    public String getPrefix() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespacePrefix();
            }
            case 2: {
                return ((Attribute)this.node).getNamespacePrefix();
            }
        }
        return "";
    }

    public String getURI() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespaceURI();
            }
            case 2: {
                return ((Attribute)this.node).getNamespaceURI();
            }
        }
        return "";
    }

    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getQualifiedName();
            }
            case 2: {
                return ((Attribute)this.node).getQualifiedName();
            }
            case 7: 
            case 13: {
                return this.getLocalPart();
            }
        }
        return "";
    }

    public NodeInfo getParent() {
        if (this.parent == null) {
            if (this.node instanceof Element) {
                this.parent = ((Element)this.node).isRootElement() ? this.makeWrapper(((Element)this.node).getDocument(), this.docWrapper) : this.makeWrapper(((Element)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Text) {
                this.parent = this.makeWrapper(((Text)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Comment) {
                this.parent = this.makeWrapper(((Comment)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof ProcessingInstruction) {
                this.parent = this.makeWrapper(((ProcessingInstruction)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Attribute) {
                this.parent = this.makeWrapper(((Attribute)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Document) {
                this.parent = null;
            } else {
                if (this.node instanceof Namespace) {
                    throw new UnsupportedOperationException("Cannot find parent of JDOM namespace node");
                }
                throw new IllegalStateException("Unknown JDOM node type " + this.node.getClass());
            }
        }
        return this.parent;
    }

    public int getSiblingPosition() {
        if (this.index == -1) {
            NodeInfo nodeInfo;
            AxisIterator axisIterator;
            int n = 0;
            this.getParent();
            switch (this.nodeKind) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    axisIterator = this.parent.iterateAxis((byte)3);
                    break;
                }
                case 2: {
                    axisIterator = this.parent.iterateAxis((byte)2);
                    break;
                }
                case 13: {
                    axisIterator = this.parent.iterateAxis((byte)8);
                    break;
                }
                default: {
                    this.index = 0;
                    return this.index;
                }
            }
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (nodeInfo.isSameNodeInfo((NodeInfo)this)) {
                    this.index = n;
                    return this.index;
                }
                if (((NodeWrapper)nodeInfo).node instanceof List) {
                    n += ((List)((NodeWrapper)nodeInfo).node).size();
                    continue;
                }
                ++n;
            }
            throw new IllegalStateException("JDOM node not linked to parent node");
        }
        return this.index;
    }

    public AxisIterator iterateAxis(byte by) {
        return this.iterateAxis(by, (NodeTest)AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: {
                if (this.nodeKind == 9) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter((AxisIterator)new Navigator.AncestorEnumeration((NodeInfo)this, false), nodeTest);
            }
            case 1: {
                if (this.nodeKind == 9) {
                    return Navigator.filteredSingleton((NodeInfo)this, (NodeTest)nodeTest);
                }
                return new Navigator.AxisFilter((AxisIterator)new Navigator.AncestorEnumeration((NodeInfo)this, true), nodeTest);
            }
            case 2: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter((AxisIterator)new AttributeEnumeration(this), nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new Navigator.AxisFilter((AxisIterator)new ChildEnumeration(this, true, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.hasChildNodes()) {
                    return new Navigator.AxisFilter((AxisIterator)new Navigator.DescendantEnumeration((NodeInfo)this, false, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.DescendantEnumeration((NodeInfo)this, true, true), nodeTest);
            }
            case 6: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.FollowingEnumeration((NodeInfo)this), nodeTest);
            }
            case 7: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter((AxisIterator)new ChildEnumeration(this, false, true), nodeTest);
            }
            case 8: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new NamespaceIterator((NodeInfo)this, nodeTest);
            }
            case 9: {
                this.getParent();
                return Navigator.filteredSingleton((NodeInfo)this.parent, (NodeTest)nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.PrecedingEnumeration((NodeInfo)this, false), nodeTest);
            }
            case 11: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter((AxisIterator)new ChildEnumeration(this, false, false), nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton((NodeInfo)this, (NodeTest)nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.PrecedingEnumeration((NodeInfo)this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public String getAttributeValue(int n) {
        if (this.nodeKind == 1) {
            NamePool namePool = this.docWrapper.getNamePool();
            String string = namePool.getURI(n);
            String string2 = namePool.getLocalName(n);
            return ((Element)this.node).getAttributeValue(string2, string.equals("http://www.w3.org/XML/1998/namespace") ? Namespace.XML_NAMESPACE : Namespace.getNamespace((String)string));
        }
        return null;
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    public boolean hasChildNodes() {
        switch (this.nodeKind) {
            case 9: {
                return true;
            }
            case 1: {
                return !((Element)this.node).getContent().isEmpty();
            }
        }
        return false;
    }

    public void generateId(FastStringBuffer fastStringBuffer) {
        Navigator.appendSequentialKey((SiblingCountingNode)this, (FastStringBuffer)fastStringBuffer, (boolean)true);
    }

    public int getDocumentNumber() {
        return this.getDocumentRoot().getDocumentNumber();
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        Navigator.copy((NodeInfo)this, (Receiver)receiver, (NamePool)this.docWrapper.getNamePool(), (int)n, (boolean)bl, (int)n2);
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        Navigator.sendNamespaceDeclarations((NodeInfo)this, (Receiver)receiver, (boolean)bl);
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        if (this.node instanceof Element) {
            Element element = (Element)this.node;
            List list = element.getAdditionalNamespaces();
            int n = list.size() + 1;
            int[] nArray2 = n <= nArray.length ? nArray : new int[n];
            NamePool namePool = this.getNamePool();
            Namespace namespace = element.getNamespace();
            String string = namespace.getPrefix();
            String string2 = namespace.getURI();
            nArray2[0] = namePool.allocateNamespaceCode(string, string2);
            int n2 = 1;
            if (list.size() > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    namespace = (Namespace)iterator.next();
                    nArray2[n2++] = namePool.allocateNamespaceCode(namespace.getPrefix(), namespace.getURI());
                }
            }
            if (n < nArray.length) {
                nArray2[n] = -1;
            }
            return nArray2;
        }
        return null;
    }

    private final class ChildEnumeration
    extends Navigator.BaseEnumeration {
        private NodeWrapper start;
        private NodeWrapper commonParent;
        private ListIterator children;
        private int ix = 0;
        private boolean downwards;
        private boolean forwards;

        public ChildEnumeration(NodeWrapper nodeWrapper2, boolean bl, boolean bl2) {
            this.start = nodeWrapper2;
            this.downwards = bl;
            this.forwards = bl2;
            this.commonParent = bl ? nodeWrapper2 : (NodeWrapper)nodeWrapper2.getParent();
            this.children = this.commonParent.getNodeKind() == 9 ? ((Document)this.commonParent.node).getContent().listIterator() : ((Element)this.commonParent.node).getContent().listIterator();
            if (bl) {
                if (!bl2) {
                    while (this.children.hasNext()) {
                        this.children.next();
                        ++this.ix;
                    }
                }
            } else {
                this.ix = nodeWrapper2.getSiblingPosition();
                Object var5_5 = null;
                if (bl2) {
                    int n;
                    for (n = 0; n <= this.ix; ++n) {
                        var5_5 = this.children.next();
                    }
                    if (var5_5 instanceof Text) {
                        n = 0;
                        while (var5_5 instanceof Text) {
                            if (this.children.hasNext()) {
                                var5_5 = this.children.next();
                                ++this.ix;
                                continue;
                            }
                            n = 1;
                            break;
                        }
                        if (n == 0) {
                            this.children.previous();
                        }
                    } else {
                        ++this.ix;
                    }
                } else {
                    for (int i = 0; i < this.ix; ++i) {
                        this.children.next();
                    }
                    --this.ix;
                }
            }
        }

        public void advance() {
            if (this.forwards) {
                if (this.children.hasNext()) {
                    Object e = this.children.next();
                    if (e instanceof DocType) {
                        this.advance();
                        return;
                    }
                    if (e instanceof EntityRef) {
                        throw new IllegalStateException("Unexpanded entity in JDOM tree");
                    }
                    if (e instanceof Text) {
                        if (this.isAtomizing()) {
                            FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
                            fastStringBuffer.append(NodeWrapper.getStringValue(NodeWrapper.this.node));
                            while (this.children.hasNext()) {
                                Object e2 = this.children.next();
                                if (e2 instanceof Text) {
                                    fastStringBuffer.append(NodeWrapper.getStringValue(e2));
                                    ++this.ix;
                                    continue;
                                }
                                this.children.previous();
                                break;
                            }
                            this.current = new UntypedAtomicValue((CharSequence)fastStringBuffer);
                        } else {
                            this.current = NodeWrapper.this.makeWrapper(e, NodeWrapper.this.docWrapper, this.commonParent, this.ix++);
                            ArrayList<Object> arrayList = null;
                            while (this.children.hasNext()) {
                                Object e3 = this.children.next();
                                if (e3 instanceof Text) {
                                    if (arrayList == null) {
                                        arrayList = new ArrayList<Object>(4);
                                        arrayList.add(((NodeWrapper)this.current).node);
                                    }
                                    arrayList.add(e3);
                                    ++this.ix;
                                    continue;
                                }
                                this.children.previous();
                                break;
                            }
                            if (arrayList != null) {
                                ((NodeWrapper)this.current).node = arrayList;
                            }
                        }
                    } else {
                        this.current = this.isAtomizing() ? new UntypedAtomicValue((CharSequence)NodeWrapper.getStringValue(NodeWrapper.this.node)) : NodeWrapper.this.makeWrapper(e, NodeWrapper.this.docWrapper, this.commonParent, this.ix++);
                    }
                } else {
                    this.current = null;
                }
            } else if (this.children.hasPrevious()) {
                Object e = this.children.previous();
                if (e instanceof DocType) {
                    this.advance();
                    return;
                }
                if (e instanceof EntityRef) {
                    throw new IllegalStateException("Unexpanded entity in JDOM tree");
                }
                if (e instanceof Text) {
                    if (this.isAtomizing()) {
                        StringBuffer stringBuffer = new StringBuffer(100);
                        stringBuffer.insert(0, NodeWrapper.getStringValue(e));
                        while (this.children.hasPrevious()) {
                            Object e4 = this.children.previous();
                            if (e4 instanceof Text) {
                                stringBuffer.insert(0, NodeWrapper.getStringValue(e4));
                                --this.ix;
                                continue;
                            }
                            this.children.next();
                            break;
                        }
                        this.current = new UntypedAtomicValue((CharSequence)stringBuffer);
                    } else {
                        this.current = NodeWrapper.this.makeWrapper(e, NodeWrapper.this.docWrapper, this.commonParent, this.ix--);
                        ArrayList<Object> arrayList = null;
                        while (this.children.hasPrevious()) {
                            Object e5 = this.children.previous();
                            if (e5 instanceof Text) {
                                if (arrayList == null) {
                                    arrayList = new ArrayList<Object>(4);
                                    arrayList.add(((NodeWrapper)this.current).node);
                                }
                                arrayList.add(0, e5);
                                --this.ix;
                                continue;
                            }
                            this.children.next();
                            break;
                        }
                        if (arrayList != null) {
                            ((NodeWrapper)this.current).node = arrayList;
                        }
                    }
                } else {
                    this.current = this.isAtomizing() ? new UntypedAtomicValue((CharSequence)NodeWrapper.getStringValue(NodeWrapper.this.node)) : NodeWrapper.this.makeWrapper(e, NodeWrapper.this.docWrapper, this.commonParent, this.ix--);
                }
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new ChildEnumeration(this.start, this.downwards, this.forwards);
        }
    }

    private final class AttributeEnumeration
    extends Navigator.BaseEnumeration {
        private Iterator atts;
        private int ix = 0;
        private NodeWrapper start;

        public AttributeEnumeration(NodeWrapper nodeWrapper2) {
            this.start = nodeWrapper2;
            this.atts = ((Element)nodeWrapper2.node).getAttributes().iterator();
        }

        public void advance() {
            this.current = this.atts.hasNext() ? NodeWrapper.this.makeWrapper(this.atts.next(), NodeWrapper.this.docWrapper, this.start, this.ix++) : null;
        }

        public SequenceIterator getAnother() {
            return new AttributeEnumeration(this.start);
        }
    }
}

