/*
 * Decompiled with CFR 0.152.
 */
package org.sektor37.minium.test;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import org.sektor37.minium.TextRenderer;
import org.sektor37.minium.TextRendererConfigurationException;
import org.sektor37.minium.TextRendererFactory;
import org.sektor37.minium.test.TestClipping1;
import org.sektor37.minium.test.TestDecoration;
import org.sektor37.minium.test.TestFontSizes;
import org.sektor37.minium.test.TestStyledRun;
import org.sektor37.minium.test.TestSubpixelPositioning;
import org.sektor37.minium.test.TestTransform;

public class TextRendererTest
extends JTabbedPane {
    private static final boolean showLens = false;
    TextRenderer java2dRenderer;
    TextRenderer oversamplingRenderer;
    TextRenderer textRenderer;
    Font currentFont;

    public TextRendererTest(JFrame frame) throws TextRendererConfigurationException, FontFormatException, IOException {
        System.setProperty("org.sektor37.minium.TextRendererFactory", "org.sektor37.minium.impl.Java2DTextRendererFactory");
        this.java2dRenderer = TextRendererFactory.newInstance().newTextRenderer();
        System.setProperty("org.sektor37.minium.TextRendererFactory", "org.sektor37.minium.impl.OversamplingTextRendererFactory");
        this.oversamplingRenderer = TextRendererFactory.newInstance().newTextRenderer();
        this.textRenderer = this.java2dRenderer;
        this.addTab("Subpixel", null, new TestSubpixelPositioning(this), null);
        this.addTab("Font Sizes", null, new TestFontSizes(this), null);
        this.addTab("H-Clipping", null, new TestClipping1(this), null);
        this.addTab("Decoration", null, new TestDecoration(this), null);
        this.addTab("Styled Runs", null, new TestStyledRun(this), null);
        this.addTab("Transform", null, new TestTransform(this), null);
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        JMenu rendererMenu = new JMenu("Renderer");
        menuBar.add(rendererMenu);
        JRadioButtonMenuItem defaultRendererMenuItem = new JRadioButtonMenuItem(new AbstractAction("Java 2D"){

            public void actionPerformed(ActionEvent event) {
                TextRendererTest.this.textRenderer = TextRendererTest.this.java2dRenderer;
                TextRendererTest.this.repaint();
            }
        });
        JRadioButtonMenuItem oversamplingRendererMenuItem = new JRadioButtonMenuItem(new AbstractAction("Oversampling"){

            public void actionPerformed(ActionEvent event) {
                TextRendererTest.this.textRenderer = TextRendererTest.this.oversamplingRenderer;
                TextRendererTest.this.repaint();
            }
        });
        Font[] fonts = new Font[]{new Font("Helvetica", 0, 1), new Font("Bitstream Vera Sans", 0, 1), new Font("Bitstream Vera Serif", 0, 1), new Font("Bitstream Charter", 0, 1), new Font("Arial", 0, 1), new Font("Verdana", 0, 1), new Font("Trebuchet MS", 0, 1), new Font("Georgia", 0, 1), new Font("Tahoma", 0, 1), new Font("Courier New", 0, 1), new Font("Comic Sans MS", 0, 1)};
        JMenu fontMenu = new JMenu("Font");
        menuBar.add(fontMenu);
        ButtonGroup fontGroup = new ButtonGroup();
        this.currentFont = fonts[0];
        for (int i = 0; i < fonts.length; ++i) {
            JRadioButtonMenuItem fontItem = new JRadioButtonMenuItem(new SetFontAction(fonts[i]));
            fontMenu.add(fontItem);
            fontItem.setSelected(this.currentFont == fonts[i]);
            fontGroup.add(fontItem);
        }
        rendererMenu.add(defaultRendererMenuItem);
        rendererMenu.add(oversamplingRendererMenuItem);
        ButtonGroup rendererGroup = new ButtonGroup();
        rendererGroup.add(defaultRendererMenuItem);
        rendererGroup.add(oversamplingRendererMenuItem);
        defaultRendererMenuItem.setSelected(this.java2dRenderer == this.textRenderer);
        oversamplingRendererMenuItem.setSelected(this.oversamplingRenderer == this.textRenderer);
    }

    public Dimension getPreferredSize() {
        return new Dimension(700, 700);
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("Minium Test");
        TextRendererTest canvas = new TextRendererTest(frame);
        frame.getContentPane().add(canvas);
        Object lens = null;
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public TextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public Font getCurrentFont() {
        return this.currentFont;
    }

    private class SetFontAction
    extends AbstractAction {
        private Font font;

        public SetFontAction(Font font) {
            super(font.getName());
            this.font = font;
        }

        public void actionPerformed(ActionEvent event) {
            TextRendererTest.this.currentFont = this.font;
            TextRendererTest.this.repaint();
        }
    }
}

