/*
 * Decompiled with CFR 0.152.
 */
package org.sektor37.minium.test;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import org.sektor37.minium.test.TextRendererTest;

public class TestStyledRun
extends JComponent {
    private static final String testString1 = "The quick brown fox jumps over the lazy dog";
    private TextRendererTest parent;

    public TestStyledRun(TextRendererTest parent) {
        this.parent = parent;
    }

    public void paint(Graphics _g) {
        Graphics2D g = (Graphics2D)_g;
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Font font = this.parent.getCurrentFont();
        Run[] runs = new Run[]{new Run("The ", Color.BLACK, font.deriveFont(0).deriveFont(13.0f)), new Run("quick ", Color.BLACK, font.deriveFont(2).deriveFont(12.5f)), new Run("brown ", Color.BLACK, font.deriveFont(1).deriveFont(17.0f)), new Run("fox ", Color.BLACK, font.deriveFont(3).deriveFont(9.0f)), new Run("jumps ", Color.BLACK, font.deriveFont(2).deriveFont(19.0f)), new Run("over ", Color.BLACK, font.deriveFont(1).deriveFont(11.0f)), new Run("the ", Color.BLACK, font.deriveFont(0).deriveFont(16.0f)), new Run("l", Color.BLUE, font.deriveFont(1).deriveFont(14.0f)), new Run("a", Color.RED, font.deriveFont(1).deriveFont(14.0f)), new Run("z", Color.MAGENTA, font.deriveFont(1).deriveFont(14.0f)), new Run("y", Color.BLUE, font.deriveFont(1).deriveFont(14.0f)), new Run(" dog", Color.BLACK, font.deriveFont(3).deriveFont(18.5f))};
        float x = 10.0f;
        for (int i = 0; i < runs.length; ++i) {
            g.setFont(runs[i].font);
            g.setColor(runs[i].color);
            this.parent.getTextRenderer().drawString(g, runs[i].text, x, 40.0f);
            x += (float)this.parent.getTextRenderer().getLogicalBounds(g, g.getFont(), runs[i].text).getWidth();
        }
        g.draw(new Line2D.Float(10.0f, 42.0f, x, 42.0f));
    }

    private static class Run {
        String text;
        Font font;
        Color color;

        Run(String text, Color color, Font font) {
            this.text = text;
            this.color = color;
            this.font = font;
        }
    }
}

