/*
 * Decompiled with CFR 0.152.
 */
package org.sektor37.minium.test;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class Lens
extends JDialog
implements MouseListener,
MouseMotionListener {
    int dim = 32;
    int mag = 4;
    int x = 100;
    int y = 100;
    boolean showGrid = false;
    BufferedImage image;
    int[] pixels;
    PixelGrabber pg;
    Robot robot;
    private JFrame observed;
    private GlassPane glassPane;
    private Container contentPane;
    private boolean drag;
    private int dragOffsetX;
    private int dragOffsetY;

    public void update() {
        Point pt = new Point(0, 0);
        SwingUtilities.convertPointToScreen(pt, this.observed.getGlassPane());
        this.image = new BufferedImage(this.dim, this.dim, 2);
        Graphics2D g = this.image.createGraphics();
        g.translate(-this.x, -this.y);
        g.setClip(this.x, this.y, this.dim, this.dim);
        this.observed.getLayeredPane().paint(g);
        try {
            this.pg = new PixelGrabber(this.image, 0, 0, this.dim, this.dim, this.pixels, 0, this.dim);
            this.pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((this.pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
    }

    public Lens(JFrame observed) throws AWTException {
        this.observed = observed;
        this.contentPane = observed.getContentPane();
        this.glassPane = new GlassPane();
        observed.getRootPane().setGlassPane(this.glassPane);
        this.glassPane.addMouseListener(this);
        this.glassPane.addMouseMotionListener(this);
        this.glassPane.setVisible(true);
        this.add(new LensPane());
        this.image = new BufferedImage(this.dim, this.dim, 2);
        this.pixels = new int[this.dim * this.dim];
        this.robot = new Robot();
        this.setTitle("Lens");
        this.setResizable(false);
        this.update();
    }

    public void mousePressed(MouseEvent event) {
        int mx = event.getX();
        int my = event.getY();
        if (mx >= this.x && mx < this.x + this.dim && my >= this.y && my < this.y + this.dim) {
            this.drag = true;
            this.dragOffsetX = mx - this.x;
            this.dragOffsetY = my - this.y;
        } else {
            this.drag = false;
            this.redispatchMouseEvent(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        this.redispatchMouseEvent(event);
    }

    public void mouseClicked(MouseEvent event) {
        this.redispatchMouseEvent(event);
    }

    public void mouseEntered(MouseEvent event) {
        this.redispatchMouseEvent(event);
    }

    public void mouseExited(MouseEvent event) {
        this.redispatchMouseEvent(event);
    }

    public void mouseMoved(MouseEvent event) {
        this.redispatchMouseEvent(event);
    }

    public void mouseDragged(MouseEvent event) {
        if (this.drag) {
            this.observed.getLayeredPane().repaint(this.x, this.y, this.dim + 1, this.dim + 1);
            this.x = event.getX() - this.dragOffsetX;
            this.y = event.getY() - this.dragOffsetY;
            this.observed.getLayeredPane().repaint(this.x, this.y, this.dim + 1, this.dim + 1);
        } else {
            this.redispatchMouseEvent(event);
        }
    }

    private void redispatchMouseEvent(MouseEvent e) {
        Component component;
        Point glassPanePoint = e.getPoint();
        JRootPane container = this.observed.getRootPane();
        Point containerPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, container);
        if (containerPoint.y >= 0 && null != (component = SwingUtilities.getDeepestComponentAt(this.observed.getLayeredPane(), containerPoint.x, containerPoint.y)) && this.glassPane != component && this.observed != component) {
            Point componentPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, component);
            component.dispatchEvent(new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
        }
    }

    private class LensPane
    extends JComponent {
        private LensPane() {
        }

        public void paint(Graphics g) {
            Lens.this.update();
            if (Lens.this.showGrid) {
                for (int i = 1; i < Lens.this.dim; ++i) {
                    g.drawLine(0, i * Lens.this.mag - 1, Lens.this.dim * Lens.this.mag, i * Lens.this.mag - 1);
                    g.drawLine(i * Lens.this.mag - 1, 0, i * Lens.this.mag - 1, Lens.this.dim * Lens.this.mag);
                }
            }
            for (int y = 0; y < Lens.this.dim; ++y) {
                for (int x = 0; x < Lens.this.dim; ++x) {
                    g.setColor(new Color(Lens.this.pixels[y * Lens.this.dim + x]));
                    g.fillRect(x * Lens.this.mag, y * Lens.this.mag, Lens.this.mag - (Lens.this.showGrid ? 1 : 0), Lens.this.mag - (Lens.this.showGrid ? 1 : 0));
                }
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(Lens.this.dim * Lens.this.mag - 1, Lens.this.dim * Lens.this.mag - 1);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    private class GlassPane
    extends JComponent {
        private GlassPane() {
        }

        public void paintComponent(Graphics g) {
            g.setColor(Color.BLUE);
            g.drawRect(Lens.this.x, Lens.this.y, Lens.this.dim, Lens.this.dim);
            Lens.this.repaint();
        }
    }
}

