/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERObject;

public class IssuingDistributionPoint
extends ASN1Encodable {
    private boolean onlyContainsUserCerts;
    private boolean onlyContainsCACerts;
    private boolean indirectCRL;
    private boolean onlyContainsAttributeCerts;
    private ASN1Sequence seq;

    public static IssuingDistributionPoint getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return IssuingDistributionPoint.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static IssuingDistributionPoint getInstance(Object object) {
        if (object == null || object instanceof IssuingDistributionPoint) {
            return (IssuingDistributionPoint)object;
        }
        if (object instanceof ASN1Sequence) {
            return new IssuingDistributionPoint((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public IssuingDistributionPoint(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
        int n = 0;
        while (n != aSN1Sequence.size()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(n);
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.onlyContainsUserCerts = DERBoolean.getInstance(aSN1TaggedObject, false).isTrue();
                    break;
                }
                case 2: {
                    this.onlyContainsCACerts = DERBoolean.getInstance(aSN1TaggedObject, false).isTrue();
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.indirectCRL = DERBoolean.getInstance(aSN1TaggedObject, false).isTrue();
                    break;
                }
                case 5: {
                    this.onlyContainsAttributeCerts = DERBoolean.getInstance(aSN1TaggedObject, false).isTrue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag in IssuingDistributionPoint");
                }
            }
            ++n;
        }
    }

    public boolean onlyContainsUserCerts() {
        return this.onlyContainsUserCerts;
    }

    public boolean onlyContainsCACerts() {
        return this.onlyContainsCACerts;
    }

    public boolean isIndirectCRL() {
        return this.indirectCRL;
    }

    public boolean onlyContainsAttributeCerts() {
        return this.onlyContainsAttributeCerts;
    }

    public DERObject toASN1Object() {
        return this.seq;
    }
}

