/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sql.SQLColumn;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;

public class SQLInsert
extends ExtensionInstruction {
    Expression connection;
    String table;

    public void prepareAttributes() throws XPathException {
        String string;
        this.table = this.getAttributeList().getValue("", "table");
        if (this.table == null) {
            this.reportAbsence("table");
        }
        if ((string = this.getAttributeList().getValue("", "connection")) == null) {
            this.reportAbsence("connection");
        } else {
            this.connection = this.makeExpression(string);
        }
    }

    public void validate() throws XPathException {
        super.validate();
        this.connection = this.typeCheck("connection", this.connection);
    }

    public Expression compile(Executable executable) throws XPathException {
        NodeInfo nodeInfo;
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append("INSERT INTO " + this.table + " (");
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        int n = 0;
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof SQLColumn)) continue;
            if (n++ > 0) {
                stringBuffer.append(',');
            }
            String string = ((SQLColumn)nodeInfo).getColumnName();
            stringBuffer.append(string);
        }
        stringBuffer.append(") VALUES (");
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('?');
        }
        stringBuffer.append(')');
        return new InsertInstruction(this.connection, stringBuffer.toString(), this.getColumnInstructions(executable));
    }

    public List getColumnInstructions(Executable executable) throws XPathException {
        NodeInfo nodeInfo;
        ArrayList<Expression> arrayList = new ArrayList<Expression>(10);
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
            if (!(nodeInfo instanceof SQLColumn)) continue;
            arrayList.add(((SQLColumn)nodeInfo).compile(executable));
        }
        return arrayList;
    }

    private static class InsertInstruction
    extends SimpleExpression {
        public static final int CONNECTION = 0;
        public static final int FIRST_COLUMN = 1;
        String statement;

        public InsertInstruction(Expression expression, String string, List list) {
            Expression[] expressionArray = new Expression[list.size() + 1];
            expressionArray[0] = expression;
            for (int i = 0; i < list.size(); ++i) {
                expressionArray[i + 1] = (Expression)list.get(i);
            }
            this.statement = string;
            this.setArguments(expressionArray);
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "sql:insert";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            PreparedStatement preparedStatement;
            block11: {
                Item item = this.arguments[0].evaluateItem(xPathContext);
                if (!(item instanceof ObjectValue) || !(((ObjectValue)item).getObject() instanceof Connection)) {
                    this.dynamicError("Value of connection expression is not a JDBC Connection", "SXSQL001", xPathContext);
                }
                Connection connection = (Connection)((ObjectValue)item).getObject();
                preparedStatement = null;
                preparedStatement = connection.prepareStatement(this.statement);
                int n = 1;
                for (int i = 1; i < this.arguments.length; ++i) {
                    AtomicValue atomicValue = (AtomicValue)((SQLColumn.ColumnInstruction)this.arguments[i]).getSelectValue(xPathContext);
                    String string = atomicValue.getStringValue();
                    if (string.length() == 1) {
                        string = string + " ";
                    }
                    preparedStatement.setObject(n++, string);
                }
                preparedStatement.executeUpdate();
                if (connection.getAutoCommit()) break block11;
                connection.commit();
            }
            Object var10_10 = null;
            if (preparedStatement == null) return null;
            try {
                preparedStatement.close();
                return null;
            }
            catch (SQLException sQLException) {}
            return null;
            {
                catch (SQLException sQLException) {
                    this.dynamicError("SQL INSERT failed: " + sQLException.getMessage(), "SXSQL004", xPathContext);
                    Object var10_11 = null;
                    if (preparedStatement == null) return null;
                    try {
                        preparedStatement.close();
                        return null;
                    }
                    catch (SQLException sQLException2) {}
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (preparedStatement == null) throw throwable;
                try {
                    preparedStatement.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

