/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.utils;

import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    private static Logger logger = Logger.getLogger(XmlUtils.class);

    public static String getShortTagName(String uri, String localName, String qName) {
        return localName;
    }

    public static QName getQName(String uri, String localName, String qName) {
        return new QName(uri, localName, qName);
    }

    public static String getPath(Stack<String> stack) {
        StringBuffer ret = new StringBuffer();
        for (String s : stack) {
            ret.append("/").append(s);
        }
        return ret.toString();
    }

    public static String getPath(Stack<QName> stack, NamespaceContext ctx) {
        if (ctx == null) {
            logger.fatal((Object)"NamespaceContext is null");
        }
        StringBuffer ret = new StringBuffer();
        for (QName q : stack) {
            if (q == null) {
                throw new IllegalStateException("q is null");
            }
            ret.append("/");
            String prefix = ctx.getPrefix(q.getNamespaceURI());
            if (prefix != null && prefix.length() > 0) {
                ret.append(prefix).append(":");
            }
            ret.append(q.getLocalPart());
        }
        return ret.toString();
    }

    public static String getXmlDataSubstituteNode(Node node, String substituteWith, String substituteInWhat) {
        StringBuffer sb = new StringBuffer();
        switch (node.getNodeType()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                String nodeName = node.getNodeName();
                if (!substituteInWhat.equals(nodeName)) {
                    NodeList nl;
                    sb.append("<").append(nodeName);
                    StringBuffer attrs = new StringBuffer();
                    StringBuffer children = new StringBuffer();
                    NamedNodeMap nnm = node.getAttributes();
                    if (nnm != null) {
                        for (int i = 0; i < nnm.getLength(); ++i) {
                            Node attr = nnm.item(i);
                            attrs.append(" ").append(XmlUtils.getXmlDataSubstituteNode(attr, substituteWith, substituteInWhat));
                        }
                    }
                    if ((nl = node.getChildNodes()) != null) {
                        for (int i = 0; i < nl.getLength(); ++i) {
                            Node child = nl.item(i);
                            if (child.getNodeType() == 2) {
                                attrs.append(" ").append(XmlUtils.getXmlDataSubstituteNode(child, substituteWith, substituteInWhat));
                                continue;
                            }
                            children.append(XmlUtils.getXmlDataSubstituteNode(child, substituteWith, substituteInWhat));
                        }
                    }
                    sb.append(attrs.toString());
                    if (children.length() > 0) {
                        sb.append(">").append(children.toString()).append("</").append(nodeName).append(">");
                        break;
                    }
                    sb.append("/>");
                    break;
                }
                sb.append(substituteWith);
                break;
            }
            case 2: {
                sb.append(node.getNodeName()).append("=\"").append(StringEscapeUtils.escapeXml(node.getNodeValue())).append("\"");
                break;
            }
            case 4: {
                sb.append("<![CDATA[").append(StringEscapeUtils.escapeXml(node.getNodeValue())).append("]]>");
            }
            case 3: {
                sb.append(StringEscapeUtils.escapeXml(node.getNodeValue()));
            }
        }
        return sb.toString();
    }

    public static String normalizeNS(String xpath, NamespaceContext ns) {
        StringTokenizer tokenizer = new StringTokenizer(xpath, "/", true);
        StringBuffer sb = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            int pos;
            String token = tokenizer.nextToken();
            if (token.equals("/")) {
                sb.append(token);
                continue;
            }
            boolean isAttribute = false;
            if (token.startsWith("@")) {
                token = token.substring(1);
                isAttribute = true;
            }
            if ((pos = token.indexOf(58)) >= 0) {
                String prefix = token.substring(0, pos);
                String localName = token.substring(pos + 1);
                String newPrefix = ns.getPrefix(ns.getNamespaceURI(prefix));
                if (isAttribute && (newPrefix == null || newPrefix.length() == 0)) {
                    newPrefix = prefix;
                }
                if (isAttribute) {
                    sb.append("@");
                }
                if (newPrefix.length() > 0) {
                    sb.append(newPrefix).append(":");
                }
                sb.append(localName);
                continue;
            }
            if (!isAttribute) {
                String newPrefix = ns.getPrefix(ns.getNamespaceURI(""));
                if (newPrefix.length() > 0) {
                    sb.append(newPrefix).append(":");
                }
                sb.append(token);
                continue;
            }
            sb.append("@").append(token);
        }
        return sb.toString();
    }

    public static String getStringRepresentation(DocumentFragment df) {
        StringBuilder sb = new StringBuilder();
        NodeList nl = df.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            sb.append(XmlUtils.nodeToString(n));
        }
        return sb.toString();
    }

    public static String nodeToString(Node n) {
        StringBuilder sb = new StringBuilder();
        if (n instanceof Text) {
            return n.getNodeValue().trim();
        }
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            sb.append(XmlUtils.nodeToString(child));
        }
        if (n.getNodeType() == 1) {
            if ("td".equalsIgnoreCase(n.getNodeName())) {
                sb.append("\t");
            } else if ("th".equalsIgnoreCase(n.getNodeName())) {
                sb.append("\t");
            } else if ("tr".equalsIgnoreCase(n.getNodeName())) {
                sb.append("\n");
            } else if ("br".equalsIgnoreCase(n.getNodeName())) {
                sb.append("\n");
            }
        }
        return sb.toString();
    }
}

