/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HashSwapAttributesPicker<T> {
    Class tClass;
    Vector<Field> allFields;

    HashSwapAttributesPicker(Class<T> ct) throws Exception {
        this.tClass = ct;
        this.allFields = new Vector();
        for (Class<T> c = ct; c != null && c != Object.class; c = c.getSuperclass()) {
            AccessibleObject[] list = c.getDeclaredFields();
            AccessibleObject.setAccessible(list, true);
            for (int i = 0; i < list.length; ++i) {
                AccessibleObject fld = list[i];
                String typeName = ((Field)fld).getType().toString();
                if (!this.acceptableType(typeName)) continue;
                this.allFields.add((Field)fld);
            }
        }
    }

    boolean acceptableType(String typeName) {
        return typeName.equals("class java.lang.String") || typeName.equals("int") || typeName.equals("class java.lang.Integer") || typeName.equals("float") || typeName.equals("class java.lang.Float") || typeName.equals("double") || typeName.equals("class java.lang.Double") || typeName.equals("class java.util.Date");
    }

    public void dumpFields() {
        if (this.allFields != null) {
            for (int i = 0; i < this.allFields.size(); ++i) {
                Field fld = this.allFields.get(i);
                System.out.println("Attribute name: " + fld.getName());
                System.out.println("Data type: " + fld.getType());
                int mod = fld.getModifiers();
                System.out.println("Modifiers: " + Modifier.toString(mod));
                System.out.println("======================================");
            }
        }
    }

    public Object[] getAttributesValues(T obj) throws IllegalAccessException {
        if (this.allFields != null && obj != null) {
            Object[] ret = new Object[this.allFields.size()];
            for (int i = 0; i < this.allFields.size(); ++i) {
                Field fld = this.allFields.get(i);
                ret[i] = fld.get(obj);
            }
            return ret;
        }
        return null;
    }

    public void dumpFieldsOfObject(T obj) throws IllegalAccessException {
        Object[] values = this.getAttributesValues(obj);
        if (values != null) {
            for (int i = 0; i < this.allFields.size(); ++i) {
                Field fld = this.allFields.get(i);
                System.out.println(fld.getType() + " " + fld.getName() + ":" + values[i].toString());
            }
        }
    }

    public T fillFieldsOfObject(T obj, Object[] values) throws IllegalAccessException {
        if (values != null && obj != null && this.allFields != null) {
            for (int i = 0; i < this.allFields.size(); ++i) {
                Field fld = this.allFields.get(i);
                fld.set(obj, values[i]);
            }
            return obj;
        }
        System.out.println(" fillFieldsOfObject NOT OK ");
        return null;
    }

    public T instantiateWithValues(Object[] values) throws IllegalAccessException, InstantiationException {
        System.out.println("instantiateWithValues ...");
        try {
            Object obj = this.tClass.newInstance();
            return this.fillFieldsOfObject(obj, values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

