/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.updater;

import fr.gouv.finances.cp.xemelios.common.NetAccess;
import fr.gouv.finances.cp.xemelios.updater.config.ComponentModel;
import fr.gouv.finances.cp.xemelios.updater.config.SiteModel;
import fr.gouv.finances.cp.xemelios.updater.config.UpdateParser;
import fr.gouv.finances.cp.xemelios.updater.config.XemeliosUpdateModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UpdaterUtil {
    private static Logger logger = Logger.getLogger(UpdaterUtil.class);
    private String updateUrl;
    private String componentsFileLocation;
    private XPathFactory xpf = null;
    private DocumentBuilderFactory domFactory;
    private Hashtable<String, String> installedComponents;
    private XemeliosUpdateModel downladableComponents;

    public UpdaterUtil(String updateUrl, String componentsFileLocation) {
        this.updateUrl = updateUrl;
        this.componentsFileLocation = componentsFileLocation;
        try {
            this.xpf = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
            this.domFactory = DocumentBuilderFactory.newInstance();
        }
        catch (Throwable t) {
            this.xpf = XPathFactory.newInstance();
            t.printStackTrace();
        }
    }

    private XemeliosUpdateModel getUpdatesAtUrl(String urlLocation) throws Exception {
        GetMethod meth;
        HttpClient client = NetAccess.getHttpClient();
        int httpRet = client.executeMethod((HttpMethod)(meth = new GetMethod(urlLocation)));
        if (httpRet > 300) {
            throw new Exception(meth.getStatusText());
        }
        InputStream is = meth.getResponseBodyAsStream();
        UpdateParser up = new UpdateParser();
        up.parse(is);
        is.close();
        XemeliosUpdateModel xum = (XemeliosUpdateModel)up.getMarshallable();
        return xum;
    }

    public boolean areThereUpdatesAvailable() {
        try {
            this.loadInstalledComponents();
            XemeliosUpdateModel xum = this.getUpdatesAtUrl(this.updateUrl);
            return this.checkUpdates(xum);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private boolean checkUpdates(XemeliosUpdateModel xum) {
        String existingVersion;
        logger.debug((Object)"checking for updates");
        boolean ret = false;
        if (xum.getConfigUpdates() != null && xum.getConfigUpdates().getComponents().size() > 0) {
            for (ComponentModel cm : xum.getConfigUpdates().getComponents()) {
                existingVersion = this.installedComponents.get(cm.getId());
                if (existingVersion == null) {
                    return true;
                }
                if (UpdaterUtil.compareReleases(cm.getRelease().getV(), existingVersion) <= 0) continue;
                return true;
            }
        }
        if (xum.getFeaturesUpdates() != null && xum.getFeaturesUpdates().getComponents().size() > 0) {
            for (ComponentModel cm : xum.getFeaturesUpdates().getComponents()) {
                existingVersion = this.installedComponents.get(cm.getId());
                if (existingVersion == null) {
                    return true;
                }
                if (UpdaterUtil.compareReleases(cm.getRelease().getV(), existingVersion) <= 0) continue;
                return true;
            }
        }
        if (xum.getXemeliosUpdates() != null && xum.getXemeliosUpdates().getComponents().size() > 0) {
            for (ComponentModel cm : xum.getXemeliosUpdates().getComponents()) {
                existingVersion = this.installedComponents.get(cm.getId());
                if (existingVersion == null) {
                    return true;
                }
                if (UpdaterUtil.compareReleases(cm.getRelease().getV(), existingVersion) <= 0) continue;
                return true;
            }
        }
        if (xum.getForeignSites() != null) {
            for (SiteModel sm : xum.getForeignSites().getSites()) {
                try {
                    if (!this.checkUpdates(this.getUpdatesAtUrl(sm.getText()))) continue;
                    return true;
                }
                catch (Exception ex) {
                }
            }
        }
        return false;
    }

    protected void loadInstalledComponents() throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        this.installedComponents = new Hashtable();
        InputSource is = new InputSource(new FileReader(new File(this.componentsFileLocation)));
        DocumentBuilder domBuilder = this.domFactory.newDocumentBuilder();
        Document dom = domBuilder.parse(is);
        try {
            XPath xp = this.xpf.newXPath();
            Object o = xp.evaluate("//component", dom, XPathConstants.NODESET);
            if (o instanceof NodeList) {
                NodeList nl = (NodeList)o;
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    try {
                        String compId = (String)xp.evaluate("./@id", el, XPathConstants.STRING);
                        String compRelease = (String)xp.evaluate("./@version", el, XPathConstants.STRING);
                        this.installedComponents.put(compId, compRelease);
                        continue;
                    }
                    catch (XPathExpressionException ex) {
                        ex.printStackTrace();
                    }
                }
            } else if (o instanceof List) {
                List l = (List)o;
                for (Object obj : l) {
                    if (!(obj instanceof Element)) continue;
                    Element el = (Element)obj;
                    try {
                        String compId = (String)xp.evaluate("./@id", el, XPathConstants.STRING);
                        String compRelease = (String)xp.evaluate("./@version", el, XPathConstants.STRING);
                        this.installedComponents.put(compId, compRelease);
                    }
                    catch (XPathExpressionException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (XPathExpressionException ex) {
            // empty catch block
        }
    }

    public static int compareReleases(String r1, String r2) {
        String[] s1 = UpdaterUtil.splitRelease(r1);
        String[] s2 = UpdaterUtil.splitRelease(r2);
        int ret = 0;
        for (int i = 0; i < Math.min(s1.length, s2.length); ++i) {
            int a = -1;
            int b = -1;
            try {
                a = Integer.parseInt(s1[i]);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                b = Integer.parseInt(s2[i]);
            }
            catch (Throwable t) {
                // empty catch block
            }
            ret = a != -1 && b != -1 ? (a < b ? -1 : (a == b ? 0 : 1)) : s1[i].compareTo(s2[i]);
            if (ret == 0) continue;
            return ret;
        }
        if (s1.length > s2.length) {
            ret = 1;
        } else if (s1.length < s2.length) {
            ret = -1;
        }
        return ret;
    }

    private static String[] splitRelease(String r) {
        return r.split("\\.");
    }
}

