/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.ia.core;

import fr.gouv.finances.cp.xemelios.ui.ia.core.State;
import fr.gouv.finances.cp.xemelios.ui.ia.core.Template;

public class StateModel {
    private State state;
    private LocationInformation[][] locations;

    public StateModel(State state) {
        this.state = state;
        this.initialize();
    }

    protected void initialize() {
        int size = this.getGridWidth();
        this.locations = new LocationInformation[size][size];
        Template t = this.state.getTemplate();
        String[][] array = new String[t.maxValue][t.maxValue];
        for (int index = 0; index < t.maxIndex; ++index) {
            int row = t.indexToRow(index);
            int col = t.indexToColumn(index);
            this.locations[row][col] = !this.state.isFree(index) ? new LocationInformation(this.state.getValue(index) + 1) : new LocationInformation(-1);
        }
    }

    public boolean isWritable(int row, int col) {
        return !this.locations[row][col].isOriginal();
    }

    public boolean isValueAllowed(int row, int col, String value) {
        try {
            int v = Integer.parseInt(value);
            if (0 < v && v < 10) {
                for (int i = 0; i < 9; ++i) {
                    if (i != row && value.equals(this.locations[i][col].getValue())) {
                        return false;
                    }
                    if (i == col || !value.equals(this.locations[row][i].getValue())) continue;
                    return false;
                }
                int sqStartRow = row / 3 * 3;
                int sqStartCol = col / 3 * 3;
                for (int i = sqStartRow; i < sqStartRow + 3; ++i) {
                    for (int j = sqStartCol; j < sqStartCol + 3; ++j) {
                        if (i == row || j == col || !value.equals(this.locations[i][j].getValue())) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setValueAt(int row, int col, String value) {
        this.locations[row][col].setValue(value);
    }

    public String getValueAt(int row, int col) {
        return this.locations[row][col].getValue();
    }

    public int getGridWidth() {
        return this.state.getTemplate().maxValue;
    }

    public int getGridHeight() {
        return this.getGridWidth();
    }

    private class LocationInformation {
        private boolean original = false;
        private int value = -1;

        public LocationInformation(int value) {
            this.value = value;
            this.original = value != -1;
        }

        public boolean isOriginal() {
            return this.original;
        }

        public boolean isWrittable() {
            return !this.isOriginal();
        }

        public String getValue() {
            if (this.value != -1) {
                return Integer.toString(this.value);
            }
            return null;
        }

        public void setValue(String v) {
            try {
                this.value = Integer.parseInt(v);
            }
            catch (Exception ex) {
                this.value = -1;
            }
        }
    }
}

