/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.ia;

import fr.gouv.finances.cp.xemelios.ui.ia.DisplayScore;
import fr.gouv.finances.cp.xemelios.ui.ia.Piece;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class Grille
extends JComponent
implements Runnable,
FocusListener,
KeyListener {
    private static final long serialVersionUID = 3257291348414771511L;
    public static final int DEFAULT_WIDTH = 10;
    public static final int DEFAULT_HEIGHT = 20;
    public static final int DIRECTION_UP = -1;
    public static final int DIRECTION_DOWN = 1;
    private Thread m_Grille;
    private Color[][] grids;
    private Color backColor;
    private Piece[] pieces;
    private Piece currentPiece;
    public Piece nextOne;
    private int posX;
    private int posY;
    private int gridWidth;
    private int gridHeight;
    private int idCurrent;
    private int idNextOne;
    private boolean paintAll;
    private boolean paintPiece;
    private boolean gameRunning;
    private boolean gameOverPainted;
    public boolean gameFinished;
    public int cptLines;
    public int cptPoints;
    public int bonus;
    public int level;
    private int direction;
    protected DisplayScore ds = null;
    private boolean finished = false;
    private Image offscreenImg;
    private Image backImg;
    private Graphics offscreenG;

    public Grille(Piece[] lp) {
        this(lp, 10, 20);
    }

    public Grille(Piece[] lp, int w, int h) {
        this.gridWidth = w;
        this.gridHeight = h;
        this.direction = 1;
        this.grids = new Color[this.gridHeight][this.gridWidth];
        this.pieces = lp;
        this.selectPiece();
        this.gameRunning = false;
        this.gameFinished = false;
        this.paintAll = false;
        this.cptPoints = 0;
        this.cptLines = 0;
        this.level = 1;
        this.backColor = Color.darkGray;
        this.gameOverPainted = false;
        this.initListeners();
    }

    private void selectPiece() {
        if (this.nextOne == null) {
            this.idCurrent = (int)(Math.random() * (double)this.pieces.length);
            this.idNextOne = (int)(Math.random() * (double)this.pieces.length);
            this.currentPiece = new Piece(this.pieces[this.idCurrent]);
            this.nextOne = new Piece(this.pieces[this.idNextOne]);
        } else {
            this.currentPiece = this.nextOne;
            this.idCurrent = this.idNextOne;
            this.idNextOne = (int)(Math.random() * (double)this.pieces.length);
            this.nextOne = new Piece(this.pieces[this.idNextOne]);
        }
        this.resetPiece();
        this.bonus = 20;
        this.paintPiece = true;
    }

    private boolean canDisplayAt(int x, int y, Piece p) {
        if (y < 0 || y + p.getHeight() > this.gridHeight) {
            return false;
        }
        if (x < 0 || x + p.getWidth() > this.gridWidth) {
            return false;
        }
        int mask = 32768;
        for (int i = 0; i < p.getHeight(); ++i) {
            int j = 0;
            while (j < p.getWidth()) {
                if ((p.getVal() & mask) != 0 && this.grids[y + i][x + j] != null) {
                    return false;
                }
                ++j;
                mask >>= 1;
            }
            mask >>= 4 - p.getWidth();
        }
        return true;
    }

    private boolean canDisplayAt(int x, int y) {
        return this.canDisplayAt(x, y, this.currentPiece);
    }

    private void reverseGame() {
        for (int i = 0; i < this.gridHeight / 2; ++i) {
            for (int j = 0; j < this.gridWidth; ++j) {
                Color buffer = this.grids[i][j];
                this.grids[i][j] = this.grids[this.gridHeight - 1 - i][j];
                this.grids[this.gridHeight - 1 - i][j] = buffer;
            }
        }
    }

    private void resetPiece() {
        this.posX = this.gridWidth / 2 - this.currentPiece.getWidth() / 2;
        this.posY = this.direction == 1 ? 0 : this.gridHeight - this.currentPiece.getHeight();
        this.currentPiece.reset(this.posX * 15, this.posY * 15);
    }

    private void pieceStop() {
        int j;
        int i;
        int mask = 32768;
        int oldCptLines = this.cptLines;
        for (i = 0; i < this.currentPiece.getHeight(); ++i) {
            j = 0;
            while (j < this.currentPiece.getWidth()) {
                if ((this.currentPiece.getVal() & mask) != 0) {
                    this.grids[this.posY + i][this.posX + j] = this.pieces[this.idCurrent].getColor();
                }
                ++j;
                mask >>= 1;
            }
            mask >>= 4 - this.currentPiece.getWidth();
        }
        this.cptPoints += 5;
        if (this.direction == 1) {
            for (i = this.posY; i < this.posY + this.currentPiece.getHeight(); ++i) {
                int scr_j;
                for (j = 0; j < this.gridWidth && this.grids[i][j] != null; ++j) {
                }
                if (j != this.gridWidth) continue;
                for (int scr_i = i; scr_i > 0; --scr_i) {
                    for (scr_j = 0; scr_j < this.gridWidth; ++scr_j) {
                        this.grids[scr_i][scr_j] = this.grids[scr_i - 1][scr_j];
                    }
                }
                for (scr_j = 0; scr_j < this.gridWidth; ++scr_j) {
                    this.grids[0][scr_j] = null;
                }
                ++this.cptLines;
            }
        } else {
            for (i = this.posY + this.currentPiece.getHeight() - 1; i >= this.posY; --i) {
                int scr_j;
                for (j = 0; j < this.gridWidth && this.grids[i][j] != null; ++j) {
                }
                if (j != this.gridWidth) continue;
                for (int scr_i = i; scr_i < this.gridHeight - 1; ++scr_i) {
                    for (scr_j = 0; scr_j < this.gridWidth; ++scr_j) {
                        this.grids[scr_i][scr_j] = this.grids[scr_i + 1][scr_j];
                    }
                }
                for (scr_j = 0; scr_j < this.gridWidth; ++scr_j) {
                    this.grids[this.gridHeight - 1][scr_j] = null;
                }
                ++this.cptLines;
            }
        }
        if (oldCptLines != this.cptLines) {
            this.cptPoints += (this.cptLines - oldCptLines) * 10;
            if (this.cptLines - oldCptLines == 4) {
                this.cptPoints += 100;
            }
        }
        if (this.level < 12 && this.cptPoints >= 1000 * this.level) {
            ++this.level;
        }
        this.paintAll = true;
        this.paintPiece = false;
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(15 * this.gridWidth, 15 * this.gridHeight);
    }

    public void restartGame() {
        this.selectPiece();
        this.gameRunning = true;
        this.gameFinished = false;
        this.paintAll = true;
        this.cptPoints = 0;
        this.cptLines = 0;
        this.level = 1;
        this.gameOverPainted = false;
        for (int i = 0; i < this.gridHeight; ++i) {
            for (int j = 0; j < this.gridWidth; ++j) {
                this.grids[i][j] = null;
            }
        }
    }

    public void start() {
        if (this.m_Grille == null) {
            this.m_Grille = new Thread(this);
            this.finished = false;
            this.m_Grille.start();
        }
    }

    public void stop() {
        if (this.m_Grille != null) {
            this.finished = true;
            this.m_Grille = null;
        }
    }

    public synchronized void update(Graphics g) {
        this.paint(g);
    }

    public synchronized void paintPiece(boolean effPiece) {
        if (this.offscreenImg == null) {
            return;
        }
        if (effPiece) {
            this.currentPiece.erase(this.offscreenG, this.backColor);
        }
        this.currentPiece.display(this.offscreenG);
    }

    private synchronized void paintGameOver() {
        Font laFont = new Font("Arial", 1, 20);
        FontMetrics fm = this.getFontMetrics(laFont);
        Color c = new Color(0, 128, 224);
        for (int i = 0; i < this.gridHeight; ++i) {
            for (int j = 0; j < this.gridWidth; ++j) {
                this.offscreenG.setColor(c);
                this.offscreenG.fill3DRect(j * 15, i * 15, 15, 15, true);
            }
        }
        this.offscreenG.setColor(Color.yellow);
        this.offscreenG.setFont(laFont);
        this.offscreenG.drawString("Partie", (this.getSize().width - fm.stringWidth("Partie")) / 2, 32);
        this.offscreenG.drawString("termin\u00e9e", (this.getSize().width - fm.stringWidth("termin\u00e9e")) / 2, 64);
        laFont = new Font("Arial", 1, 14);
        fm = this.getFontMetrics(laFont);
        this.offscreenG.setColor(Color.white);
        this.offscreenG.setFont(laFont);
        String s = "cliquez pour rejouer";
        this.offscreenG.drawString(s, (this.getSize().width - fm.stringWidth(s)) / 2, 220);
        this.gameOverPainted = true;
    }

    public void paint(Graphics g) {
        int j;
        int i;
        if (this.offscreenImg == null) {
            this.offscreenImg = this.createImage(this.gridWidth * 15, this.gridHeight * 15);
            this.backImg = this.createImage(this.gridWidth * 15, this.gridHeight * 15);
            this.offscreenG = this.backImg.getGraphics();
            this.offscreenG.setColor(this.backColor);
            for (i = 0; i < this.gridHeight; ++i) {
                for (j = 0; j < this.gridWidth; ++j) {
                    this.offscreenG.fill3DRect(j * 15, i * 15, 15, 15, true);
                }
            }
            this.offscreenG = this.offscreenImg.getGraphics();
            this.offscreenG.drawImage(this.backImg, 0, 0, this);
        }
        if (!this.gameFinished) {
            if (this.paintAll) {
                this.offscreenG.drawImage(this.backImg, 0, 0, this);
                for (i = 0; i < this.gridHeight; ++i) {
                    for (j = 0; j < this.gridWidth; ++j) {
                        if (this.grids[i][j] == null) continue;
                        this.offscreenG.setColor(this.grids[i][j]);
                        this.offscreenG.fill3DRect(j * 15, i * 15, 15, 15, true);
                    }
                }
                this.paintAll = false;
                if (this.paintPiece) {
                    this.paintPiece(false);
                }
            } else {
                this.paintPiece(true);
            }
        } else if (!this.gameOverPainted) {
            this.paintGameOver();
            this.paintAll = false;
        }
        g.drawImage(this.offscreenImg, 0, 0, this);
        this.ds.repaint();
    }

    public synchronized void goDown() {
        int cpt = 1;
        ++this.posY;
        while (true) {
            if (this.posY < 0 || this.posY + this.currentPiece.getHeight() > this.gridHeight) {
                --this.posY;
                this.currentPiece.goDown(cpt - 1);
                return;
            }
            int mask = 32768;
            for (int i = 0; i < this.currentPiece.getHeight(); ++i) {
                int j = 0;
                while (j < this.currentPiece.getWidth()) {
                    if ((this.currentPiece.getVal() & mask) != 0 && this.grids[this.posY + i][this.posX + j] != null) {
                        --this.posY;
                        this.currentPiece.goDown(cpt - 1);
                        return;
                    }
                    ++j;
                    mask >>= 1;
                }
                mask >>= 4 - this.currentPiece.getWidth();
            }
            ++cpt;
            ++this.posY;
        }
    }

    public synchronized void goUp() {
        int cpt = 1;
        --this.posY;
        while (true) {
            if (this.posY < 0 || this.posY + this.currentPiece.getHeight() > this.gridHeight) {
                ++this.posY;
                this.currentPiece.goUp(cpt - 1);
                return;
            }
            int mask = 32768;
            for (int i = 0; i < this.currentPiece.getHeight(); ++i) {
                int j = 0;
                while (j < this.currentPiece.getWidth()) {
                    if ((this.currentPiece.getVal() & mask) != 0 && this.grids[this.posY + i][this.posX + j] != null) {
                        ++this.posY;
                        this.currentPiece.goUp(cpt - 1);
                        return;
                    }
                    ++j;
                    mask >>= 1;
                }
                mask >>= 4 - this.currentPiece.getWidth();
            }
            ++cpt;
            --this.posY;
        }
    }

    public void run() {
        while (!this.finished) {
            if (!this.gameOverPainted) {
                this.repaint();
                if (this.gameRunning && !this.gameFinished) {
                    --this.bonus;
                    if (this.direction == 1) {
                        if (this.canDisplayAt(this.posX, this.posY + 1)) {
                            ++this.posY;
                            this.currentPiece.goDown();
                        } else {
                            this.pieceStop();
                            this.selectPiece();
                            if (!this.canDisplayAt(this.posX, this.posY)) {
                                this.gameFinished = true;
                            }
                        }
                    } else if (this.canDisplayAt(this.posX, this.posY - 1)) {
                        --this.posY;
                        this.currentPiece.goUp();
                    } else {
                        this.pieceStop();
                        this.selectPiece();
                        if (!this.canDisplayAt(this.posX, this.posY)) {
                            this.gameFinished = true;
                        }
                    }
                }
            }
            try {
                Thread.sleep(300 - (this.level - 1) * 20);
            }
            catch (InterruptedException e) {
                this.stop();
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 112 || key == 80) {
            this.gameRunning = !this.gameRunning;
        } else if (this.gameRunning) {
            switch (key) {
                case 37: {
                    if (!this.canDisplayAt(this.posX - 1, this.posY)) break;
                    --this.posX;
                    this.currentPiece.goLeft();
                    break;
                }
                case 39: {
                    if (!this.canDisplayAt(this.posX + 1, this.posY)) break;
                    ++this.posX;
                    this.currentPiece.goRight();
                    break;
                }
                case 38: {
                    if (!this.canDisplayAt(this.posX, this.posY, this.currentPiece.getNextPiece())) break;
                    this.currentPiece.rotate();
                    break;
                }
                case 40: {
                    if (this.bonus > 0) {
                        this.cptPoints += this.bonus;
                    }
                    if (this.direction == 1) {
                        this.goDown();
                        break;
                    }
                    this.goUp();
                    break;
                }
                case 73: 
                case 105: {
                    this.reverseGame();
                    this.direction = -this.direction;
                    this.resetPiece();
                    this.bonus = 0;
                    this.paintAll = true;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.repaint();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.gameRunning = false;
    }

    public void focusGained(FocusEvent e) {
    }

    public boolean mouseDown() {
        this.gameRunning = true;
        if (this.gameFinished) {
            this.restartGame();
            this.repaint();
        }
        return true;
    }

    private void initListeners() {
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                Grille.this.mouseDown();
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }
}

