/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.importers;

import fr.gouv.finances.cp.utils.NullWriter;
import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.StringOutputStream;
import fr.gouv.finances.cp.utils.xml.NamespaceContextImpl;
import fr.gouv.finances.cp.xemelios.common.FileInfo;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.EtatModel;
import fr.gouv.finances.cp.xemelios.common.config.SpecialKeyModel;
import fr.gouv.finances.cp.xemelios.utils.XmlUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSplitter
extends DefaultHandler {
    protected static final int MAX_TEMP_FILE_PER_DIRECTORY = 30000;
    private static Logger logger = Logger.getLogger(XmlSplitter.class);
    private static final Pair NULL_VALUE = new Pair("null-value", "null-value");
    private byte[] LINE_SEP = System.getProperty("line.separator").getBytes();
    int elementDepth = 0;
    private DocumentModel dm = null;
    private OutputStream header = null;
    private OutputStream data = null;
    private OutputStream ref = null;
    private OutputStream footer = null;
    private OutputStream out = null;
    private Vector<File> fDatas = new Vector();
    private int elementCount = 0;
    private int startIgnoredLevel = 0;
    private File tmpDir;
    private Stack<String> tagStack = new Stack();
    private Stack<StringBuilder> charactersStack = new Stack();
    private boolean inRef = false;
    private StringOutputStream etatHeader = null;
    private EtatModel currentEtat;
    private String startIgnored;
    private FileInfo fileInfo;
    private Locator locator;
    private Pair budget = null;
    private Pair collectivite = null;
    private Pair specialKey1 = null;
    private Pair specialKey2 = null;
    private Pair specialKey3 = null;
    private String fileEncoding = null;
    private NamespaceContextImpl nsCtx;
    private int tmpFileCount = 3;

    public XmlSplitter(OutputStream header, OutputStream ref, OutputStream footer, File tmpDir, DocumentModel dm, String fileEncoding) {
        this.header = header;
        this.data = null;
        this.ref = ref;
        this.footer = footer;
        this.tmpDir = tmpDir;
        this.dm = dm;
        this.fileInfo = new FileInfo();
        this.fileEncoding = fileEncoding;
        this.nsCtx = new NamespaceContextImpl();
        if (footer == null) {
            logger.error((Object)"XmlSplitter is created with a null footer");
        }
        this.tmpFileCount = tmpDir.listFiles().length;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public Vector<File> getDataFiles() {
        return this.fDatas;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            String s = new String(ch, start, length).trim();
            if (s.length() > 0) {
                if (this.out != null) {
                    String s2 = s.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                    this.out.write(s2.getBytes(this.fileEncoding));
                }
                this.charactersStack.peek().append(new String(ch, start, length));
            }
        }
        catch (IOException ioEx) {
            throw new SAXException(ioEx);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.out = null;
        try {
            this.header.flush();
            this.header.close();
            this.ref.flush();
            this.ref.close();
            this.footer.flush();
            this.footer.close();
        }
        catch (IOException ioEx) {
            throw new SAXException(ioEx);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (this.tagStack.size() == 1) {
                this.out = this.footer;
            }
            String tagName = XmlUtils.getShortTagName(uri, localName, qName);
            this.closeTag(uri, localName, qName);
            switch (this.tagStack.size()) {
                case 1: {
                    if (tagName.equals(this.dm.getBalise())) break;
                    throw new SAXException("Fermeture d'un element root inattendu");
                }
                case 2: {
                    if (this.inRef || this.startIgnoredLevel == 2 && this.startIgnored.equals(tagName)) {
                        if (this.out != this.ref) {
                            this.out.flush();
                            this.out.close();
                        }
                        this.out = this.footer;
                        if (this.footer == null) {
                            logger.error((Object)"footer is null !");
                        }
                        this.startIgnoredLevel = 0;
                        if (!this.inRef) break;
                        this.inRef = false;
                        break;
                    }
                    if (this.currentEtat != null && this.currentEtat.getBalise().equals(tagName)) {
                        if (this.data != null) {
                            this.closeData(uri, localName, qName);
                        }
                        this.out = this.footer;
                        if (this.footer == null) {
                            logger.error((Object)"footer is null !");
                        }
                        this.currentEtat = null;
                        break;
                    }
                    if (!this.dm.getEntetes().contains(tagName)) break;
                    this.out.flush();
                    this.out = this.header;
                    break;
                }
                case 3: {
                    if (this.currentEtat != null && this.currentEtat.getEntetes().contains(tagName)) {
                        this.out.flush();
                        this.out = new NullWriter();
                        break;
                    }
                    if (this.currentEtat != null && this.currentEtat.getImportableElement().getBalise().equals(tagName)) {
                        ++this.elementCount;
                        if (this.elementCount == 1) {
                            this.closeData(uri, localName, qName);
                        }
                        this.out = new NullWriter();
                        break;
                    }
                    if (this.currentEtat == null || this.startIgnoredLevel != 3 || !this.startIgnored.equals(tagName)) break;
                    this.out.close();
                    this.out = new NullWriter();
                }
            }
            String path = XmlUtils.getPath(this.tagStack);
            String innerData = this.charactersStack.pop().toString();
            this.checkBudgetCollectivite(path, innerData);
            this.checkSpecialKey(path, innerData);
            this.tagStack.pop();
        }
        catch (IOException ioEx) {
            throw new SAXException(ioEx);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            String tagName = XmlUtils.getShortTagName(uri, localName, qName);
            switch (this.tagStack.size()) {
                case 0: {
                    if (!tagName.equals(this.dm.getBalise())) {
                        throw new SAXException("Le fichier import\u00e9 n'est pas un " + this.dm.getTitre());
                    }
                    this.out = this.header;
                    break;
                }
                case 1: {
                    if (this.dm.getEntetes().contains(tagName)) {
                        this.out = this.header;
                        break;
                    }
                    if (this.dm.getReferentiel().equals(tagName)) {
                        this.out = this.ref;
                        this.inRef = true;
                        break;
                    }
                    EtatModel em = this.dm.getEtatByTagName(tagName);
                    if (em != null) {
                        this.currentEtat = em;
                        this.etatHeader = new StringOutputStream();
                        this.out = this.etatHeader;
                        break;
                    }
                    this.out = new NullWriter();
                    this.startIgnored = tagName;
                    this.startIgnoredLevel = this.tagStack.size() + 1;
                    break;
                }
                case 2: {
                    if (this.currentEtat != null && this.currentEtat.getEntetes().contains(tagName)) {
                        this.out = this.etatHeader;
                        break;
                    }
                    if (this.currentEtat != null && this.currentEtat.getImportableElement().getBalise().equals(tagName)) {
                        if (this.data == null) {
                            this.startData();
                        }
                        this.out = this.data;
                        this.fileInfo.incElement(this.currentEtat.getTitre());
                        break;
                    }
                    if (this.currentEtat == null) break;
                    this.out = new NullWriter();
                    this.startIgnored = tagName;
                    this.startIgnoredLevel = this.tagStack.size() + 1;
                }
            }
            this.tagStack.push(tagName);
            this.charactersStack.push(new StringBuilder());
            String path = XmlUtils.getPath(this.tagStack);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                String fullPath = path + "/@" + attrName;
                this.checkBudgetCollectivite(fullPath, value);
                this.checkSpecialKey(fullPath, value);
            }
            this.writeTag(uri, localName, qName, attributes);
        }
        catch (IOException ioEx) {
            throw new SAXException(ioEx);
        }
    }

    private void closeData(String uri, String localName, String qName) throws IOException {
        this.data.write("</".getBytes());
        String prefix = null;
        prefix = uri != null && uri.length() > 0 ? ((prefix = this.nsCtx.getPrefix(uri)) != null && prefix.length() > 0 ? prefix + ":" : "") : "";
        this.data.write(prefix.getBytes(this.fileEncoding));
        this.data.write(this.currentEtat.getBalise().getBytes(this.fileEncoding));
        this.data.write(">".getBytes());
        this.data.flush();
        this.data.close();
        this.data = null;
    }

    private OutputStream startData() throws IOException {
        if (this.tmpFileCount >= 30000) {
            this.tmpDir = new File(this.tmpDir, "tmp1");
            if (!this.tmpDir.exists()) {
                this.tmpDir.mkdirs();
            }
            this.tmpFileCount = 0;
        }
        File f = File.createTempFile("data-", "", this.tmpDir);
        ++this.tmpFileCount;
        this.data = new FileOutputStream(f);
        this.elementCount = 0;
        this.fDatas.add(f);
        try {
            this.data.write(this.etatHeader.getBytes(this.fileEncoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.data;
    }

    private void writeTag(String uri, String localName, String qName, Attributes attributes) throws IOException {
        this.out.write(this.LINE_SEP);
        this.out.write(this.getXmlText(uri, localName, qName, attributes));
    }

    private void closeTag(String uri, String localName, String qName) throws IOException {
        if (this.out == null) {
            logger.error((Object)("trying to close tag " + qName + " with a null output"));
        }
        this.out.write(this.getCloseTag(uri, localName, qName));
    }

    private byte[] getCloseTag(String uri, String localName, String qName) throws UnsupportedEncodingException {
        StringBuffer buff = new StringBuffer();
        buff.append("</").append(qName).append(">");
        return buff.toString().getBytes(this.fileEncoding);
    }

    private byte[] getXmlText(String uri, String localName, String qName, Attributes attributes) throws UnsupportedEncodingException {
        StringBuffer ret = new StringBuffer();
        ret.append("<").append(qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attName = attributes.getLocalName(i);
            String attVal = attributes.getValue(i);
            String nsUri = attributes.getURI(i);
            String prefix = null;
            prefix = nsUri != null && nsUri.length() > 0 ? ((prefix = this.nsCtx.getPrefix(nsUri)) != null && prefix.length() > 0 ? prefix + ":" : "") : "";
            ret.append(" ").append(prefix).append(attName).append("=\"").append(XmlSplitter.escapeXml(attVal)).append("\"");
        }
        for (NamespaceContextImpl.NsMapping map : this.nsCtx.getMappings()) {
            if (map.isWritten()) continue;
            ret.append(" xmlns");
            if (map.getPrefix().length() > 0) {
                ret.append(":").append(map.getPrefix());
            }
            ret.append("=\"").append(map.getUri()).append("\"");
            map.setWritten();
        }
        ret.append(">");
        return ret.toString().getBytes(this.fileEncoding);
    }

    protected String getEndPath(int level) {
        String ret = "";
        if (level > 0) {
            Stack<String> tmp = new Stack<String>();
            for (int i = 0; i < level; ++i) {
                String tag = this.tagStack.pop();
                tmp.push(tag);
                ret = tag + "/" + ret;
            }
            ret = ret.substring(0, ret.length() - 1);
            while (!tmp.isEmpty()) {
                this.tagStack.push((String)tmp.pop());
            }
        }
        return ret;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    private void checkBudgetCollectivite(String path, String value) {
        if (this.dm.getBudgetPath() != null) {
            if (this.dm.getBudgetPath().getCodePath() != null && path.equals(this.dm.getBudgetPath().getCodePath().getPath())) {
                if (this.budget == null) {
                    this.budget = new Pair();
                }
                this.budget.key = value;
            }
            if (this.dm.getBudgetPath().getLibellePath() != null && path.equals(this.dm.getBudgetPath().getLibellePath().getPath())) {
                if (this.budget == null) {
                    this.budget = new Pair();
                }
                this.budget.libelle = value;
            }
        }
        if (this.dm.getCollectivitePath() != null) {
            if (this.dm.getCollectivitePath().getCodePath() != null && path.equals(this.dm.getCollectivitePath().getCodePath().getPath())) {
                if (this.collectivite == null) {
                    this.collectivite = new Pair();
                }
                this.collectivite.key = value;
            }
            if (this.dm.getCollectivitePath().getLibellePath() != null && path.equals(this.dm.getCollectivitePath().getLibellePath().getPath())) {
                if (this.collectivite == null) {
                    this.collectivite = new Pair();
                }
                this.collectivite.libelle = value;
            }
        }
    }

    private void checkSpecialKey(String path, String value) {
        String lib;
        SpecialKeyModel o;
        int i;
        SpecialKeyModel skm;
        Vector<SpecialKeyModel> spDefs = this.dm.getSpecialKeys();
        if (this.specialKey1 == null && spDefs != null && spDefs.size() > 0) {
            skm = null;
            for (i = 0; i < spDefs.size(); ++i) {
                o = spDefs.get(i);
                if (o.getPos() != 1) continue;
                skm = o;
                break;
            }
            if (skm == null) {
                this.specialKey1 = NULL_VALUE;
            }
            if (skm != null && path.equals(skm.getPath())) {
                String key = skm.transformValue(value);
                lib = skm.getDescriptionOfValue(key);
                if (lib == null) {
                    lib = key;
                }
                this.specialKey1 = new Pair(key, lib);
            }
        }
        if (this.specialKey2 == null && spDefs != null && spDefs.size() > 0) {
            skm = null;
            for (i = 0; i < spDefs.size(); ++i) {
                o = spDefs.get(i);
                if (o.getPos() != 2) continue;
                skm = o;
                break;
            }
            if (skm == null) {
                this.specialKey2 = NULL_VALUE;
            }
            if (skm != null && path.equals(skm.getPath())) {
                String key = skm.transformValue(value);
                lib = skm.getDescriptionOfValue(key);
                if (lib == null) {
                    lib = key;
                }
                this.specialKey2 = new Pair(key, lib);
            }
        }
        if (this.specialKey3 == null && spDefs != null && spDefs.size() > 0) {
            skm = null;
            for (int i2 = 0; i2 < spDefs.size(); ++i2) {
                o = spDefs.get(i2);
                if (o.getPos() != 3) continue;
                skm = o;
                break;
            }
            if (skm == null) {
                this.specialKey3 = NULL_VALUE;
            }
            if (skm != null && path.equals(skm.getPath())) {
                String key = skm.transformValue(value);
                lib = skm.getDescriptionOfValue(key);
                if (lib == null) {
                    lib = key;
                }
                this.specialKey3 = new Pair(key, lib);
            }
        }
    }

    public Pair getBudget() {
        return this.budget;
    }

    public Pair getCollectivite() {
        return this.collectivite;
    }

    public Pair getSpecialKey1() {
        return this.specialKey1 == NULL_VALUE ? null : this.specialKey1;
    }

    public Pair getSpecialKey2() {
        return this.specialKey2 == NULL_VALUE ? null : this.specialKey2;
    }

    public Pair getSpecialKey3() {
        return this.specialKey3 == NULL_VALUE ? null : this.specialKey3;
    }

    public static String escapeXml(String s) {
        return s.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
        this.nsCtx.removeMapping(prefix);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.nsCtx.addMapping(prefix, uri);
    }
}

