/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.export;

import fr.gouv.finances.cp.utils.StringUtilities;
import fr.gouv.finances.cp.xemelios.export.ExportElementModel;
import fr.gouv.finances.cp.xemelios.export.ExportUndertaker;
import fr.gouv.finances.cp.xemelios.export.Exporter;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SylkExporter
extends ExportUndertaker {
    private static DecimalFormat df = new DecimalFormat("#0.00");
    private static SimpleDateFormat sdf;
    public static final int MAX_ROWS_PER_SHEET = 65000;
    private static final Logger logger;
    private Hashtable<String, Vector<SylkTable>> sheets;
    private Exporter exporter;
    private String filenamePrefix;

    public SylkExporter(Exporter exporter) {
        super(exporter);
        this.exporter = exporter;
    }

    void buildSheet(ExportElementModel eem) throws Exception {
        Vector<SylkTable> tables = this.sheets.get(eem.getId());
        if (tables == null) {
            tables = new Vector();
            this.sheets.put(eem.getId(), tables);
        }
        String filename = this.filenamePrefix + "_" + eem.getLibelle();
        SylkTable sheet = new SylkTable(filename);
        tables.add(sheet);
        this.addRefInMainSheet(filename, false);
        for (ExportElementModel fils : eem.getEnfants()) {
            this.buildSheet(fils);
        }
        this.exporter.firstSheetId = eem.getId();
    }

    protected void addRefInMainSheet(String filename, boolean addPrefix) {
        String ref = filename + ".slk";
    }

    void flushLine(String el) {
    }

    protected void splitSheet(String sheetId) throws IOException {
        Vector<SylkTable> v = this.sheets.get(sheetId);
        SylkTable wsRef = v.get(0);
        SylkTable otherRef = this.getLastSheet(sheetId);
        Cell[] titleLine = otherRef.getTitleLine();
        Cell[] headerLine = otherRef.getHeaderLine();
        otherRef.flush();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(2);
        nf.setMaximumIntegerDigits(3);
        String sb = nf.format(v.size());
        String fname = wsRef.getFileName() + "_" + sb;
        SylkTable newSheet = new SylkTable(fname, titleLine, headerLine);
        this.addRefInMainSheet(fname, false);
        v.add(newSheet);
    }

    void writeCell(String sheetId, Object o, int line, int col, boolean bypassLineRenum) throws Exception {
        int newline = 0;
        if (bypassLineRenum) {
            newline = line;
        } else {
            int _ligne = this.exporter.getLastLine(sheetId);
            if (_ligne >= 65000 * this.sheets.get(sheetId).size()) {
                this.splitSheet(sheetId);
            }
            newline = _ligne;
            newline = _ligne % 65000 + 2;
        }
        SylkTable sheet = this.getLastSheet(sheetId);
        if (line == 0) {
            sheet.addTitle(col, newline, o);
        } else if (line == 1) {
            sheet.addHeader(col, newline, o);
        } else {
            sheet.addValue(col, newline, o);
        }
    }

    private SylkTable getLastSheet(String sheetId) {
        Vector<SylkTable> v = this.sheets.get(sheetId);
        if (v != null) {
            return v.lastElement();
        }
        return null;
    }

    void mergeCells(String sheetId, int col1, int row1, int col2, int row2) {
        logger.debug((Object)("mergeCells(" + sheetId + "," + col1 + "," + row1 + "," + col2 + "," + row2 + ")"));
    }

    int getLastLineLastSheet(String sheetId) {
        SylkTable ws = this.getLastSheet(sheetId);
        int ret = ws.getRows() < 2 ? 2 : ws.getRows();
        logger.debug((Object)("getLastLineLastSheet(" + sheetId + ") -> " + ret));
        return ret;
    }

    boolean sheetExists(String sheetId) {
        logger.debug((Object)("sheetExists(" + sheetId + ")"));
        boolean bRet = this.sheets.containsKey(sheetId);
        return bRet;
    }

    void close() {
        logger.debug((Object)"close()");
    }

    void finish() throws Exception {
        logger.debug((Object)"finish()");
        for (String key : this.sheets.keySet()) {
            Vector<SylkTable> v = this.sheets.get(key);
            for (int i = 0; i < v.size(); ++i) {
                v.get(i).flush();
            }
            v.clear();
        }
        this.sheets.clear();
    }

    void initialize() throws Exception {
        logger.debug((Object)"initialize()");
        String dirRessources = MainWindow.instance.getEnvProperties().getProperty("xemelios.resources.location");
        this.recopieFichier(dirRessources + "/modeleExportXemelios-97.xls", this.exporter.fDest.getPath());
        this.sheets = new Hashtable();
        this.filenamePrefix = StringUtilities.removeFileNameSuffix(this.exporter.fDest.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recopieFichier(String src, String dst) {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            in = new FileInputStream(src).getChannel();
            out = new FileOutputStream(dst).getChannel();
            in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        sdf = new SimpleDateFormat(System.getProperty("xemelios.date.format", "yyyy-MM-dd"));
        logger = Logger.getLogger(SylkExporter.class);
    }

    private class Cell {
        public static final int CELL_VALUE = 0;
        public static final int CELL_FORMULA = 1;
        public static final int CELL_FMT_STD = 0;
        public static final int CELL_FMT_TITLE = 1;
        public static final int CELL_FMT_HEADER = 2;
        public static final int ALIGN_DEFAULT = 0;
        public static final int ALIGN_RIGHT = 1;
        public static final int ALIGN_CENTER = 2;
        public static final int ALIGN_LEFT = 3;
        private int datatype;
        private int format;
        private int style;
        private Object value;

        public Cell(Object o) {
            this.value = o;
            this.datatype = 0;
            this.format = o instanceof Number ? 1 : (this.value instanceof Date ? 2 : 3);
        }

        public void setStyle(int style) {
            this.style = style;
        }

        public String getSylkRepresentation(int i, int j) {
            StringBuilder sb = new StringBuilder();
            if (this.value != null) {
                if (this.datatype == 0) {
                    sb.append("C;Y").append(i + 1).append(";X").append(j + 1).append(";K").append(this.getFormattedValue()).append("\n");
                } else {
                    sb.append("C;Y").append(i + 1).append(";X").append(j + 1).append(";E").append(this.getFormattedValue()).append("\n");
                }
                sb.append("F;P0;Y").append(i + 1).append(";X").append(j + 1);
                if (this.format == 1) {
                    sb.append(";FG0R");
                } else if (this.format == 2) {
                    sb.append(";FG0C");
                } else if (this.format == 3) {
                    sb.append(";FG0L");
                }
                if (this.style == 1) {
                    sb.append(";SLM0");
                } else if (this.style == 2) {
                    sb.append(";SDLM10");
                } else {
                    sb.append(";SLM0");
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        public String getFormattedValue() {
            String ret = "";
            ret = this.value instanceof Integer || this.value instanceof Long || this.value instanceof Short ? this.value.toString() : (this.value instanceof Number ? df.format(this.value) : (this.value instanceof Date ? "\"" + sdf.format((Date)this.value) + "\"" : "\"" + ((String)this.value).replaceAll(";", ";;") + "\""));
            return ret;
        }
    }

    private class SylkTable {
        public static final transient String SYLK_HEADER = "ID;PWXL;N;E\nP;PGeneral\nP;P0\nP;P0.00\nP;P#,##0\nP;P#,##0.00\nP;P#,##0\\ _\u001b(0;;\\-#,##0\\ _\u001b(0\nP;P#,##0\\ _\u001b(0;;[Red]\\-#,##0\\ _\u001b(0\nP;P#,##0.00\\ _\u001b(0;;\\-#,##0.00\\ _\u001b(0\nP;P#,##0.00\\ _\u001b(0;;[Red]\\-#,##0.00\\ _\u001b(0\nP;P#,##0\\ \"$\";;\\-#,##0\\ \"$\"\nP;P#,##0\\ \"$\";;[Red]\\-#,##0\\ \"$\"\nP;P#,##0.00\\ \"$\";;\\-#,##0.00\\ \"$\"\nP;P#,##0.00\\ \"$\";;[Red]\\-#,##0.00\\ \"$\"\nP;P0%\nP;P0.00%\nP;P0.00E+00\nP;P##0.0E+0\nP;P#\" \"?/?\nP;P#\" \"??/??\nP;Pdd/mm/yyyy\nP;Pdd\\-mmm\\-yy\nP;Pdd\\-mmm\nP;Pmmm\\-yy\nP;Ph:mm\\ AM/PM\nP;Ph:mm:ss\\ AM/PM\nP;Phh:mm\nP;Phh:mm:ss\nP;Pdd/mm/yyyy\\ hh:mm\nP;Pmm:ss\nP;Pmm:ss.0\nP;P@\nP;P[h]:mm:ss\nP;P_-* #,##0\\ \"$\"_-;;\\-* #,##0\\ \"$\"_-;;_-* \"-\"\\ \"$\"_-;;_-@_-\nP;P_-* #,##0\\ _\u001b(0_-;;\\-* #,##0\\ _\u001b(0_-;;_-* \"-\"\\ _\u001b(0_-;;_-@_-\nP;P_-* #,##0.00\\ \"$\"_-;;\\-* #,##0.00\\ \"$\"_-;;_-* \"-\"??\\ \"$\"_-;;_-@_-\nP;P_-* #,##0.00\\ _\u001b(0_-;;\\-* #,##0.00\\ _\u001b(0_-;;_-* \"-\"??\\ _\u001b(0_-;;_-@_-\nP;P\"Vrai\";;\"Vrai\";;\"Faux\"\nP;P\"Actif\";;\"Actif\";;\"Inactif\"\nP;FArial;M200\nP;FArial;M200\nP;FArial;M200\nP;FArial;M200\nP;EArial;M200\nP;EArial;M160\nP;EArial;M200;SU;L13\nP;EArial;M200;SU;L21\nP;EArial;M280;SB\nP;EArial;M240;SB\nF;P0;DG0G10;G;M255\n";
        private String filename;
        private ArrayList<Cell[]> rowArray;
        private boolean written = false;

        public SylkTable(String filename) {
            this.filename = filename;
            this.rowArray = new ArrayList();
        }

        public SylkTable(String filename, Cell[] titleLine, Cell[] headerLine) {
            this(filename);
            this.rowArray.add(titleLine);
            this.rowArray.add(headerLine);
        }

        public void addTitle(int col, int row, Object data) {
            this.ensureCapacity(row);
            Cell[] line = this.rowArray.get(row);
            line[col] = new Cell(data);
            line[col].setStyle(1);
        }

        public void addHeader(int col, int row, Object data) {
            this.ensureCapacity(row);
            Cell[] line = this.rowArray.get(row);
            line[col] = new Cell(data);
            line[col].setStyle(2);
        }

        public void addValue(int col, int row, Object data) {
            this.ensureCapacity(row);
            Cell[] line = this.rowArray.get(row);
            line[col] = new Cell(data);
        }

        public String getFileName() {
            return this.filename;
        }

        public int getRows() {
            return this.rowArray.size();
        }

        private void ensureCapacity(int row) {
            while (this.rowArray.size() < row + 1) {
                this.rowArray.add(new Cell[256]);
            }
        }

        private void writeTable(Writer w) throws IOException {
            if (this.written) {
                return;
            }
            w.write(SYLK_HEADER);
            for (int y = 0; y < this.rowArray.size(); ++y) {
                Cell[] line = this.rowArray.get(y);
                for (int x = 0; x < line.length; ++x) {
                    if (line[x] == null) continue;
                    w.write(line[x].getSylkRepresentation(y, x));
                }
            }
            w.write("E\n");
            this.written = true;
        }

        public void flush() throws IOException {
            if (this.rowArray.isEmpty()) {
                return;
            }
            logger.debug((Object)("writting " + this.getFileName() + ".slk"));
            File f = new File(this.getFileName() + ".slk");
            FileWriter fw = new FileWriter(f);
            this.writeTable(fw);
            fw.flush();
            fw.close();
            this.clear();
        }

        private void clear() {
            for (Cell[] line : this.rowArray) {
                for (int i = 0; i < line.length; ++i) {
                    line[i] = null;
                }
            }
            this.rowArray.clear();
        }

        public Cell[] getTitleLine() {
            return this.rowArray.get(0);
        }

        public Cell[] getHeaderLine() {
            return this.rowArray.get(1);
        }
    }
}

