/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.export;

import fr.gouv.finances.cp.utils.Amount;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.export.ExportElementModel;
import fr.gouv.finances.cp.xemelios.export.ExportUndertaker;
import fr.gouv.finances.cp.xemelios.export.Exporter;
import java.io.File;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import jxl.Range;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.format.CellFormat;
import jxl.write.DateFormat;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.log4j.Logger;

public class JxlExporter
extends ExportUndertaker {
    private static final Logger logger = Logger.getLogger(JxlExporter.class);
    private static final int MAX_ROWS_PER_SHEET = 65000;
    WritableFont fontEntete1 = new WritableFont(WritableFont.TIMES, 16, WritableFont.BOLD, false);
    WritableFont fontEntete2 = new WritableFont(WritableFont.TIMES, 12, WritableFont.BOLD, false);
    WritableFont fontAutre = new WritableFont(WritableFont.TIMES, 10);
    private Hashtable<String, Vector<WritableSheet>> sheets = new Hashtable();
    private Exporter caller;
    private WritableWorkbook workbook = null;

    public JxlExporter(Exporter caller) {
        this.caller = caller;
    }

    void initialize() throws Exception {
        WorkbookSettings ws = new WorkbookSettings();
        ws.setUseTemporaryFileDuringWrite(true);
        ws.setTemporaryFileDuringWriteDirectory(new File("."));
        ws.setCellValidationDisabled(true);
        ws.setGCDisabled(false);
        this.workbook = Workbook.createWorkbook((File)this.caller.fDest, (WorkbookSettings)ws);
    }

    void buildSheet(ExportElementModel eem) throws Exception {
        Vector<Object> v = this.sheets.get(eem.getId());
        if (v == null) {
            v = new Vector();
        }
        this.sheets.put(eem.getId(), v);
        v.add(this.workbook.createSheet(eem.getLibelle(), this.workbook.getNumberOfSheets()));
        for (ExportElementModel e : eem.getEnfants()) {
            this.buildSheet(e);
        }
        this.caller.firstSheetId = eem.getId();
    }

    void finish() throws Exception {
        this.enteteNewSheets();
    }

    void close() {
        if (this.workbook != null) {
            try {
                this.workbook.write();
                this.workbook.close();
                this.workbook = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    boolean sheetExists(String sheetId) {
        Vector<WritableSheet> v = this.sheets.get(sheetId);
        return v != null;
    }

    int getLastLineLastSheet(String sheetId) {
        WritableSheet ws = this.getLastSheet(sheetId);
        return ws.getRows() < 2 ? 2 : ws.getRows();
    }

    void writeCell(String sheetId, Object o, int line, int col, boolean bypassLineRenum) throws Exception {
        int newline = 0;
        if (bypassLineRenum) {
            newline = line;
        } else {
            int _ligne = this.caller.getLastLine(sheetId);
            if (_ligne >= 65000 * this.sheets.get(sheetId).size()) {
                this.splitSheet(sheetId);
            }
            newline = _ligne;
            newline = _ligne % 65000 + 2;
        }
        WritableSheet sheet = this.getLastSheet(sheetId);
        if (o instanceof Integer) {
            WritableCellFormat integerFormat = new WritableCellFormat(newline == 0 ? this.fontEntete1 : (newline == 1 ? this.fontEntete2 : this.fontAutre), NumberFormats.INTEGER);
            Number number = new Number(col, newline, (double)((Integer)o).intValue(), (CellFormat)integerFormat);
            sheet.addCell((WritableCell)number);
        } else if (o instanceof Float) {
            WritableCellFormat floatFormat = new WritableCellFormat(newline == 0 ? this.fontEntete1 : (newline == 1 ? this.fontEntete2 : this.fontAutre), NumberFormats.FLOAT);
            Number number = new Number(col, newline, (double)((Float)o).floatValue(), (CellFormat)floatFormat);
            sheet.addCell((WritableCell)number);
        } else if (o instanceof Date) {
            DateFormat myDateFormat = new DateFormat(System.getProperty("xemelios.date.format"));
            WritableCellFormat dateFormat = new WritableCellFormat(newline == 0 ? this.fontEntete1 : (newline == 1 ? this.fontEntete2 : this.fontAutre), (DisplayFormat)myDateFormat);
            DateTime date = new DateTime(col, newline, (Date)o, (CellFormat)dateFormat);
            sheet.addCell((WritableCell)date);
        } else if (o instanceof Amount) {
            WritableCellFormat floatFormat = new WritableCellFormat(newline == 0 ? this.fontEntete1 : (newline == 1 ? this.fontEntete2 : this.fontAutre), NumberFormats.FLOAT);
            Number number = new Number(col, newline, ((Amount)o).doubleValue(), (CellFormat)floatFormat);
            sheet.addCell((WritableCell)number);
        } else {
            if (o != null) {
                logger.debug((Object)(sheetId + " -> " + o.getClass().getName()));
            } else {
                logger.debug((Object)"writting null data");
            }
            Label label = new Label(col, newline, (String)o, (CellFormat)new WritableCellFormat(newline == 0 ? this.fontEntete1 : (newline == 1 ? this.fontEntete2 : this.fontAutre)));
            sheet.addCell((WritableCell)label);
        }
    }

    void mergeCells(String sheetId, int col1, int row1, int col2, int row2) {
        WritableSheet _ws = this.getLastSheet(sheetId);
        try {
            _ws.mergeCells(col1, row1, col2, row2);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected int afterSheet(String id) {
        String[] names = this.workbook.getSheetNames();
        for (int i = 1; i < names.length; ++i) {
            if (!names[i].equals(id)) continue;
            return i + 1;
        }
        return 1;
    }

    protected WritableSheet getLastSheet(String sheetId) {
        Vector<WritableSheet> v = this.sheets.get(sheetId);
        if (v != null) {
            return v.get(v.size() - 1);
        }
        return null;
    }

    protected WritableSheet getRootSheetBefore(String id) {
        WritableSheet ret = null;
        ElementModel e = this.caller.getEMFromId(id);
        if (e.getSimpleParent() != null) {
            String pName = e.getSimpleParent().getElement();
            ret = this.sheets.get(pName).get(0);
        }
        return ret;
    }

    protected WritableSheet splitSheet(String id) {
        Vector<WritableSheet> v = this.sheets.get(id);
        WritableSheet wsRef = v.get(0);
        WritableSheet ws = this.workbook.createSheet(wsRef.getName() + "_" + v.size(), this.afterSheet(v.get(v.size() - 1).getName()));
        v.add(ws);
        return this.workbook.getSheet(this.workbook.getNumberOfSheets() - 1);
    }

    private void enteteNewSheets() throws RowsExceededException, WriteException {
        for (Vector<WritableSheet> v : this.sheets.values()) {
            if (v.size() <= 1) continue;
            WritableSheet wsRef = v.get(0);
            for (int iv = 1; iv < v.size(); ++iv) {
                WritableSheet ws = v.get(iv);
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < wsRef.getColumns(); ++j) {
                        WritableCell readCell = (WritableCell)wsRef.getCell(j, i);
                        WritableCell newCell = readCell.copyTo(j, i);
                        CellFormat readFormat = readCell.getCellFormat();
                        if (readFormat != null) {
                            WritableCellFormat newFormat = new WritableCellFormat(readFormat);
                            newCell.setCellFormat((CellFormat)newFormat);
                        }
                        ws.addCell(newCell);
                    }
                }
                for (int mc = 0; mc < wsRef.getMergedCells().length; ++mc) {
                    Range r = wsRef.getMergedCells()[mc];
                    if (r.getTopLeft().getColumn() < r.getBottomRight().getColumn()) {
                        if (r.getTopLeft().getRow() < r.getBottomRight().getRow()) {
                            ws.mergeCells(r.getTopLeft().getColumn(), r.getTopLeft().getRow(), r.getBottomRight().getColumn(), r.getBottomRight().getRow());
                            continue;
                        }
                        ws.mergeCells(r.getTopLeft().getColumn(), r.getBottomRight().getRow(), r.getBottomRight().getColumn(), r.getTopLeft().getRow());
                        continue;
                    }
                    if (r.getTopLeft().getRow() < r.getBottomRight().getRow()) {
                        ws.mergeCells(r.getBottomRight().getColumn(), r.getTopLeft().getRow(), r.getTopLeft().getColumn(), r.getBottomRight().getRow());
                        continue;
                    }
                    ws.mergeCells(r.getBottomRight().getColumn(), r.getBottomRight().getRow(), r.getTopLeft().getColumn(), r.getTopLeft().getRow());
                }
            }
        }
    }

    void flushLine(String el) {
    }
}

