/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl.sqlconfig;

import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.SqlConfigMapping;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TDocument;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TPersistenceConfig;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.XsString;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceConfigDeriveParser
extends DefaultHandler {
    private static Logger logger = Logger.getLogger(PersistenceConfigDeriveParser.class);
    Map<String, TPersistenceConfig> cachedPersistence = null;
    TPersistenceConfig current = null;
    String currentLayer = null;
    String currentDoc = null;
    String currentEtat = null;
    String currentElement = null;
    boolean inDocument = false;
    boolean inEtat = false;
    XsString sqlCount = new XsString(SqlConfigMapping.SQL_COUNT);
    XsString specialCond = new XsString(SqlConfigMapping.SPECIAL_COND);
    boolean inSqlCount = false;
    boolean inSpecialCond = false;
    String docIdToDerive = "";
    String fileToDerive = "";
    private String baseDirectory;

    public PersistenceConfigDeriveParser(Map<String, TPersistenceConfig> cp, String baseDir) throws SAXException, ParserConfigurationException {
        this.cachedPersistence = cp;
        this.baseDirectory = baseDir;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("persistence-derives".equals(localName)) {
            this.docIdToDerive = attributes.getValue("extends");
            if (this.cachedPersistence.get(this.docIdToDerive) != null) {
                this.current = this.cachedPersistence.get(this.docIdToDerive).clone();
                this.current.setBaseDirectory(this.baseDirectory);
            } else {
                this.current = null;
            }
            this.fileToDerive = attributes.getValue("file");
        } else if (this.current != null) {
            if ("layer".equals(localName)) {
                this.currentLayer = attributes.getValue("name");
            } else if ("document".equals(localName)) {
                String oldDocId = attributes.getValue("extends");
                String newDocId = attributes.getValue("id");
                this.current.getLayer(this.currentLayer).getDocument(oldDocId).setId(newDocId);
                TDocument tDocTmp = this.current.getLayer(this.currentLayer).getDocument(oldDocId);
                this.current.getLayer(this.currentLayer).removeDocument(oldDocId);
                this.current.getLayer(this.currentLayer).addDocument(newDocId, tDocTmp);
                this.currentDoc = attributes.getValue("id");
                this.inDocument = true;
            } else if ("etat".equals(localName)) {
                this.currentEtat = attributes.getValue("id");
                this.inEtat = true;
                this.inSpecialCond = false;
                this.inSqlCount = false;
                this.sqlCount.resetData();
                this.specialCond.resetData();
                String sTmp = attributes.getValue("import-xslt-file");
                if (sTmp != null) {
                    this.current.getLayer(this.currentLayer).getDocument(this.currentDoc).getEtat(this.currentEtat).setImportXsltFile(sTmp);
                }
            } else if ("table".equals(localName)) {
                if (this.inEtat) {
                    if ("document".equals(attributes.getValue("type"))) {
                        this.current.getLayer(this.currentLayer).getDocument(this.currentDoc).getEtat(this.currentEtat).getDocumentTable().setBaseName(attributes.getValue("base-name"));
                    } else {
                        this.current.getLayer(this.currentLayer).getDocument(this.currentDoc).getEtat(this.currentEtat).getIndexTable(attributes.getValue("extends")).setBaseName(attributes.getValue("base-name"));
                        if (attributes.getValue("main") != null && "true".equals(attributes.getValue("main"))) {
                            this.current.getLayer(this.currentLayer).getDocument(this.currentDoc).getEtat(this.currentEtat).getMaintable().setBaseName(attributes.getValue("base-name"));
                        }
                    }
                } else if (this.inDocument) {
                    if ("repository".equals(attributes.getValue("type"))) {
                        this.current.getLayer(this.currentLayer).getDocument(this.currentDoc).getRepositoryTable().setBaseName(attributes.getValue("base-name"));
                    }
                    if ("special-key".equals(attributes.getValue("type"))) {
                        this.current.getLayer(this.currentLayer).getDocument(this.currentDoc).getSpecialKeyTable().setBaseName(attributes.getValue("base-name"));
                    }
                    if ("list-bc".equals(attributes.getValue("type"))) {
                        this.current.getLayer(this.currentLayer).getDocument(this.currentDoc).getListBcTable().setBaseName(attributes.getValue("base-name"));
                    }
                }
            }
            if ("element".equals(localName)) {
                this.currentElement = attributes.getValue("id");
            } else if ("sql-count".equals(localName)) {
                this.inSqlCount = true;
            } else if ("special-cond".equals(localName)) {
                this.inSpecialCond = true;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("layer".equals(localName)) {
            this.currentLayer = "";
        }
        if ("document".equals(localName)) {
            this.inDocument = false;
            this.currentDoc = "";
        }
        if ("etat".equals(localName)) {
            this.inEtat = false;
            this.currentEtat = "";
        }
        if ("sql-count".equals(localName) && this.current != null) {
            this.current.getLayer(this.currentLayer).getDocument(this.currentDoc).getEtat(this.currentEtat).getElement(this.currentElement).setSqlCount(this.sqlCount);
        }
        if ("special-cond".equals(localName) && this.current != null) {
            this.current.getLayer(this.currentLayer).getDocument(this.currentDoc).getEtat(this.currentEtat).getElement(this.currentElement).setSpecialCond(this.specialCond);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inSqlCount) {
            this.sqlCount.addCharacterData(new String(ch, start, length));
        }
        if (this.inSpecialCond) {
            this.specialCond.addCharacterData(new String(ch, start, length));
        }
    }

    public TPersistenceConfig getCurrent() {
        return this.current;
    }

    public void setCurrent(TPersistenceConfig current) {
        this.current = current;
    }

    public String getFileToDerive() {
        return this.fileToDerive;
    }

    public void setFileToDerive(String fileToDerive) {
        this.fileToDerive = fileToDerive;
    }

    public String getDocIdToDerive() {
        return this.docIdToDerive;
    }

    public void setDocIdToDerive(String docIdToDerive) {
        this.docIdToDerive = docIdToDerive;
    }

    public Map<String, TPersistenceConfig> getCachedPersistence() {
        return this.cachedPersistence;
    }

    public void setCachedPersistence(Map<String, TPersistenceConfig> cachedPersistence) {
        this.cachedPersistence = cachedPersistence;
    }
}

