/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.editors;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.common.config.Loader;
import fr.gouv.finances.cp.xemelios.controls.ControlContentHandler;
import fr.gouv.finances.cp.xemelios.controls.ControlProgressListener;
import fr.gouv.finances.cp.xemelios.controls.MainControl;
import fr.gouv.finances.cp.xemelios.controls.editors.EditorHtmlViewer;
import fr.gouv.finances.cp.xemelios.controls.models.DocumentControlModel;
import java.io.File;
import java.math.BigDecimal;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneController
implements ControlProgressListener {
    private static final int MODE_CTRL = 1;
    private static final int MODE_DISPLAY = 2;

    public StandaloneController(int mode) throws Exception {
        DocumentsModel config = Loader.getDocumentsInfos(System.getProperty("xemelios.documents.def.dir"));
        DocumentModel pesConfig = config.getDocumentById("PES_Aller");
        DocumentModel rapportConfig = config.getDocumentById("DocumentRapport");
        Hashtable<String, File> documents = new Hashtable<String, File>();
        StringBuffer uri = new StringBuffer();
        File fichierEnrichi = new File("/home/chm/tmp/pesv2-enrichi.xml");
        File rapport = new File("/home/chm/tmp/rapport.xml");
        File fileToRead = new File("/home/chm/DGCP/magnus/PESALR1-21110429400015-011013-20070911122021704.xml");
        File rapportEnrichi = new File("/home/chm/tmp/rapport-enrichi.xml");
        if (mode == 1) {
            MainControl mc = new MainControl(pesConfig, config){

                @Override
                public ControlContentHandler getControlContentHandler(DocumentModel dm, DocumentControlModel docCtrlMod, Hashtable<String, Object> parameters, JFrame frame, String file) {
                    ControlContentHandler cch = new ControlContentHandler(dm, docCtrlMod, parameters, frame, file){

                        public Pair getCollectivite(DocumentModel dm, String fileName) {
                            return new Pair("xxxxxxxxxxx", "Collectivit\u00e9 d'analyse");
                        }

                        public Pair getBudget(DocumentModel dm, Pair collectivite, String fileName) {
                            return new Pair("00", "Budget principal");
                        }
                    };
                    return cch;
                }
            };
            mc.setControlProgressListener(this);
            File tmpEnrichi = new File(System.getProperty("java.io.tmpdir"), "tmp-pesv2-enrichi.xml");
            mc.setParameters(this.getControlParameters());
            mc.setFileToControl(fileToRead);
            mc.setFichierEnrichiLocation(tmpEnrichi.getAbsolutePath());
            mc.setRapportLocation(rapport.getAbsolutePath());
            mc.run();
            if (mc.getControlStatus() != -1) {
                StreamResult result;
                Transformer tr;
                TransformerFactory tFactory;
                if (mc.getControlStatus() > 3) {
                    tFactory = TransformerFactory.newInstance();
                    tr = tFactory.newTransformer(new StreamSource(new File(pesConfig.getBaseDirectory(), pesConfig.getGlobalImportXsltFile())));
                    result = new StreamResult(fichierEnrichi);
                    tr.transform(new StreamSource(tmpEnrichi), result);
                    result.getOutputStream().flush();
                    result.getOutputStream().close();
                    tmpEnrichi.deleteOnExit();
                    documents.put("PES_Aller", fichierEnrichi);
                }
                if (rapportConfig.getGlobalImportXsltFile() != null && rapportConfig.getGlobalImportXsltFile().length() > 0) {
                    tFactory = TransformerFactory.newInstance();
                    tr = tFactory.newTransformer(new StreamSource(new File(rapportConfig.getBaseDirectory(), rapportConfig.getGlobalImportXsltFile())));
                    result = new StreamResult(rapportEnrichi);
                    tr.transform(new StreamSource(rapport), result);
                    result.getOutputStream().flush();
                    result.getOutputStream().close();
                } else {
                    rapportEnrichi = rapport;
                }
                documents.put("DocumentRapport", rapportEnrichi);
                uri.append("xemelios:/query?collectivite=").append(mc.getCollectivite() != null ? mc.getCollectivite().key : "").append("&budget=").append(mc.getBudget() != null ? mc.getBudget().key : "");
                uri.append("&docId=DocumentRapport&etatId=DonneesRapport&path=[n:Id/@n:V='").append(mc.getIdRapport()).append("']");
            }
            tmpEnrichi.deleteOnExit();
        } else {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer tr = tFactory.newTransformer(new StreamSource(new File(pesConfig.getBaseDirectory(), pesConfig.getGlobalImportXsltFile())));
            StreamResult result = new StreamResult(fichierEnrichi);
            tr.transform(new StreamSource(fileToRead), result);
            result.getOutputStream().flush();
            result.getOutputStream().close();
            documents.put("PES_Aller", fichierEnrichi);
            uri.append("xemelios:/query?docId=PES_Aller&etatId=general_view");
        }
        EditorHtmlViewer ehv = new EditorHtmlViewer(documents, config, uri.toString());
        ehv.setLocationRelativeTo(null);
        ehv.setVisible(true);
    }

    protected Hashtable<String, Object> getControlParameters() {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        ret.put("nomencl", "M14");
        ret.put("typnomencl", "Nature");
        ret.put("votop", Boolean.FALSE);
        ret.put("suivdgp", Boolean.TRUE);
        ret.put("dureedgp", new Integer(45));
        ret.put("coltva", Boolean.TRUE);
        ret.put("servTVA", new String[0]);
        ret.put("compteTVA", new String[0]);
        ret.put("tauxTVA", new String[]{"2.1", "5.5", "19.6"});
        ret.put("seuilMax", new BigDecimal(90000));
        ret.put("seuilEmission", new BigDecimal(10));
        ret.put("codProd", new String[]{"69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "100", "101", "102", "103", "104", "105", "106", "107", "248", "300", "302", "305", "306", "307", "308"});
        return ret;
    }

    @Override
    public void notifyImportFinished(MainControl.Triplet triplet) {
    }

    @Override
    public void notifyImportInterrupted(boolean hide) {
    }

    @Override
    public void stopWaiting() {
    }

    @Override
    public void notifyTechniqueValidationFailed() {
    }

    public static void main(String[] args) {
        try {
            new StandaloneController(2);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

