/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsMapping;
import fr.gouv.finances.cp.xemelios.common.config.SpecialKeyModel;
import fr.gouv.finances.cp.xemelios.common.config.TextModel;
import fr.gouv.finances.cp.xemelios.common.config.XPathModel;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SpecialKeyEntryModel
implements NoeudModifiable,
Cloneable {
    private static Logger logger = Logger.getLogger(SpecialKeyEntryModel.class);
    private NoeudModifiable _NMParent = null;
    private String configXPath = null;
    public static final transient String TAG = "special-key-entry";
    public static final transient QName QN = new QName("special-key-entry");
    private boolean distinct = false;
    private boolean depends = false;
    private int pos = 0;
    private XPathModel path;
    private TextModel key1;
    private TextModel key2;
    private String id;
    private QName qn;

    public SpecialKeyEntryModel(QName tagName) {
        this.qn = tagName;
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (DocumentsMapping.PATH.equals(tagName)) {
            this.path = (XPathModel)child;
            this.path.setParentAsNoeudModifiable(this);
        } else if (DocumentsMapping.KEY1.equals(tagName)) {
            this.key1 = (TextModel)child;
            this.key1.setParentAsNoeudModifiable(this);
        } else if (DocumentsMapping.KEY2.equals(tagName)) {
            this.key2 = (TextModel)child;
            this.key2.setParentAsNoeudModifiable(this);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        if (attributes.getValue("id") != null) {
            this.id = attributes.getValue("id");
        }
        if (attributes.getValue("pos") != null) {
            this.pos = attributes.getIntValue("pos");
        }
        if (attributes.getValue("distinct") != null) {
            this.distinct = attributes.getBooleanValue("distinct");
        }
        if (attributes.getValue("depends") != null) {
            this.depends = attributes.getBooleanValue("depends");
        }
        return this;
    }

    public void marshall(XmlOutputter output) {
    }

    public void validate() throws InvalidXmlDefinition {
        NoeudModifiable localParent;
        if (this.id == null || this.id.length() == 0) {
            throw new InvalidXmlDefinition("//special-key-entry/@id is required (" + this.getParentAsNoeudModifiable().getConfigXPath() + "/" + TAG + ")");
        }
        for (localParent = this.getParentAsNoeudModifiable(); !(localParent instanceof DocumentModel) && localParent != null; localParent = localParent.getParentAsNoeudModifiable()) {
        }
        if (localParent != null) {
            DocumentModel dm = (DocumentModel)localParent;
            boolean found = false;
            for (SpecialKeyModel skm : dm.getSpecialKeys()) {
                found |= skm.getId().equals(this.id);
            }
            if (!found) {
                throw new InvalidXmlDefinition(this.getConfigXPath() + " references an unknown special-key: " + this.id);
            }
        }
    }

    public SpecialKeyEntryModel clone() {
        SpecialKeyEntryModel other = new SpecialKeyEntryModel(QN);
        other.depends = this.depends;
        other.distinct = this.distinct;
        try {
            other.addChild((XmlMarshallable)this.path.clone(), DocumentsMapping.PATH);
        }
        catch (Throwable t) {
            // empty catch block
        }
        other.pos = this.pos;
        try {
            other.addChild((XmlMarshallable)this.key1.clone(), DocumentsMapping.KEY1);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            other.addChild((XmlMarshallable)this.key2.clone(), DocumentsMapping.KEY2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return other;
    }

    public boolean isDepends() {
        return this.depends;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public XPathModel getPath() {
        return this.path;
    }

    public int getPos() {
        return this.pos;
    }

    public TextModel getKey1() {
        return this.key1;
    }

    public TextModel getKey2() {
        return this.key2;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00e0 jour des attributs : " + e));
        }
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        if ("path".equals(tagName)) {
            return this.path;
        }
        if ("key1".equals(tagName)) {
            return this.key1;
        }
        if ("key2".equals(tagName)) {
            return this.key2;
        }
        return null;
    }

    public String[] getChildIdAttrName(String childTagName) {
        return null;
    }

    public void resetCharData() {
    }

    public String getId() {
        return this.id;
    }

    public String getIdValue() {
        return this.getId();
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/special-key-entry[@id='" + this.getId() + "']";
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        QName name = new QName(uri, localName);
        if (DocumentsMapping.KEY1.equals(name)) {
            return this.key1;
        }
        if (DocumentsMapping.KEY2.equals(name)) {
            return this.key2;
        }
        return null;
    }

    public QName getQName() {
        return this.qn;
    }
}

