/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.RechercheModel;
import fr.gouv.finances.cp.xemelios.common.config.SavedRequestsModel;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PersonnalConfigurationModel
implements XmlMarshallable {
    public static final transient String TAG = "personnal-config";
    public static final transient QName QN = new QName("personnal-config");
    private Hashtable<String, SavedRequestsModel> savedRequests = new Hashtable();

    public PersonnalConfigurationModel(QName tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (SavedRequestsModel.QN.equals(tagName)) {
            SavedRequestsModel srm = (SavedRequestsModel)child;
            this.savedRequests.put(srm.getKey(), srm);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        Enumeration<SavedRequestsModel> enumer = this.savedRequests.elements();
        while (enumer.hasMoreElements()) {
            enumer.nextElement().marshall(output);
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public Object clone() {
        return this;
    }

    public SavedRequestsModel getSavedRequests(ElementModel em) {
        String key = this.getKey(em);
        SavedRequestsModel srm = this.savedRequests.get(key);
        if (srm == null) {
            srm = new SavedRequestsModel(SavedRequestsModel.QN, em);
            this.savedRequests.put(this.getKey(em), srm);
        }
        return srm;
    }

    private String getKey(ElementModel el) {
        return el.getParent().getParent().getId() + "|" + el.getParent().getId() + "|" + el.getId();
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        String key = atts.getValue("documentId") + "|" + atts.getValue("etatId") + "|" + atts.getValue("elementId");
        return this.savedRequests.get(key);
    }

    public QName getQName() {
        return QN;
    }

    public void setUnWritable(String name) {
        Enumeration<SavedRequestsModel> enumer = this.savedRequests.elements();
        while (enumer.hasMoreElements()) {
            enumer.nextElement().setUnWritable(name);
        }
    }

    public void merge(PersonnalConfigurationModel other) {
        Enumeration<SavedRequestsModel> enumer = other.savedRequests.elements();
        while (enumer.hasMoreElements()) {
            SavedRequestsModel sv = enumer.nextElement();
            SavedRequestsModel local = this.savedRequests.get(sv.getKey());
            try {
                for (RechercheModel rm : sv.getRecherches()) {
                    local.addChild(rm, RechercheModel.QN);
                }
            }
            catch (Throwable t) {
            }
        }
    }
}

