/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.auth;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class DlgLogin
extends JDialog {
    private static final long serialVersionUID = 3546362837975971889L;
    public static final transient String DLG_TITLE = "Authentification...";
    private JTextField txt1;
    private JPasswordField pwd1;
    private JButton pbOk;
    private JButton pbCancel;
    private boolean ret;
    private String userName;
    private String password;
    private Action escapeAction;
    private Properties props;

    public DlgLogin(JFrame owner) {
        super(owner, DLG_TITLE, true);
        File f = new File(System.getProperty("user.home"), "xemelios.properties");
        this.props = new Properties();
        if (f.exists()) {
            try {
                this.props.load(new FileInputStream(f));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.initComposants();
    }

    protected void initComposants() {
        int sepInfo = 2;
        int lineInfo = sepInfo + 2;
        int sepData = lineInfo + 2;
        int userLine = sepData + 2;
        int pwdLine = userLine + 2;
        int buttonLine = pwdLine + 2;
        JTextArea area = null;
        FormLayout fl = new FormLayout("3dlu,20dlu,pref,3dlu,pref,3dlu", "7dlu,pref,3dlu,pref,7dlu,pref,3dlu,pref,3dlu,pref,10dlu,pref,3dlu");
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(fl);
        IhmFactory iF = IhmFactory.newInstance();
        pb.addSeparator("Informations", cc.xyw(2, sepInfo, 4));
        area = new JTextArea();
        pb.add((Component)area, cc.xyw(3, lineInfo, 3));
        pb.addSeparator("Donn\u00e9es", cc.xyw(2, sepData, 4));
        pb.add((Component)iF.newLabel("Utilisateur", "normal"), cc.xy(3, userLine));
        this.txt1 = new JTextField();
        pb.add((Component)this.txt1, cc.xy(5, userLine));
        pb.add((Component)iF.newLabel("Mot de passe", "normal"), cc.xy(3, pwdLine));
        this.pwd1 = new JPasswordField();
        pb.add((Component)this.pwd1, cc.xy(5, pwdLine));
        JPanel bPane = new JPanel(new FlowLayout(1));
        this.pbCancel = new JButton(this.escapeAction);
        this.pbOk = new JButton("Ok");
        bPane.add(this.pbOk);
        bPane.add(this.pbCancel);
        pb.add((Component)bPane, cc.xyw(2, buttonLine, 4));
        this.pwd1.setColumns(15);
        this.add(pb.getPanel());
        area.setEditable(false);
        area.setLineWrap(true);
        area.setRows(3);
        area.setBackground(this.getBackground());
        area.setText("Veuillez saisir le mot de passe\r\npour acc\u00e9der \u00e0 XEMELIOS");
        this.pbOk.setDefaultCapable(true);
        this.pbOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DlgLogin.this.txt1.getText() == null || DlgLogin.this.txt1.getText().length() == 0) {
                    JOptionPane.showMessageDialog(DlgLogin.this, "L'identifiant est obligatoire", "Erreur", 0);
                    DlgLogin.this.txt1.grabFocus();
                    return;
                }
                if (DlgLogin.this.pwd1.getPassword().length == 0) {
                    JOptionPane.showMessageDialog(DlgLogin.this, "Le mot de passe est obligatoire", "Erreur", 0);
                    DlgLogin.this.pwd1.grabFocus();
                    return;
                }
                DlgLogin.this.userName = DlgLogin.this.txt1.getText();
                DlgLogin.this.password = new String(DlgLogin.this.pwd1.getPassword());
                DlgLogin.this.ret = true;
                DlgLogin.this.props.setProperty("last.login", DlgLogin.this.userName);
                DlgLogin.this.setVisible(false);
                try {
                    DlgLogin.this.props.store(new FileOutputStream(new File(System.getProperty("user.home"), "xemelios.properties")), "");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.getRootPane().setDefaultButton(this.pbOk);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean run() {
        String lastLogin = this.props.getProperty("last.login");
        this.txt1.setText(lastLogin);
        this.pwd1.setText("");
        if (lastLogin != null && lastLogin.length() > 0) {
            this.pwd1.grabFocus();
        } else {
            this.txt1.grabFocus();
        }
        this.setVisible(true);
        return this.ret;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    protected JRootPane createRootPane() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractAction("Annuler"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                DlgLogin.this.ret = false;
                DlgLogin.this.setVisible(false);
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ks, 2);
        return rp;
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    static {
        System.out.println(System.getProperty("os.name"));
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            DlgLogin.setDefaultLookAndFeelDecorated(true);
        }
    }
}

