/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.xml.xpath;

import fr.gouv.finances.cp.utils.xml.xpath.AbstractXPathFunction;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.xpath.XPathFunctionException;
import org.apache.log4j.Logger;

public class FuncDateEquals
extends AbstractXPathFunction {
    private static Logger logger = Logger.getLogger(FuncDateEquals.class);
    public static final transient String FUNCTION_NAME = "DateEquals";

    public Object evaluate(List args) throws XPathFunctionException {
        if (args.size() != 2) {
            throw new XPathFunctionException("DateEquals requires exactly 2 parameters");
        }
        Object o1 = args.get(0);
        Object o2 = args.get(1);
        String s1 = null;
        String s2 = null;
        s1 = this.getStringValue(o1);
        s2 = this.getStringValue(o2);
        if (s1 == null && s2 == null) {
            return Boolean.TRUE;
        }
        if (s1 == null || s2 == null) {
            return Boolean.FALSE;
        }
        Boolean ret = Boolean.FALSE;
        try {
            DatatypeFactory df = DatatypeFactory.newInstance();
            XMLGregorianCalendar d1 = df.newXMLGregorianCalendar(s1);
            XMLGregorianCalendar d2 = df.newXMLGregorianCalendar(s2);
            ret = new Boolean(d1.compare(d2) == 0);
        }
        catch (DatatypeConfigurationException dcEx) {
            logger.error((Object)"", (Throwable)dcEx);
        }
        return ret;
    }
}

