/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.xml;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceContextImpl
implements NamespaceContext {
    private Hashtable<String, String> prefixToUri = new Hashtable();
    private Hashtable<String, TreeSet<String>> uriToPrefix = new Hashtable();
    private ArrayList<NsMapping> mappings = new ArrayList();

    public void addMapping(String prefix, String uri) {
        if (prefix == null || uri == null) {
            return;
        }
        this.prefixToUri.put(prefix, uri);
        TreeSet<String> prefixes = this.uriToPrefix.get(uri);
        if (prefixes == null) {
            prefixes = new TreeSet();
            this.uriToPrefix.put(uri, prefixes);
        }
        prefixes.add(prefix);
        this.mappings.add(new NsMapping(prefix, uri));
    }

    public void removeMapping(String prefix) {
        String uri = this.prefixToUri.remove(prefix);
        if (uri != null) {
            TreeSet<String> prefixes = this.uriToPrefix.get(uri);
            prefixes.remove(prefix);
            this.mappings.remove(prefix);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String ret = this.prefixToUri.get(prefix);
        return ret;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        String ret = null;
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI can not be null");
        }
        if ("xml".equals(namespaceURI)) {
            ret = "http://www.w3.org/XML/1998/namespace";
        } else if ("xmlns".equals(namespaceURI)) {
            ret = "http://www.w3.org/2000/xmlns/";
        }
        TreeSet<String> prefixes = this.uriToPrefix.get(namespaceURI);
        if (prefixes != null) {
            ret = prefixes.first();
        }
        return ret;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI must not be null");
        }
        TreeSet<String> prefixes = this.uriToPrefix.get(namespaceURI);
        if (prefixes != null) {
            return prefixes.iterator();
        }
        if ("xml".equals(namespaceURI)) {
            return new StringIterator<String>("http://www.w3.org/XML/1998/namespace");
        }
        if ("xmlns".equals(namespaceURI)) {
            return new StringIterator<String>("http://www.w3.org/2000/xmlns/");
        }
        return null;
    }

    public ArrayList<NsMapping> getMappings() {
        return this.mappings;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringIterator<String>
    implements Iterator {
        private final String data;
        private boolean answered = false;

        public StringIterator(String data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return !this.answered;
        }

        public String next() {
            if (this.answered) {
                throw new NoSuchElementException();
            }
            this.answered = true;
            return this.data;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can not remove !");
        }
    }

    public static class NsMapping {
        String prefix;
        String uri;
        boolean written = false;

        public NsMapping(String prefix, String uri) {
            this.prefix = prefix;
            this.uri = uri;
        }

        public boolean isWritten() {
            return this.written;
        }

        public void setWritten() {
            this.written = true;
        }

        public boolean equals(Object o) {
            if (o instanceof NsMapping) {
                NsMapping other = (NsMapping)o;
                return other.prefix.equals(this.prefix);
            }
            if (o instanceof String) {
                return this.prefix.equals((String)o);
            }
            return false;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

