/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DlgGetPair
extends JDialog {
    private static final long serialVersionUID = 5506053470241303864L;
    private static final String TITLE = "Informations";
    private JButton pbOk;
    private JButton pbCancel;
    private boolean ret;
    private Action escapeAction;
    private String question;
    private JTextField dfCode;
    private JTextField dfLibelle;
    private JComboBox cbxData;
    private TreeSet<Pair> defaultValues;
    private Timer timer = null;

    public DlgGetPair(JFrame owner, String question) {
        this(owner, question, TITLE);
    }

    public DlgGetPair(JFrame owner, String question, String title) {
        super(owner, title, true);
        this.question = question;
        this.initialize();
    }

    public DlgGetPair(JFrame owner, String question, TreeSet<Pair> values) {
        this(owner, question, values, TITLE);
    }

    public DlgGetPair(JFrame owner, String question, TreeSet<Pair> values, String title) {
        super(owner, title, true);
        this.question = question;
        this.defaultValues = values;
        this.initialize();
    }

    public DlgGetPair(JFrame owner, String question, TreeSet<Pair> values, String title, Pair initialValue) {
        this(owner, question, values, title);
        if (initialValue != null) {
            if (initialValue.key != null && initialValue.key.trim().length() > 0) {
                this.dfCode.setText(initialValue.key);
                if (this.cbxData != null) {
                    this.cbxData.setEnabled(false);
                }
                this.dfCode.setEnabled(false);
                this.dfLibelle.grabFocus();
                this.dfLibelle.setText(initialValue.libelle);
                if (values != null) {
                    Pair p = null;
                    for (Pair p1 : values) {
                        if (!p1.equals(initialValue)) continue;
                        p = p1;
                    }
                    if (p != null) {
                        this.dfLibelle.setText(p.libelle);
                    }
                }
            } else {
                this.dfLibelle.setText(initialValue.libelle);
            }
        }
    }

    public void initialize() {
        int sepInfo = 2;
        int lineInfo = sepInfo + 2;
        int sepData = lineInfo + 2;
        int existingData = sepData + (this.defaultValues != null ? 2 : 0);
        int codeLine = existingData + 2;
        int libelleLine = codeLine + 2;
        int buttonLine = libelleLine + 2;
        JTextArea area = null;
        this.cbxData = null;
        this.setDefaultCloseOperation(2);
        FormLayout fl = new FormLayout("3dlu,20dlu,pref,3dlu,pref,3dlu", "7dlu,pref,3dlu,pref,7dlu,pref," + (this.defaultValues != null ? "3dlu,pref," : "") + "3dlu," + "pref," + "1dlu," + "pref," + "10dlu," + "pref," + "3dlu");
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(fl);
        IhmFactory iF = IhmFactory.newInstance();
        pb.addSeparator(TITLE, cc.xyw(2, sepInfo, 4));
        area = new JTextArea();
        pb.add((Component)area, cc.xyw(3, lineInfo, 3));
        pb.addSeparator("Donn\u00e9es", cc.xyw(2, sepData, 4));
        if (this.defaultValues != null) {
            pb.add((Component)iF.newLabel("Valeurs possibles", "normal"), cc.xy(3, existingData));
            Vector<Pair> data = new Vector<Pair>();
            data.add(new Pair("", ""));
            data.addAll(this.defaultValues);
            this.cbxData = new JComboBox(data);
            pb.add(this.cbxData, cc.xy(5, existingData));
            this.cbxData.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        JComboBox cbxData = (JComboBox)e.getSource();
                        Pair p = (Pair)cbxData.getSelectedItem();
                        DlgGetPair.this.dfCode.setText(p.key);
                        DlgGetPair.this.dfLibelle.setText(p.libelle);
                    }
                    DlgGetPair.this.resetTimer();
                }
            });
        }
        pb.add((Component)iF.newLabel("Code", "normal"), cc.xy(3, codeLine));
        this.dfCode = new JTextField();
        pb.add((Component)this.dfCode, cc.xy(5, codeLine));
        pb.add((Component)iF.newLabel("Libell\u00e9", "normal"), cc.xy(3, libelleLine));
        this.dfLibelle = new JTextField();
        pb.add((Component)this.dfLibelle, cc.xy(5, libelleLine));
        JPanel bPane = new JPanel(new FlowLayout(1));
        this.pbCancel = new JButton(this.escapeAction);
        this.pbOk = new JButton("Ok");
        bPane.add(this.pbOk);
        bPane.add(this.pbCancel);
        pb.add((Component)bPane, cc.xyw(2, buttonLine, 4));
        this.dfCode.setColumns(15);
        this.add(pb.getPanel());
        area.setEditable(false);
        area.setLineWrap(true);
        area.setRows(3);
        area.setBackground(this.getBackground());
        area.setText(this.question);
        if (this.defaultValues != null && this.defaultValues.size() > 0) {
            this.cbxData.setSelectedIndex(1);
        }
        this.dfCode.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
                DlgGetPair.this.resetTimer();
            }

            public void keyPressed(KeyEvent e) {
                DlgGetPair.this.resetTimer();
            }

            public void keyReleased(KeyEvent e) {
                DlgGetPair.this.resetTimer();
            }
        });
        this.dfLibelle.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
                DlgGetPair.this.resetTimer();
            }

            public void keyPressed(KeyEvent e) {
                DlgGetPair.this.resetTimer();
            }

            public void keyReleased(KeyEvent e) {
                DlgGetPair.this.resetTimer();
                DlgGetPair.this.resetTimer();
            }
        });
        this.dfCode.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                DlgGetPair.this.resetTimer();
            }
        });
        this.dfLibelle.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DlgGetPair.this.resetTimer();
            }

            public void focusLost(FocusEvent e) {
                DlgGetPair.this.resetTimer();
            }
        });
        this.pbOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DlgGetPair.this.checkReponse();
            }
        });
        this.getRootPane().setDefaultButton(this.pbOk);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractAction("Annuler"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                DlgGetPair.this.ret = false;
                DlgGetPair.this.setVisible(false);
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ks, 2);
        return rp;
    }

    protected void checkReponse() {
        if (this.dfCode.getText() != null && this.dfCode.getText().length() > 0 && this.dfLibelle.getText() != null && this.dfLibelle.getText().length() > 0) {
            this.setVisible(false);
            this.ret = true;
        } else {
            JOptionPane.showMessageDialog(this, "Le code ainsi que le libelle sont obligatoires", "Erreur de saisie", 2);
            this.ret = false;
        }
    }

    public String getCode() {
        return this.dfCode.getText();
    }

    public String getLibelle() {
        return this.dfLibelle.getText();
    }

    public boolean run() {
        if (this.dfCode.getText() != null && this.dfCode.getText().length() > 0) {
            int delay = 1000;
            ActionListener taskPerformer = new ActionListener(){
                private int sec = 30;

                public void actionPerformed(ActionEvent evt) {
                    if (this.sec == 0) {
                        if (evt.getSource() instanceof Timer) {
                            DlgGetPair.this.timer.stop();
                            DlgGetPair.this.timer = null;
                        }
                        DlgGetPair.this.pbOk.doClick();
                    } else {
                        String msg = "Ok (" + this.sec-- + " sec.)";
                        DlgGetPair.this.pbOk.setText(msg);
                    }
                }
            };
            this.timer = new Timer(delay, taskPerformer);
            this.timer.start();
        }
        this.setVisible(true);
        this.toFront();
        return this.ret;
    }

    @Override
    public void setVisible(boolean b) {
        this.dfCode.grabFocus();
        super.setVisible(b);
    }

    private void resetTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.pbOk.setText("Ok");
    }

    static {
        System.out.println(System.getProperty("os.name"));
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            DlgGetPair.setDefaultLookAndFeelDecorated(true);
        }
    }
}

