/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;

public class DefaultTreeTableModel
extends AbstractTreeTableModel {
    protected boolean asksAllowsChildren;

    public DefaultTreeTableModel() {
        this(null);
    }

    public DefaultTreeTableModel(TreeNode treeNode) {
        this(treeNode, false);
    }

    public DefaultTreeTableModel(TreeNode treeNode, boolean bl) {
        super(treeNode);
        this.asksAllowsChildren = bl;
    }

    public void setRoot(TreeNode treeNode) {
        Object object = this.root;
        this.root = treeNode;
        if (treeNode == null && object != null) {
            this.fireTreeStructureChanged(this, null);
        } else {
            this.nodeStructureChanged(treeNode);
        }
    }

    private void fireTreeStructureChanged(Object object, TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent(object, treePath);
            }
            ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }

    public boolean asksAllowsChildren() {
        return this.asksAllowsChildren;
    }

    public void setAsksAllowsChildren(boolean bl) {
        this.asksAllowsChildren = bl;
    }

    public Object getValueAt(Object object, int n) {
        return object + "@column " + n;
    }

    public void setValueAt(Object object, Object object2, int n) {
    }

    public TreeNode[] getPathToRoot(TreeNode treeNode) {
        return this.getPathToRoot(treeNode, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode treeNode, int n) {
        TreeNode[] treeNodeArray;
        if (treeNode == null) {
            if (n == 0) {
                return null;
            }
            treeNodeArray = new TreeNode[n];
        } else {
            treeNodeArray = treeNode == this.root ? new TreeNode[n] : this.getPathToRoot(treeNode.getParent(), ++n);
            treeNodeArray[treeNodeArray.length - n] = treeNode;
        }
        return treeNodeArray;
    }

    public boolean isLeaf(Object object) {
        if (object instanceof TreeNode && this.asksAllowsChildren) {
            return !((TreeNode)object).getAllowsChildren();
        }
        return super.isLeaf(object);
    }

    public void reload() {
        TreeNode treeNode;
        try {
            treeNode = (TreeNode)this.root;
        }
        catch (ClassCastException classCastException) {
            return;
        }
        this.reload(treeNode);
    }

    public void reload(TreeNode treeNode) {
        if (treeNode != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(treeNode), null, null);
        }
    }

    public void nodesWereInserted(TreeNode treeNode, int[] nArray) {
        if (this.listenerList != null && treeNode != null && nArray != null && nArray.length > 0) {
            int n = nArray.length;
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = treeNode.getChildAt(nArray[i]);
            }
            this.fireTreeNodesInserted(this, this.getPathToRoot(treeNode), nArray, objectArray);
        }
    }

    public void nodesWereRemoved(TreeNode treeNode, int[] nArray, Object[] objectArray) {
        if (treeNode != null && nArray != null) {
            this.fireTreeNodesRemoved(this, this.getPathToRoot(treeNode), nArray, objectArray);
        }
    }

    public void nodesChanged(TreeNode treeNode, int[] nArray) {
        if (treeNode != null) {
            if (nArray != null) {
                int n = nArray.length;
                if (n > 0) {
                    Object[] objectArray = new Object[n];
                    for (int i = 0; i < n; ++i) {
                        objectArray[i] = treeNode.getChildAt(nArray[i]);
                    }
                    this.fireTreeNodesChanged(this, this.getPathToRoot(treeNode), nArray, objectArray);
                }
            } else if (treeNode == this.getRoot()) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(treeNode), null, null);
            }
        }
    }

    public void nodeStructureChanged(TreeNode treeNode) {
        if (treeNode != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot(treeNode), null, null);
        }
    }
}

