/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xom;

import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.xom.NodeWrapper;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;

public class DocumentWrapper
extends NodeWrapper
implements DocumentInfo {
    protected Configuration config;
    protected String baseURI;
    protected int documentNumber;
    private HashMap idIndex;

    public DocumentWrapper(Node node, String string, Configuration configuration) {
        super(node, null, 0);
        if (node.getParent() != null) {
            throw new IllegalArgumentException("root node must not have a parent node");
        }
        this.baseURI = string;
        this.docWrapper = this;
        this.setConfiguration(configuration);
    }

    public NodeInfo wrap(Node node) {
        if (node == this.node) {
            return this;
        }
        return this.makeWrapper(node, this);
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        this.documentNumber = configuration.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public NodeInfo selectID(String string) {
        if (this.idIndex == null) {
            Element element;
            switch (this.nodeKind) {
                case 9: {
                    element = ((Document)this.node).getRootElement();
                    break;
                }
                case 1: {
                    element = (Element)this.node;
                    break;
                }
                default: {
                    return null;
                }
            }
            this.idIndex = new HashMap(50);
            this.buildIDIndex(element);
        }
        return (NodeInfo)this.idIndex.get(string);
    }

    private void buildIDIndex(Element element) {
        Node node;
        int n = element.getChildCount();
        while (--n >= 0) {
            node = element.getChild(n);
            if (!(node instanceof Element)) continue;
            this.buildIDIndex((Element)node);
        }
        n = element.getAttributeCount();
        while (--n >= 0) {
            node = element.getAttribute(n);
            if (node.getType() != Attribute.Type.ID) continue;
            this.idIndex.put(node.getValue(), this.wrap((Node)element));
        }
    }

    public String[] getUnparsedEntity(String string) {
        return null;
    }
}

