/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.search;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.xemelios.common.ToolException;
import fr.gouv.finances.cp.xemelios.common.config.ChampModel;
import fr.gouv.finances.cp.xemelios.common.config.CritereModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.HiddenModel;
import fr.gouv.finances.cp.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.cp.xemelios.common.config.PluginModel;
import fr.gouv.finances.cp.xemelios.common.config.WidgetModel;
import fr.gouv.finances.cp.xemelios.data.DataResultSet;
import fr.gouv.finances.cp.xemelios.plugins.ExportPlugin;
import fr.gouv.finances.cp.xemelios.plugins.SearchPlugin;
import fr.gouv.finances.cp.xemelios.ui.CriteriaViewer;
import fr.gouv.finances.cp.xemelios.ui.SearchWindow;
import fr.gouv.finances.cp.xemelios.ui.search.ResultDisplayerThread;
import fr.gouv.finances.cp.xemelios.ui.search.XPathExecuter;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchThread
extends Thread {
    private static Logger logger = Logger.getLogger(SearchThread.class);
    public Throwable exceptionDuringProcess = null;
    public Object obj = null;
    private boolean background = false;
    private SearchWindow parentCaller;
    private ElementModel elementModel = null;
    private Pair collectivite = null;
    private Pair budget = null;
    private PluginModel plugin = null;
    private Vector<CriteriaViewer> criterias = null;

    public SearchThread(SearchWindow parent, ElementModel elementModel, Pair collectivite, Pair budget, Vector<CriteriaViewer> criterias, PluginModel plugin) {
        super("Searcher");
        this.parentCaller = parent;
        this.elementModel = elementModel;
        this.collectivite = collectivite;
        this.budget = budget;
        this.criterias = criterias;
        this.plugin = plugin;
    }

    public SearchThread(SearchWindow parent, ElementModel elementModel, Pair collectivite, Pair budget, Vector<CriteriaViewer> criterias, PluginModel plugin, boolean runInBackground) {
        this(parent, elementModel, collectivite, budget, criterias, plugin);
        this.background = runInBackground;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        this.setPriority(1);
        if (this.plugin == null) {
            this.simpleSearch(start);
        } else if ("search".equals(this.plugin.getPluginType())) {
            this.pluginSearch(start);
        } else if ("export".equals(this.plugin.getPluginType())) {
            this.pluginExport(start);
        }
        if (this.exceptionDuringProcess != null && !(this.exceptionDuringProcess instanceof ToolException)) {
            new DisplayExceptionDlg((Frame)this.parentCaller.getParentFrame(), this.exceptionDuringProcess);
        }
    }

    protected CriteriaViewer getDoublon(Vector<CriteriaViewer> vcv) {
        Vector<String> ids = new Vector<String>();
        for (CriteriaViewer cv : vcv) {
            if (cv.isHideRemoveIcon()) continue;
            if (ids.contains(cv.getCurrentCritereModel().getId())) {
                return cv;
            }
            ids.add(cv.getCurrentCritereModel().getId());
        }
        return null;
    }

    protected void pluginSearch(long start) {
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        boolean shouldContinue = true;
        for (CriteriaViewer cv : this.criterias) {
            try {
                parameters.putAll(cv.getParameters());
            }
            catch (ToolException tEx) {
                shouldContinue = false;
                this.exceptionDuringProcess = tEx;
                this.obj = cv;
            }
        }
        CriteriaViewer doublon = null;
        doublon = this.getDoublon(this.criterias);
        if (doublon != null) {
            this.obj = doublon;
            doublon.focusOnDelete();
            this.exceptionDuringProcess = new ToolException("Il n'est pas possible d'utiliser plusieurs fois le m\u00eame crit\u00e8re optionnel dans une recherche pr\u00e9d\u00e9finie. Veuillez supprimer les doublons.", 6);
            shouldContinue = false;
        }
        if (shouldContinue) {
            try {
                Class<?> clazz = Class.forName(this.plugin.getPluginClass());
                SearchPlugin xp = (SearchPlugin)((Object)clazz.newInstance());
                xp.setModel(this.plugin);
                xp.setElementModel(this.elementModel);
                xp.setParameters(parameters);
                xp.setOwner(this.parentCaller.getParentFrame());
                xp.setStart(start);
                xp.setSearchWindow(this.parentCaller);
                xp.setCollectivite(this.collectivite);
                xp.setBudget(this.budget);
                xp.setListeResultat(this.getListeResultat());
                xp.startSearch();
            }
            catch (ClassNotFoundException cnfEx) {
                this.exceptionDuringProcess = cnfEx;
            }
            catch (InstantiationException iEx) {
                this.exceptionDuringProcess = iEx;
            }
            catch (IllegalAccessException iaEx) {
                this.exceptionDuringProcess = iaEx;
            }
            catch (Exception ex) {
                this.exceptionDuringProcess = ex;
            }
        } else {
            this.parentCaller.getParentFrame().stopWaiter();
            this.parentCaller.setCursor(Cursor.getDefaultCursor());
            SearchWindow.DisplayErrorSearchThread code = new SearchWindow.DisplayErrorSearchThread(this.parentCaller, (ToolException)this.exceptionDuringProcess, this.obj);
            if (SwingUtilities.isEventDispatchThread()) {
                code.run();
            } else {
                SwingUtilities.invokeLater(code);
            }
        }
    }

    protected void pluginExport(long start) {
        logger.debug((Object)"entering pluginxport");
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        boolean shouldContinue = true;
        for (CriteriaViewer cv : this.criterias) {
            try {
                parameters.putAll(cv.getParameters());
            }
            catch (ToolException tEx) {
                shouldContinue = false;
                this.exceptionDuringProcess = tEx;
                this.obj = cv;
            }
        }
        if (shouldContinue) {
            try {
                Class<?> clazz = Class.forName(this.plugin.getPluginClass());
                ExportPlugin xp = (ExportPlugin)((Object)clazz.newInstance());
                xp.setModel(this.plugin);
                xp.setCollectivite(this.collectivite);
                xp.setBudget(this.budget);
                xp.setElementModel(this.elementModel);
                xp.setParameters(parameters);
                xp.setOwner(this.parentCaller.getParentFrame());
                xp.setStart(start);
                xp.setSearchWindow(this.parentCaller);
                xp.startExport();
            }
            catch (ClassNotFoundException cnfEx) {
                this.exceptionDuringProcess = cnfEx;
            }
            catch (InstantiationException iEx) {
                this.exceptionDuringProcess = iEx;
            }
            catch (IllegalAccessException iaEx) {
                this.exceptionDuringProcess = iaEx;
            }
            catch (Exception ex) {
                this.exceptionDuringProcess = ex;
            }
        } else {
            this.parentCaller.getParentFrame().stopWaiter();
            this.parentCaller.setCursor(Cursor.getDefaultCursor());
            SearchWindow.DisplayErrorSearchThread code = new SearchWindow.DisplayErrorSearchThread(this.parentCaller, (ToolException)this.exceptionDuringProcess, this.obj);
            if (SwingUtilities.isEventDispatchThread()) {
                code.run();
            } else {
                SwingUtilities.invokeLater(code);
            }
        }
    }

    protected void simpleSearch(long start) {
        StringBuffer buff = new StringBuffer();
        buff.append(this.elementModel.getPath().getPath());
        boolean shouldContinue = true;
        HashMap<String, ChampModel> additionnalFields = new HashMap<String, ChampModel>();
        Vector<CritereModel> models = new Vector<CritereModel>();
        for (CriteriaViewer cv : this.criterias) {
            Object cm = cv.getModel();
            models.add((CritereModel)cm);
            try {
                ChampModel champOptionnel;
                String idAffichage;
                if (cv.getAndOrEr().equals("||")) {
                    buff.append("|").append(this.elementModel.getPath().getPath());
                }
                buff.append(cv.getXPathExpr());
                if (!cv.isOptionalDisplayChecked() || (idAffichage = ((CritereModel)cm).getIdAffichage()) == null || idAffichage.length() <= 0 || (champOptionnel = this.elementModel.getListeResultat().getChamps().get(idAffichage).clone()) == null) continue;
                additionnalFields.put(champOptionnel.getId(), champOptionnel);
            }
            catch (ToolException tEx) {
                shouldContinue = false;
                this.parentCaller.parentFrame.stopWaiter();
                this.setPriority(5);
                if (tEx.getErrorCode() != 6) {
                    logger.error((Object)tEx.getMessage(), (Throwable)tEx);
                } else {
                    this.parentCaller.setCursor(Cursor.getDefaultCursor());
                    this.exceptionDuringProcess = tEx;
                    this.obj = cv;
                }
                SearchWindow.DisplayErrorSearchThread code = new SearchWindow.DisplayErrorSearchThread(this.parentCaller, tEx, this.obj);
                if (SwingUtilities.isEventDispatchThread()) {
                    code.run();
                } else {
                    SwingUtilities.invokeLater(code);
                }
                this.exceptionDuringProcess = null;
                break;
            }
            catch (Exception ex) {
                shouldContinue = false;
                this.exceptionDuringProcess = ex;
                this.parentCaller.parentFrame.stopWaiter();
            }
        }
        if (!shouldContinue) {
            this.parentCaller.getParentFrame().stopWaiter();
            this.parentCaller.setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (this.background) {
            Runnable code = new Runnable(){

                public void run() {
                    logger.debug((Object)"iconify");
                    SearchThread.this.parentCaller.setTitle("Recherche en cours...");
                    JDesktopPane dp = SearchThread.this.parentCaller.getDesktopPane();
                    dp.getDesktopManager().iconifyFrame(SearchThread.this.parentCaller);
                    Graphics g = dp.getGraphics();
                    if (g != null) {
                        dp.update(g);
                    } else {
                        logger.fatal((Object)"impossible de recuperer G");
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                code.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(code);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            Thread.yield();
            this.setPriority(1);
        }
        ListeResultatModel lrm = new ListeResultatModel(ListeResultatModel.QN);
        lrm.setParent(this.elementModel);
        for (Object cm : additionnalFields.values()) {
            try {
                lrm.addChild((XmlMarshallable)cm, ChampModel.QN);
            }
            catch (Throwable t) {}
        }
        ListeResultatModel lrm2 = this.elementModel.getListeResultat().clone();
        for (ChampModel cm : lrm2.getListeChamps()) {
            try {
                if (!cm.isAfficheDefaut() || !cm.isAffichable()) continue;
                lrm.addChild((XmlMarshallable)cm, ChampModel.QN);
            }
            catch (Throwable t) {}
        }
        lrm.setTriDefaut(lrm2.getTriDefaut());
        lrm.setOrdre(lrm2.getOrdre());
        for (HiddenModel hm : lrm2.getHiddens()) {
            try {
                lrm.addChild((XmlMarshallable)hm, HiddenModel.QN);
            }
            catch (Throwable t) {}
        }
        for (WidgetModel wm : lrm2.getWidgets()) {
            try {
                lrm.addChild((XmlMarshallable)wm, WidgetModel.QN);
            }
            catch (Throwable t) {}
        }
        try {
            XPathExecuter xe = new XPathExecuter(this.elementModel, buff.toString(), models, this.collectivite, this.budget, lrm, start, this.parentCaller);
            if (this.background) {
                xe.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("COMPLETED".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                            Runnable code = new Runnable(){

                                public void run() {
                                    logger.debug((Object)"uniconify");
                                    SearchThread.this.parentCaller.redisplayTitle();
                                    SearchThread.this.parentCaller.getDesktopPane().getDesktopManager().deiconifyFrame(SearchThread.this.parentCaller);
                                }
                            };
                            if (SwingUtilities.isEventDispatchThread()) {
                                code.run();
                            } else {
                                SwingUtilities.invokeLater(code);
                            }
                        }
                    }
                });
            }
            xe.execute();
            try {
                xe.get();
            }
            catch (Throwable t) {}
        }
        catch (Throwable th) {
            th.printStackTrace();
            this.exceptionDuringProcess = th instanceof OutOfMemoryError ? new ToolException("M\u00e9moire insuffisante pour cette requ\u00eate. \nEssayez d'augmenter les param\u00e8tres -Xmx et -Xss de la JVM ou affinez votre requ\u00eate.", 7) : (th instanceof StackOverflowError ? new ToolException("M\u00e9moire insuffisante pour cette requ\u00eate. \nEssayez d'augmenter les param\u00e8tres -Xmx et -Xss de la JVM ou affinez votre requ\u00eate.", 7) : th);
        }
    }

    protected ListeResultatModel getListeResultat() {
        HashMap<String, ChampModel> additionnalFields = new HashMap<String, ChampModel>();
        for (CriteriaViewer cv : this.criterias) {
            Object cm = cv.getModel();
            try {
                ChampModel champOptionnel;
                String idAffichage;
                if (!cv.isOptionalDisplayChecked() || (idAffichage = cm.getIdAffichage()) == null || idAffichage.length() <= 0 || (champOptionnel = this.elementModel.getListeResultat().getChamps().get(idAffichage).clone()) == null) continue;
                additionnalFields.put(champOptionnel.getId(), champOptionnel);
            }
            catch (Exception ex) {}
        }
        ListeResultatModel lrm = new ListeResultatModel(ListeResultatModel.QN);
        lrm.setParent(this.elementModel);
        for (Object cm : additionnalFields.values()) {
            try {
                lrm.addChild((XmlMarshallable)cm, ChampModel.QN);
            }
            catch (Throwable t) {}
        }
        ListeResultatModel lrm2 = this.elementModel.getListeResultat().clone();
        for (ChampModel cm : lrm2.getListeChamps()) {
            try {
                if (!cm.isAfficheDefaut() || !cm.isAffichable()) continue;
                lrm.addChild((XmlMarshallable)cm, ChampModel.QN);
            }
            catch (Throwable t) {}
        }
        lrm.setTriDefaut(lrm2.getTriDefaut());
        lrm.setOrdre(lrm2.getOrdre());
        for (HiddenModel hm : lrm2.getHiddens()) {
            try {
                lrm.addChild((XmlMarshallable)hm, HiddenModel.QN);
            }
            catch (Throwable t) {}
        }
        for (WidgetModel wm : lrm2.getWidgets()) {
            try {
                lrm.addChild((XmlMarshallable)wm, WidgetModel.QN);
            }
            catch (Throwable t) {}
        }
        return lrm;
    }

    protected void displayResult(DataResultSet rs, ListeResultatModel lrm, long start) {
        ResultDisplayerThread code = new ResultDisplayerThread(rs, lrm, start, this.elementModel, this.parentCaller);
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(code);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }
}

