/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.admin;

import fr.gouv.finances.cp.utils.PropertiesExpansion;
import fr.gouv.finances.cp.xemelios.ui.admin.ParamSaver;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;

public class PnlExport
extends JPanel
implements ParamSaver {
    private static Logger logger = Logger.getLogger(PnlExport.class);
    private static String PANEL_DESCRIPTION = "Permet de configurer la fa\u00e7on dont les donn\u00e9es sont export\u00e9es\npar le menu Fichier / Export, ou par le menu Exports / Executer";
    private static ExporterConfig EXPORT_CSV = new ExporterConfig("fr.gouv.finances.cp.xemelios.export.CsvExporter", "Exports CSV", "Permet de r\u00e9aliser des exports au format CSV.");
    private static ExporterConfig EXPORT_XLS_2000 = new ExporterConfig("fr.gouv.finances.cp.xemelios.export.HtmlTableExporter", "Exports Excel 2000/2003/2007", "Permet de r\u00e9aliser des exports de gros volumes pour Excel.\nN\u00e9cessite qu'Excel 2000 / 2003 / 2007 soit install\u00e9 sur le poste.");
    private static ExporterConfig EXPORT_XLS_97 = new ExporterConfig("fr.gouv.finances.cp.xemelios.export.SylkExporter", "Exports Excel 97", "Permet de r\u00e9aliser des exports de gros volumes pour Excel.\nN\u00e9cessite qu'Excel 97 soit install\u00e9 sur le poste.");
    private static ExporterConfig EXPORT_XLS_JXL = new ExporterConfig("fr.gouv.finances.cp.xemelios.export.JxlExporter", "Exports Excel simples", "Permet de r\u00e9aliser des exports pour toutes versions d'Excel,\nmais limit\u00e9s \u00e0 de petits fichiers.");
    private static ExporterConfig[] exporters = new ExporterConfig[]{EXPORT_CSV, EXPORT_XLS_2000, EXPORT_XLS_97, EXPORT_XLS_JXL};
    private JComboBox cbxExporter;
    private JTextArea dfDesc;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;

    public PnlExport() {
        this.initComponents();
        this.initializeData();
    }

    protected void initializeData() {
        String exporterClassName = System.getProperty("xemelios.exporter.class");
        for (ExporterConfig ec : exporters) {
            if (!ec.getClassName().equals(exporterClassName)) continue;
            this.cbxExporter.setSelectedItem(ec);
            break;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbxExporter = new JComboBox<ExporterConfig>(exporters);
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.dfDesc = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea(PANEL_DESCRIPTION);
        this.jLabel1.setText("M\u00e9thode d'export Excel");
        this.cbxExporter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PnlExport.this.cbxExporterItemStateChanged(evt);
            }
        });
        this.jLabel2.setText("Description");
        this.dfDesc.setColumns(20);
        this.dfDesc.setEditable(false);
        this.dfDesc.setRows(5);
        this.jScrollPane1.setViewportView(this.dfDesc);
        this.jScrollPane2.setBorder(null);
        this.jTextArea1.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setBorder(null);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 376, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 238, Short.MAX_VALUE).add((Component)this.cbxExporter, 0, 238, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -2, -1, -2).addPreferredGap(0, 24, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.cbxExporter, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jScrollPane1, -2, 105, -2)).add(79, 79, 79)));
    }

    private void cbxExporterItemStateChanged(ItemEvent evt) {
        if (this.cbxExporter.getSelectedItem() != null) {
            this.dfDesc.setText(((ExporterConfig)this.cbxExporter.getSelectedItem()).getDescription());
        }
    }

    public void saveConfiguration() {
        PropertiesExpansion props = new PropertiesExpansion(System.getProperties());
        Properties xemProps = new Properties();
        File xemPropsFile = new File(props.replace("${xemelios.prg}/root/xemelios.properties"));
        if (xemPropsFile.exists()) {
            try {
                xemProps.load(new FileInputStream(xemPropsFile));
                String className = ((ExporterConfig)this.cbxExporter.getSelectedItem()).getClassName();
                xemProps.put("xemelios.exporter.class", className);
                System.setProperty("xemelios.exporter.class", className);
                xemProps.store(new FileOutputStream(xemPropsFile), "");
            }
            catch (IOException ioEx) {
                logger.error((Object)"while saving exporter configuration: ", (Throwable)ioEx);
            }
        }
    }

    private static class ExporterConfig {
        private String className;
        private String title;
        private String description;

        public ExporterConfig(String className, String title, String description) {
            this.className = className;
            this.title = title;
            this.description = description;
        }

        public String toString() {
            return this.title;
        }

        public String getClassName() {
            return this.className;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

