/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.ui.DatabaseTreeDataFichier;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelChooseDatabaseFichier
extends JPanel {
    private static final Logger logger = Logger.getLogger(PanelChooseDatabaseFichier.class);
    private DocumentsModel dms = null;
    private DatabaseTreeDataFichier data = null;
    private boolean selectionMultiple = true;
    private int mode = 0;
    public static final int MODE_SUPPRESSION = 0;
    public static final int MODE_EXPORT = 1;
    private JButton bRechercher;
    private JComboBox cbBudget;
    private JComboBox cbCollectivite;
    private JComboBox cbTypeDoc;
    private JButton bSelectAll;
    private JButton bUnSelectAll;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JXTreeTable listeFichiers;

    public DatabaseTreeDataFichier getData() {
        return this.data;
    }

    public PanelChooseDatabaseFichier(JDialog p, DocumentsModel d, boolean selectionMultiple) {
        this.dms = d;
        this.selectionMultiple = selectionMultiple;
        this.initComponents();
        this.fillDocType();
        this.data = new DatabaseTreeDataFichier((JXTable)this.listeFichiers);
        this.data.setMode(this.getMode());
        this.data.setSelectionMultiple(this.selectionMultiple);
        this.listeFichiers.setTreeTableModel((TreeTableModel)this.data);
        this.listeFichiers.setRootVisible(false);
    }

    private void fillDocType() {
        Vector<Pair> v = new Vector<Pair>();
        v.add(new Pair("RIEN", "Tous"));
        this.cbTypeDoc.addItem(new Pair("RIEN", "Tous"));
        for (DocumentModel d : this.dms.getDocuments()) {
            if (d.getDisplayInMenuIf() != null && !"true".equals(System.getProperty(d.getDisplayInMenuIf()))) continue;
            v.add(new Pair(d.getId(), d.getTitre()));
        }
        this.cbTypeDoc.setModel(new DefaultComboBoxModel(v));
        this.fillColl();
        this.fillBudg();
    }

    private void fillColl() {
        String selectedDocId = ((Pair)this.cbTypeDoc.getSelectedItem()).key;
        Vector<Pair> v = new Vector<Pair>();
        v.add(new Pair("RIEN", "Toutes"));
        if (!"RIEN".equals(selectedDocId)) {
            DocumentModel selectedDocumentModel = this.dms.getDocumentById(selectedDocId);
            Vector<Pair> collectivites = this.getCollectivitesFromDocumentModel(selectedDocumentModel);
            v.addAll(collectivites);
        }
        this.cbCollectivite.setModel(new DefaultComboBoxModel(v));
        this.fillBudg();
    }

    private void fillBudg() {
        String selectedDocId = ((Pair)this.cbTypeDoc.getSelectedItem()).key;
        Pair selectedColl = (Pair)this.cbCollectivite.getSelectedItem();
        Vector<Pair> v = new Vector<Pair>();
        v.add(new Pair("RIEN", "Tous"));
        if (!"RIEN".equals(selectedColl)) {
            DocumentModel selectedDocumentModel = this.dms.getDocumentById(selectedDocId);
            try {
                Vector<Pair> budgets = DataLayerManager.getImplementation().getBudgets(selectedDocumentModel, selectedColl);
                v.addAll(budgets);
            }
            catch (Exception e) {
                logger.debug((Object)"Ce n'est pas grave, on n'a juste pas reussi a trouver le budget", (Throwable)e);
            }
        }
        this.cbBudget.setModel(new DefaultComboBoxModel(v));
    }

    protected Vector<Pair> getCollectivitesFromDocumentModel(DocumentModel dm) {
        Vector<Pair> ret = null;
        try {
            ret = DataLayerManager.getImplementation().getCollectivites(dm);
        }
        catch (DataAccessException daEx) {
            logger.warn((Object)"", (Throwable)daEx);
            ret = new Vector();
        }
        catch (DataConfigurationException dcEx) {
            logger.error((Object)"", (Throwable)dcEx);
            ret = new Vector();
        }
        return ret;
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.listeFichiers = new JXTreeTablePropertyEditor(this.selectionMultiple);
        this.bSelectAll = new JButton();
        this.bUnSelectAll = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.cbCollectivite = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.cbBudget = new JComboBox();
        this.jLabel4 = new JLabel();
        this.cbTypeDoc = new JComboBox();
        this.bRechercher = new JButton();
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Documents"));
        this.jPanel2.setMinimumSize(new Dimension(1031, 83));
        if (!this.selectionMultiple) {
            this.listeFichiers.getSelectionModel().setSelectionMode(1);
        }
        this.listeFichiers.setRootVisible(true);
        this.listeFichiers.setShowHorizontalLines(true);
        this.listeFichiers.setAutoResizeMode(3);
        this.jScrollPane2.setViewportView((Component)this.listeFichiers);
        this.bSelectAll.setText("Tout s\u00e9lectionner");
        this.bUnSelectAll.setText("Tout d\u00e9s\u00e9lectionner");
        if (!this.selectionMultiple) {
            this.bSelectAll.setEnabled(false);
            this.bUnSelectAll.setEnabled(false);
        }
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -1, 642, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(204, 204, 204).add((Component)this.bSelectAll).addPreferredGap(0).add((Component)this.bUnSelectAll))).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.bSelectAll).add((Component)this.bUnSelectAll)).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 185, Short.MAX_VALUE).addContainerGap()));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Recherche"));
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(0, 0));
        this.jLabel1.setText("S\u00e9lectionnez dans la liste ci-dessous le type de document, la collectivit\u00e9 et le budget");
        this.jLabel1.setVerticalAlignment(1);
        this.cbCollectivite.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cbCollectivite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelChooseDatabaseFichier.this.cbCollectiviteActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Collectivit\u00e9");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Budget");
        this.cbBudget.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cbBudget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelChooseDatabaseFichier.this.cbBudgetActionPerformed(evt);
            }
        });
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Type de document");
        this.cbTypeDoc.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cbTypeDoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelChooseDatabaseFichier.this.cbTypeDocActionPerformed(evt);
            }
        });
        this.bRechercher.setText("Rechercher");
        this.bRechercher.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelChooseDatabaseFichier.this.bRechercherActionPerformed(evt);
            }
        });
        this.bSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelChooseDatabaseFichier.this.bSelectAllPerformed(evt);
            }
        });
        this.bUnSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelChooseDatabaseFichier.this.bUnSelectAllPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel1, -1, 642, Short.MAX_VALUE).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jLabel2, -1, -1, Short.MAX_VALUE).add((Component)this.jLabel3, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jLabel4, -2, 136, -2)).add(12, 12, 12).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.cbBudget, 0, -1, Short.MAX_VALUE).add((Component)this.cbTypeDoc, 0, -1, Short.MAX_VALUE).add((Component)this.cbCollectivite, 0, 313, Short.MAX_VALUE)).addPreferredGap(0, 94, Short.MAX_VALUE).add((Component)this.bRechercher))).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.jLabel2, this.jLabel3, this.jLabel4}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).add(19, 19, 19).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.cbTypeDoc, -2, 22, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.cbCollectivite, -2, -1, -2)).add(7, 7, 7).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.cbBudget, -2, -1, -2).add((Component)this.bRechercher, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.cbBudget, this.cbCollectivite, this.cbTypeDoc}, 2);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jPanel1, -1, 680, Short.MAX_VALUE).add(1, (Component)this.jPanel2, 0, 680, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, 154, -2).addPreferredGap(0).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void cbTypeDocActionPerformed(ActionEvent evt) {
        this.fillColl();
    }

    private void bSelectAllPerformed(ActionEvent evt) {
        this.selectAllChilds(this.data.getData(), true);
        this.listeFichiers.repaint();
    }

    private void bUnSelectAllPerformed(ActionEvent evt) {
        this.selectAllChilds(this.data.getData(), false);
        this.listeFichiers.repaint();
    }

    private void selectAllChilds(DatabaseTreeDataFichier.Data d, boolean selected) {
        for (DatabaseTreeDataFichier.Data dd : d.getChilds()) {
            dd.setSelected(selected);
            this.selectAllChilds(dd, selected);
        }
    }

    private void bRechercherActionPerformed(ActionEvent evt) {
        try {
            String budg;
            String coll = ((Pair)this.cbCollectivite.getSelectedItem()).key;
            if ("RIEN".equals(coll)) {
                coll = null;
            }
            if ("RIEN".equals(budg = ((Pair)this.cbBudget.getSelectedItem()).key)) {
                budg = null;
            }
            if (this.cbTypeDoc.getSelectedIndex() == 0) {
                Vector<DatabaseTreeDataFichier.Data> datas = DataLayerManager.getImplementation().searchFichiers(this.dms, coll, budg);
                this.data = new DatabaseTreeDataFichier(datas, (JXTable)this.listeFichiers);
                this.data.setMode(this.getMode());
                this.data.setSelectionMultiple(this.selectionMultiple);
                this.listeFichiers.setTreeTableModel((TreeTableModel)this.data);
                this.listeFichiers.getColumnModel().getColumn(1).setMaxWidth(25);
                this.listeFichiers.setRootVisible(true);
            } else {
                String selectedDocId = ((Pair)this.cbTypeDoc.getSelectedItem()).key;
                Vector<DatabaseTreeDataFichier.Data> datas = new Vector<DatabaseTreeDataFichier.Data>();
                DatabaseTreeDataFichier.Data d = DataLayerManager.getImplementation().searchFichiers(this.dms.getDocumentById(selectedDocId), coll, budg);
                if (d != null) {
                    datas.add(d);
                }
                this.data = new DatabaseTreeDataFichier(datas, (JXTable)this.listeFichiers);
                this.data.setMode(this.getMode());
                this.data.setSelectionMultiple(this.selectionMultiple);
                this.listeFichiers.setTreeTableModel((TreeTableModel)this.data);
                this.listeFichiers.getColumnModel().getColumn(1).setMaxWidth(25);
                this.listeFichiers.setRootVisible(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public void refresh() {
        this.bRechercherActionPerformed(null);
    }

    private void cbBudgetActionPerformed(ActionEvent evt) {
    }

    private void cbCollectiviteActionPerformed(ActionEvent evt) {
        this.fillBudg();
    }

    public JXTreeTable getListeFichiers() {
        return this.listeFichiers;
    }

    public DocumentModel getDMSelected() {
        return this.dms.getDocumentById(((Pair)this.cbTypeDoc.getSelectedItem()).key);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    private class JXTreeTablePropertyEditor
    extends JXTreeTable {
        private TableCellEditor booleanEditor;
        private TableCellRenderer booleanRenderer;
        private TableCellRenderer booleanRendererExclusif;
        private TableCellRenderer blankRenderer;
        private boolean selectionMultiple = true;

        public JXTreeTablePropertyEditor(boolean selectionMultiple) {
            this.getSelectionModel().setSelectionMode(1);
            this.selectionMultiple = selectionMultiple;
            this.booleanEditor = new DefaultCellEditor(new JCheckBox()){

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                    JCheckBox chk = (JCheckBox)this.editorComponent;
                    chk.setSelected((Boolean)value);
                    chk.setBackground(c.getBackground());
                    return chk;
                }
            };
            this.booleanRendererExclusif = new DefaultTableCellRenderer(){
                private JRadioButton rb = new JRadioButton();

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.rb.setSelected((Boolean)value);
                    this.rb.setBackground(lbl.getBackground());
                    this.rb.setBorder(lbl.getBorder());
                    return this.rb;
                }
            };
            this.booleanRenderer = new DefaultTableCellRenderer(){
                private JCheckBox chk = new JCheckBox();

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.chk.setSelected((Boolean)value);
                    this.chk.setBackground(lbl.getBackground());
                    this.chk.setBorder(lbl.getBorder());
                    return this.chk;
                }
            };
            this.blankRenderer = new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    lbl.setText("");
                    return lbl;
                }
            };
        }

        public TableCellEditor getCellEditor(int row, int column) {
            if (row > 0 && column == 1) {
                if (this.selectionMultiple) {
                    return this.booleanEditor;
                }
                return this.booleanEditor;
            }
            return super.getCellEditor(row, column);
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            if (row == 0 && column == 1) {
                return this.blankRenderer;
            }
            if (column == 1) {
                if (this.selectionMultiple) {
                    return this.booleanRenderer;
                }
                Object o = PanelChooseDatabaseFichier.this.listeFichiers.getPathForRow(row).getLastPathComponent();
                if (PanelChooseDatabaseFichier.this.data.isCellEditable(o, column)) {
                    return this.booleanRendererExclusif;
                }
                return this.blankRenderer;
            }
            return super.getCellRenderer(row, column);
        }
    }
}

