/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseTreeDataDonnee
implements TreeModel {
    private static Logger logger = Logger.getLogger(DatabaseTreeDataDonnee.class);
    private ArrayList<TreeModelListener> listeners;
    private DocumentsModel dm;
    private DataNode root;

    public DatabaseTreeDataDonnee(DocumentsModel dm) {
        this.dm = dm;
        this.root = new DataNode(dm, 0);
        this.root.tree = this;
        this.loadChildren(this.root);
        this.listeners = new ArrayList();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        DataNode dn = (DataNode)parent;
        if (!dn.areChildrenLoaded()) {
            this.loadChildren(dn);
        }
        return dn.getChildren().elementAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        DataNode dn = (DataNode)parent;
        if (!dn.areChildrenLoaded()) {
            this.loadChildren(dn);
        }
        return dn.getChildren().size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        DataNode dn = (DataNode)parent;
        return dn.getChildren().indexOf(child);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        DataNode dn = (DataNode)node;
        if (dn.getType() == 5) {
            return true;
        }
        if (dn.getType() == 4 && dn.getChildCount() == 0) {
            return true;
        }
        return dn.getType() == 3 && dn.getChildCount() == 0;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    protected Vector<Pair> getCollectivitesFromDocumentModel(DocumentModel dm) {
        Vector<Pair> ret = null;
        try {
            ret = DataLayerManager.getImplementation().getCollectivites(dm);
        }
        catch (DataAccessException daEx) {
            logger.warn((Object)"", (Throwable)daEx);
            ret = new Vector();
        }
        catch (DataConfigurationException dcEx) {
            logger.error((Object)"", (Throwable)dcEx);
            ret = new Vector();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadChildren(DataNode dn) {
        switch (dn.getType()) {
            case 0: {
                for (DocumentModel doc : this.dm.getDocuments()) {
                    if (doc.getDisplayInMenuIf() != null && !"true".equals(System.getProperty(doc.getDisplayInMenuIf()))) continue;
                    dn.addChild(doc);
                }
                dn.childrenLoaded();
                break;
            }
            case 1: {
                Vector<Pair> collectivites = this.getCollectivitesFromDocumentModel((DocumentModel)dn.getData());
                for (Pair p : collectivites) {
                    dn.addChild(p);
                }
                dn.childrenLoaded();
                break;
            }
            case 2: {
                Vector<Object> budgets = null;
                try {
                    Pair collectivite = (Pair)dn.getData();
                    DocumentModel dm = (DocumentModel)dn.getParent().getData();
                    budgets = DataLayerManager.getImplementation().getBudgets(dm, collectivite);
                }
                catch (DataAccessException daEx) {
                    logger.error((Object)"", (Throwable)daEx);
                    budgets = new Vector();
                }
                catch (DataConfigurationException dcEx) {
                    logger.error((Object)"", (Throwable)dcEx);
                    budgets = new Vector();
                }
                for (Pair budget : budgets) {
                    dn.addChild(budget);
                }
                dn.childrenLoaded();
                break;
            }
            case 3: {
                MainWindow.getInstance().setCursor(new Cursor(3));
                DocumentModel doc = (DocumentModel)dn.getParent().getParent().getData();
                Pair collectivite = (Pair)dn.getParent().getData();
                Pair budget = (Pair)dn.getData();
                Vector<Object> ret = new Vector();
                try {
                    ret = DataLayerManager.getImplementation().getSpecialKeys1(doc, collectivite, budget, true);
                }
                catch (DataAccessException daEx) {
                    logger.error((Object)"", (Throwable)daEx);
                    ret = new Vector();
                }
                catch (DataConfigurationException dcEx) {
                    logger.error((Object)"", (Throwable)dcEx);
                    ret = new Vector();
                }
                finally {
                    MainWindow.getInstance().setCursor(Cursor.getDefaultCursor());
                }
                for (Pair pair : ret) {
                    dn.addChild(pair);
                }
                dn.childrenLoaded();
                break;
            }
            case 4: {
                MainWindow.getInstance().setCursor(new Cursor(3));
                DocumentModel doc = (DocumentModel)dn.getParent().getParent().getParent().getData();
                Pair collectivite = (Pair)dn.getParent().getParent().getData();
                Pair budget = (Pair)dn.getParent().getData();
                Pair key1 = (Pair)dn.getData();
                Vector<Pair> ret = null;
                try {
                    ret = DataLayerManager.getImplementation().getSpecialKeys2(doc, collectivite, budget, key1, true);
                }
                catch (DataAccessException dataAccessException) {
                    logger.error((Object)"", (Throwable)dataAccessException);
                    ret = new Vector();
                }
                catch (DataConfigurationException dataConfigurationException) {
                    logger.error((Object)"", (Throwable)dataConfigurationException);
                    ret = new Vector();
                }
                finally {
                    MainWindow.getInstance().setCursor(Cursor.getDefaultCursor());
                }
                for (Pair p : ret) {
                    dn.addChild(p);
                }
                dn.childrenLoaded();
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DataNode {
        public static final transient int TYPE_ROOT = 0;
        public static final transient int TYPE_DOCUMENT = 1;
        public static final transient int TYPE_COLLECTIVITE = 2;
        public static final transient int TYPE_BUDGET = 3;
        public static final transient int TYPE_PERSO1 = 4;
        public static final transient int TYPE_PERSO2 = 5;
        public static final transient int TYPE_PERSO3 = 6;
        private boolean areChildrenLoaded = false;
        private Object data;
        private int type;
        private Vector<DataNode> children;
        private DataNode parent;
        private DatabaseTreeDataDonnee tree = null;

        public DataNode(Object data, int type) {
            this.data = data;
            this.type = type;
            this.children = new Vector();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DataNode) {
                return this.data.equals(((DataNode)o).data);
            }
            return o.equals(this.data);
        }

        public String toString() {
            return this.data.toString();
        }

        public DataNode getParent() {
            return this.parent;
        }

        public Vector<DataNode> getChildren() {
            return this.children;
        }

        public void addChild(Object child) {
            if (child == null) {
                return;
            }
            DataNode node = null;
            node = !(child instanceof DataNode) ? new DataNode(child, this.type + 1) : (DataNode)child;
            node.parent = this;
            this.children.add(node);
            node.tree = this.tree;
        }

        public int getChildCount() {
            if (!this.areChildrenLoaded) {
                this.tree.loadChildren(this);
            }
            return this.children.size();
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public void childrenLoaded() {
            this.areChildrenLoaded = true;
        }

        public boolean areChildrenLoaded() {
            return this.areChildrenLoaded;
        }

        public int getType() {
            return this.type;
        }

        public Object getData() {
            return this.data;
        }
    }
}

