/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugins;

import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.xemelios.plugins.XemeliosPlugin;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public abstract class ExportPlugin
extends XemeliosPlugin {
    private static Logger logger = Logger.getLogger(ExportPlugin.class);
    private BufferedWriter bw;
    private Throwable exceptionDuringProcess = null;
    private String fileName = null;

    public BufferedWriter getWriter() {
        return this.bw;
    }

    public int getPluginType() {
        return 1;
    }

    public Long doInBackground() throws Exception {
        Long nbExport = new Long(0L);
        try {
            nbExport = this.doExport();
        }
        catch (Throwable t) {
            logger.error((Object)"in doExport:", t);
            this.exceptionDuringProcess = t;
        }
        return nbExport;
    }

    public abstract Long doExport() throws Exception;

    public abstract void computeParameters() throws Exception;

    public StringBuffer getBuffer() throws Exception {
        return (StringBuffer)this.get();
    }

    public void done() {
        super.done();
        this.terminate();
    }

    public void terminate() {
        try {
            if (this.getWriter() != null) {
                this.getWriter().flush();
                this.getWriter().close();
            }
        }
        catch (IOException ioEx) {
            logger.error((Object)"closing writer", (Throwable)ioEx);
        }
        this.setProgressVisible(false);
        if (this.exceptionDuringProcess != null) {
            new DisplayExceptionDlg((Frame)this.getSearchWindow().getParentFrame(), this.exceptionDuringProcess);
        }
        this.getSearchWindow().setSearchEnabled(true);
        try {
            logger.debug((Object)("finished: " + this.get().toString()));
        }
        catch (Throwable t) {
            logger.fatal((Object)"interrupted");
        }
    }

    public void startExport() throws Exception {
        this.computeParameters();
        File f = this.getFileToExportTo(this.getDefaultFileExtension());
        if (f != null) {
            this.fileName = f.toURL().toExternalForm();
            if (f.getName().indexOf(".") < 0) {
                f = new File(f.getParent(), f.getName() + "." + this.getDefaultFileExtension());
                this.fileName = f.toURL().toExternalForm();
            }
            this.bw = new BufferedWriter(new FileWriter(f));
            this.execute();
        } else {
            this.setProgressVisible(false);
            this.getSearchWindow().setSearchEnabled(true);
            this.getSearchWindow().setCursor(Cursor.getDefaultCursor());
            this.getSearchWindow().getParentFrame().stopWaiter();
        }
    }

    public FileFilter getFileFilter() {
        return null;
    }

    protected File getFileToExportTo(String defaultExtension) throws IOException {
        File ret = null;
        FileFilter ff = null;
        ff = this.getFileFilter();
        if (ff == null) {
            ff = new MyFileFilter(defaultExtension);
        }
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(ff);
        if (fc.showSaveDialog(this.getOwner()) == 0 && (ret = fc.getSelectedFile()).exists()) {
            int response = JOptionPane.showConfirmDialog(this.getOwner(), "Ce fichier existe d\u00e9j\u00e0. Voulez-vous l'\u00e9craser ?", "Confirmation", 1);
            switch (response) {
                case 2: {
                    ret = null;
                    break;
                }
                case 1: {
                    ret = this.getFileToExportTo(defaultExtension);
                    break;
                }
                case 0: {
                    ret.delete();
                }
            }
        }
        return ret;
    }

    protected String getFileName() {
        return this.fileName;
    }

    public abstract String getDefaultFileExtension();

    public static class MyFileFilter
    extends FileFilter {
        private String ext;

        public MyFileFilter(String extension) {
            this.ext = extension != null ? (extension.startsWith(".") ? extension : "." + extension) : "  ";
        }

        public boolean accept(File f) {
            return f.getName().endsWith(this.ext);
        }

        public String getDescription() {
            return "Fichiers " + this.ext.substring(1);
        }
    }
}

