/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.export;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.export.ExportChampModel;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportElementModel
implements XmlMarshallable {
    public static final transient String TAG = "element";
    public static final transient QName QN = new QName("element");
    private String id = "";
    private String libelle = "";
    private Vector<ExportChampModel> champs = new Vector();
    private Vector<ExportElementModel> enfants = new Vector();
    private ExportElementModel parent;

    public ExportElementModel(QName tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (ExportChampModel.QN.equals(tagName)) {
            this.champs.add((ExportChampModel)child);
        } else if (QN.equals(tagName)) {
            ExportElementModel e = (ExportElementModel)child;
            e.setParent(this);
            this.enfants.add(e);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.libelle = attributes.getValue("libelle");
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        output.addAttribute("libelle", this.libelle);
        for (ExportChampModel ecm : this.champs) {
            ecm.marshall(output);
        }
        for (ExportElementModel eem : this.enfants) {
            eem.marshall(output);
        }
        output.endTag(TAG);
    }

    public ExportElementModel clone() {
        ExportElementModel em = new ExportElementModel(QN);
        em.setId(this.id);
        em.setLibelle(this.libelle);
        em.setParent(this.parent.clone());
        for (ExportChampModel exportChampModel : this.champs) {
            try {
                em.addChild(exportChampModel, ExportChampModel.QN);
            }
            catch (Exception ex) {}
        }
        for (ExportElementModel exportElementModel : this.enfants) {
            try {
                em.addChild(exportElementModel, QN);
            }
            catch (Exception ex) {}
        }
        return em;
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public Vector<ExportElementModel> getEnfants() {
        return this.enfants;
    }

    public void setEnfants(Vector<ExportElementModel> enfants) {
        this.enfants = enfants;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Vector<ExportChampModel> getChamps() {
        return this.champs;
    }

    public void setChamps(Vector<ExportChampModel> champs) {
        this.champs = champs;
    }

    public void addEnfant(ExportElementModel enf) {
        if (this.enfants == null) {
            this.enfants = new Vector();
        }
        this.enfants.add(enf);
    }

    public void addChamp(ExportChampModel enf) {
        if (this.champs == null) {
            this.champs = new Vector();
        }
        this.champs.add(enf);
    }

    public String getLibelle() {
        return this.libelle;
    }

    public void setLibelle(String libelle) {
        this.libelle = libelle;
    }

    public String toString() {
        return this.getLibelle();
    }

    public boolean hasChampSelected() {
        for (ExportChampModel ecm : this.champs) {
            if (!ecm.isSelectionne()) continue;
            return true;
        }
        return false;
    }

    public void selectChampsKey() {
        for (ExportChampModel ecm : this.champs) {
            if (!ecm.isIdentifiant()) continue;
            ecm.setSelectionne(true);
        }
    }

    public void selectParentChampsKey() {
        for (ExportElementModel p = this.parent; p != null; p = p.getParent()) {
            p.selectChampsKey();
        }
    }

    public ExportElementModel getParent() {
        return this.parent;
    }

    public void setParent(ExportElementModel parent) {
        this.parent = parent;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        return null;
    }

    public QName getQName() {
        return QN;
    }
}

