/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.models;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.controls.models.InputModel;
import fr.gouv.finances.cp.xemelios.controls.models.SelectModel;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ParamModel
implements XmlMarshallable {
    private static Logger logger = Logger.getLogger(ParamModel.class);
    public static final transient String TAG = "param";
    public static final transient QName QN = new QName("param");
    public String id;
    public String name;
    public String datatype;
    public SelectModel select;
    public InputModel input;
    private Object value;
    private boolean optional = true;

    public ParamModel(QName tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (SelectModel.QN.equals(tagName)) {
            this.select = (SelectModel)child;
        } else if (InputModel.QN.equals(tagName)) {
            this.input = (InputModel)child;
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.name = attributes.getValue("name");
        this.datatype = attributes.getValue("datatype");
        if (attributes.getValue("use") != null) {
            String sTmp = attributes.getValue("use");
            this.optional = !"required".equals(sTmp);
        }
        this.value = attributes.getValue("value");
        if (this.value != null) {
            this.checkValueDatatype();
        }
        return this;
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.select != null && this.input != null) {
            throw new InvalidXmlDefinition("A param must not own an input and a select");
        }
        if (this.select == null && this.input == null) {
            throw new InvalidXmlDefinition("A param must own either a select or either an input");
        }
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        output.addAttribute("name", this.name);
        output.addAttribute("datatype", this.datatype);
        if (!this.isOptional()) {
            output.addAttribute("use", "required");
        }
        if (this.value != null) {
            output.addAttribute("value", this.value.toString());
        } else {
            output.addComment("no value specified");
        }
        if (this.select != null) {
            this.select.marshall(output);
        }
        if (this.input != null) {
            this.input.marshall(output);
        }
        output.endTag(TAG);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public InputModel getInput() {
        return this.input;
    }

    public SelectModel getSelect() {
        return this.select;
    }

    public ParamModel clone() {
        ParamModel pcm = new ParamModel(QN);
        pcm.id = this.id;
        pcm.name = this.name;
        pcm.datatype = this.datatype;
        pcm.select = this.select.clone();
        pcm.input = this.input.clone();
        pcm.value = this.value;
        return pcm;
    }

    public void setValue(Object o) {
        block19: {
            if (o == null) {
                this.value = o;
            } else {
                String sValue = o instanceof Pair ? ((Pair)o).key : (o instanceof Boolean ? ((Boolean)o).toString() : o.toString());
                if ("string".equals(this.datatype)) {
                    this.value = sValue;
                } else if ("integer".equals(this.datatype)) {
                    try {
                        String s = o.toString();
                        if (s.length() > 0) {
                            int i = Integer.parseInt(s);
                            this.value = new Integer(i);
                            break block19;
                        }
                        this.value = new Integer(0);
                    }
                    catch (Throwable t) {
                        logger.debug((Object)"parsing int", t);
                    }
                } else if ("decimal".equals(this.datatype)) {
                    try {
                        String s = o.toString();
                        if (s.length() > 0) {
                            BigDecimal bd = new BigDecimal(s);
                            this.value = bd;
                            break block19;
                        }
                        this.value = new BigDecimal(0.0);
                    }
                    catch (Throwable t) {
                        logger.debug((Object)"parsing BigDecimal", t);
                    }
                } else if ("boolean".equals(this.datatype)) {
                    boolean b = Boolean.valueOf(o.toString());
                    this.value = new Boolean(b);
                } else if ("date".equals(this.datatype)) {
                    SimpleDateFormat sdf = new SimpleDateFormat(System.getProperty("xemelios.date.format"));
                    try {
                        Date d = sdf.parse(o.toString());
                        this.value = d;
                    }
                    catch (Throwable t) {
                        logger.debug((Object)"parsing date", t);
                    }
                }
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isOptional() {
        return this.optional;
    }

    private void checkValueDatatype() {
        this.setValue(this.value);
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        QName tagName = new QName(uri, localName);
        if (SelectModel.QN.equals(tagName)) {
            return this.select;
        }
        if (InputModel.QN.equals(tagName)) {
            return this.input;
        }
        return null;
    }

    public QName getQName() {
        return QN;
    }
}

